# PHP Vulnerability Hunter
PHP Vulnerability Hunter is an whitebox fuzz testing tool capable of detected several classes of vulnerabilities in PHP web applications.

## Automated Input Mapping
While most web application fuzzers rely on the user to specify application inputs, PHP vulnerability hunter uses a combination of static and dynamic analysis to automatically map the target application. Because it works by instrumenting application, PHP Vulnerability Hunter can detect inputs that are not referenced in the forms of the rendered page.

## Scan Modes
PHP Vulnerability Hunter is aware of many different types of vulnerabilities found in PHP applications, from the most common such as cross-site scripting and local file inclusion to the lesser known, such as user controlled function invocation and class instantiation. 

PHP Vulnerability Hunter can detect the following classes of vulnerabilities:
* Arbitrary command execution
* Arbitrary file read/write/change/rename/delete
* Local file inclusion
* Arbitrary PHP execution
* SQL injection
* User controlled function invocatino
* User controlled class instantiation
* Reflected cross-site scripting (XSS)
* Open redirect
* Full path disclosure

## Code Coverage
Get measurements of how much code was executed during a scan, broken down by scan plugin and page. Code coverage can be calculated at either the function level or the code block level.

## Scan Phases
**Initialization Phase**
During this phase, interesting function calls within each code file are hooked, and if code coverage is enabled the code is annotated. Static analysis is performed on the code to detect inputs.

**Scan Phase**
This is where the bugs are uncovered. PHP Vulnerability Hunter iterates through its different scan plugins and plugin modes, scanning every file within the targeted application. Each time a page is requested, dynamic analysis is performed to discover new inputs and bugs.

**Uninitialization**
Once the scan phase is complete, all of the application files are restored from backups made during the initialization phase.