//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by llex.
// </auto-generated>
//------------------------------------------------------------------------------

#pragma warning disable 0162
using System;
using System.Collections.Generic;

namespace LLex
{
    [global::System.CodeDom.Compiler.GeneratedCodeAttribute("llex", "1")]
    public enum RegexTokenType : short
    {
        None,
        Character,
        EndOfFile,
        LeftBracket,
        LeftParenthesis,
        OneOrMoreQuantifier,
        OrOperator,
        RightBracket,
        RightParenthesis,
        SpecialCharacter,
        Unknown,
        ZeroOrMoreQuantifier,
        ZeroOrOneQuantifier
    }

    [global::System.CodeDom.Compiler.GeneratedCodeAttribute("llex", "1")]
    public struct RegexToken
    {
        public RegexTokenType TokenType;
        public string Lexeme;
        public int Index;

        public RegexToken(RegexTokenType tokenType, string lexeme, int index)
        {
            TokenType = tokenType;
            Lexeme = lexeme;
            Index = index;
        }

        public override string ToString()
        {
            return string.Format("[{0}] {1}: {2}", Index, TokenType, Lexeme);
        }

        public bool IsKeyword()
        {
            return false;
        }
    }

    [global::System.CodeDom.Compiler.GeneratedCodeAttribute("llex", "1")]
    public class RegexLexer
    {
        private string text = "";

        public string Text
        {
            get { return text; }
            set
            {
                text = value;
                lastIndex = text.Length - 1;
            }
        }

        int lastIndex = -1;

        int charIndex = -1;

        int mode = 0;

        int state = 0;

        char currentChar = (char)0;

        public RegexLexer()
        {
        }

        public RegexLexer(string text)
        {
            Text = text;
        }

        bool NextChar()
        {
            if (charIndex < lastIndex)
            {
                currentChar = text[++charIndex];
                return true;
            }

            return false;
        }

        private RegexTokenType GetToken()
        {

            if (mode == 0)
            {
                if (charIndex < lastIndex)
                {
                    currentChar = text[++charIndex];

                    switch (currentChar)
                    {
                        case '(':

                            return RegexTokenType.LeftParenthesis;

                        case ')':

                            return RegexTokenType.RightParenthesis;

                        case '[':

                            return RegexTokenType.LeftBracket;

                        case ']':

                            return RegexTokenType.RightBracket;

                        case '|':

                            return RegexTokenType.OrOperator;

                        case '?':

                            return RegexTokenType.ZeroOrOneQuantifier;

                        case '*':

                            return RegexTokenType.ZeroOrMoreQuantifier;

                        case '+':

                            return RegexTokenType.OneOrMoreQuantifier;

                        case '\\':
                            if (charIndex < lastIndex)
                            {
                                currentChar = text[++charIndex];

                                switch (currentChar)
                                {
                                    case 's':

                                        return RegexTokenType.SpecialCharacter;

                                    case 'r':

                                        return RegexTokenType.SpecialCharacter;

                                    case 'n':

                                        return RegexTokenType.SpecialCharacter;

                                    case 't':

                                        return RegexTokenType.SpecialCharacter;

                                    case 'v':

                                        return RegexTokenType.SpecialCharacter;

                                    case '(':

                                        return RegexTokenType.Character;

                                    case ')':

                                        return RegexTokenType.Character;

                                    case '[':

                                        return RegexTokenType.Character;

                                    case ']':

                                        return RegexTokenType.Character;

                                    case '|':

                                        return RegexTokenType.Character;

                                    case '?':

                                        return RegexTokenType.Character;

                                    case '*':

                                        return RegexTokenType.Character;

                                    case '+':

                                        return RegexTokenType.Character;

                                    case '\\':

                                        return RegexTokenType.Character;

                                }

                                charIndex--;
                            }
                            return RegexTokenType.Unknown;

                        default:
                            return RegexTokenType.Character;

                            break;

                    }

                    return RegexTokenType.Unknown;
                }
            }


            return RegexTokenType.EndOfFile;
        }

        public List<RegexToken> GetTokens()
        {
            charIndex = -1;

            RegexTokenType tokenType;

            int lastIndex = -1;

            var tokens = new List<RegexToken>();

            while ((tokenType = GetToken()) != RegexTokenType.EndOfFile)
            {
                var index = lastIndex + 1;
                var lexeme = text.Substring(index, charIndex - lastIndex);

                tokens.Add(new RegexToken(tokenType, lexeme, index));

                lastIndex = charIndex;
            }

            return tokens;
        }
    }
}
#pragma warning restore 0162