#!/usr/bin/python

# On The Outside, Reaching In ("OTORI")
# Copyright 2014 Ben Lincoln
# http://www.beneaththewaves.net/
#

# This file is part of On The Outside, Reaching In ("OTORI").

# On The Outside, Reaching In ("OTORI") is free software: you can redistribute it and/or modify
# it under the terms of version 3 of the GNU General Public License as published by
# the Free Software Foundation.

# On The Outside, Reaching In ("OTORI") is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with On The Outside, Reaching In ("OTORI") (in the file LICENSE.txt).  
# If not, see <http://www.gnu.org/licenses/>.

import base64
import httplib
import inspect
import json
import os
import random
import re
import sys
import urllib

import libdeceitfulhttp
import liboutput
import libxxeexploits

import xxeexploitmodulesapachesolr
import xxeexploitmodulesgeneric
import xxeexploitmodulesmahara
import xxeexploitmodulesmcafeeepo
import xxeexploitmodulessquizmatrix

# this is the library which contains all functional exploit modules
# changes to the base classes and shared utility functions should go in libxxeexploits

# this is a bit of a hack, but doing it the right way with inspection is a lower priority than releasing a working version
# when adding new modules (which actually work for end users), be sure to add them to the results of this class' getModules function
class XXEExploitModuleEnumerator:
	@staticmethod	
	def getModules():
		moduleList = []
		moduleList.append(xxeexploitmodulesgeneric.XXEGenericBasic())
		moduleList.append(xxeexploitmodulesgeneric.XXEGenericYunusovOsipov())
		moduleList.append(xxeexploitmodulesmahara.XXEMaharaCVE20122239ME())
		moduleList.append(xxeexploitmodulesmahara.XXEMaharaCVE20122239PCA())
		moduleList.append(xxeexploitmodulesmahara.XXEMaharaCVE20122239PCU())
		moduleList.append(xxeexploitmodulesmcafeeepo.XXEMcAfeeEPOCVE20142205D())
		#moduleList.append(xxeexploitmodulesmcafeeepo.XXEMcAfeeEPOCVE20142205N())
		moduleList.append(xxeexploitmodulesapachesolr.XXESolrCVE20136407DARH())
		moduleList.append(xxeexploitmodulesapachesolr.XXESolrCVE20136407URHDI())
		moduleList.append(xxeexploitmodulesapachesolr.XXESolrCVE20136407URHNMVF())
		moduleList.append(xxeexploitmodulessquizmatrix.XXESquizMatrixSOS12007YU404())
		moduleList.append(xxeexploitmodulessquizmatrix.XXESquizMatrixSOS12007YUIU())
		moduleList.append(xxeexploitmodulessquizmatrix.XXESquizMatrixSOS12007YUOOB())
		return moduleList

