/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProduceException;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducer;

class MimeMessageProducerMixedRelatedAlternative
extends MimeMessageProducer {
    MimeMessageProducerMixedRelatedAlternative() {
    }

    @Override
    public boolean compatibleWithEmail(@NotNull Email email) {
        return MimeMessageProducerMixedRelatedAlternative.emailContainsMixedContent(email) && MimeMessageProducerMixedRelatedAlternative.emailContainsRelatedContent(email) && MimeMessageProducerMixedRelatedAlternative.emailContainsAlternativeContent(email);
    }

    @Override
    public void populateMimeMessageMultipartStructure(@NotNull MimeMessage message, @NotNull Email email) throws MessagingException {
        MultipartStructureWrapper multipartStructureWrapper = new MultipartStructureWrapper();
        MimeMessageHelper.setTexts(email, multipartStructureWrapper.multipartAlternativeMessages);
        MimeMessageHelper.configureForwarding(email, multipartStructureWrapper.multipartRootMixed);
        MimeMessageHelper.setEmbeddedImages(email, multipartStructureWrapper.multipartRelated);
        MimeMessageHelper.setAttachments(email, multipartStructureWrapper.multipartRootMixed);
        message.setContent(multipartStructureWrapper.multipartRootMixed);
    }

    private static class MultipartStructureWrapper {
        private final MimeMultipart multipartRootMixed = new MimeMultipart("mixed");
        private final MimeMultipart multipartRelated;
        private final MimeMultipart multipartAlternativeMessages;

        private MultipartStructureWrapper() {
            MimeBodyPart contentRelated = new MimeBodyPart();
            this.multipartRelated = new MimeMultipart("related");
            MimeBodyPart contentAlternativeMessages = new MimeBodyPart();
            this.multipartAlternativeMessages = new MimeMultipart("alternative");
            try {
                this.multipartRootMixed.addBodyPart(contentRelated);
                contentRelated.setContent(this.multipartRelated);
                this.multipartRelated.addBodyPart(contentAlternativeMessages);
                contentAlternativeMessages.setContent(this.multipartAlternativeMessages);
            }
            catch (MessagingException e2) {
                throw new MimeMessageProduceException(e2.getMessage(), e2);
            }
        }
    }
}

