/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.converter.internal.mimemessage.ImmutableDelegatingSMTPMessage;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.internal.modules.ModuleLoader;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.SimpleOptional;

public abstract class MimeMessageProducer {
    abstract boolean compatibleWithEmail(@NotNull Email var1);

    final MimeMessage populateMimeMessage(final @NotNull Email email, @NotNull Session session) throws MessagingException, UnsupportedEncodingException {
        MiscUtil.checkArgumentNotEmpty(email, "email is missing");
        MiscUtil.checkArgumentNotEmpty(session, "session is needed, it cannot be attached later");
        MimeMessage message = new MimeMessage(session){

            @Override
            protected void updateMessageID() throws MessagingException {
                if (MiscUtil.valueNullOrEmpty(email.getId())) {
                    super.updateMessageID();
                } else {
                    this.setHeader("Message-ID", email.getId());
                }
            }

            public String toString() {
                try {
                    return "MimeMessage<id:" + super.getMessageID() + ", subject:" + super.getSubject() + ">";
                }
                catch (MessagingException e2) {
                    throw new IllegalStateException("should not reach here");
                }
            }
        };
        MimeMessageHelper.setSubject(email, message);
        MimeMessageHelper.setFrom(email, message);
        MimeMessageHelper.setReplyTo(email, message);
        MimeMessageHelper.setRecipients(email, message);
        this.populateMimeMessageMultipartStructure(message, email);
        MimeMessageHelper.setHeaders(email, message);
        message.setSentDate(SimpleOptional.ofNullable(email.getSentDate()).orElse(new Date()));
        if (ModuleLoader.smimeModuleAvailable()) {
            message = ModuleLoader.loadSmimeModule().signAndOrEncryptEmail(session, message, email);
        }
        if (!MiscUtil.valueNullOrEmpty(email.getDkimSigningDomain())) {
            message = ModuleLoader.loadDKIMModule().signMessageWithDKIM(message, email);
        }
        if (email.getBounceToRecipient() != null) {
            message = new ImmutableDelegatingSMTPMessage(message, email.getBounceToRecipient().getAddress());
        }
        return message;
    }

    abstract void populateMimeMessageMultipartStructure(@NotNull MimeMessage var1, @NotNull Email var2) throws MessagingException;

    static boolean emailContainsMixedContent(@NotNull Email email) {
        return !email.getAttachments().isEmpty() || email.getEmailToForward() != null;
    }

    static boolean emailContainsRelatedContent(@NotNull Email email) {
        return !email.getEmbeddedImages().isEmpty();
    }

    static boolean emailContainsAlternativeContent(@NotNull Email email) {
        return (email.getPlainText() != null ? 1 : 0) + (email.getHTMLText() != null ? 1 : 0) + (email.getCalendarText() != null ? 1 : 0) > 1;
    }
}

