/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import com.sun.mail.handlers.text_plain;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.ActivationDataFlavor;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.mail.util.ByteArrayDataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParseException;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.internal.util.SimpleOptional;

public final class MimeMessageParser {
    private static final List<String> HEADERS_TO_IGNORE = new ArrayList<String>();

    public static ParsedMimeMessageComponents parseMimeMessage(@NotNull MimeMessage mimeMessage) {
        ParsedMimeMessageComponents parsedComponents = new ParsedMimeMessageComponents();
        parsedComponents.messageId = MimeMessageParser.parseMessageId(mimeMessage);
        parsedComponents.sentDate = MimeMessageParser.parseSentDate(mimeMessage);
        parsedComponents.subject = MimeMessageParser.parseSubject(mimeMessage);
        parsedComponents.toAddresses.addAll(MimeMessageParser.parseToAddresses(mimeMessage));
        parsedComponents.ccAddresses.addAll(MimeMessageParser.parseCcAddresses(mimeMessage));
        parsedComponents.bccAddresses.addAll(MimeMessageParser.parseBccAddresses(mimeMessage));
        parsedComponents.fromAddress = MimeMessageParser.parseFromAddress(mimeMessage);
        parsedComponents.replyToAddresses = MimeMessageParser.parseReplyToAddresses(mimeMessage);
        MimeMessageParser.parseMimePartTree(mimeMessage, parsedComponents);
        MimeMessageParser.moveInvalidEmbeddedResourcesToAttachments(parsedComponents);
        return parsedComponents;
    }

    private static void parseMimePartTree(@NotNull MimePart currentPart, @NotNull ParsedMimeMessageComponents parsedComponents) {
        for (Header header : MimeMessageParser.retrieveAllHeaders(currentPart)) {
            MimeMessageParser.parseHeader(header, parsedComponents);
        }
        String disposition = MimeMessageParser.parseDisposition(currentPart);
        if (MimeMessageParser.isMimeType(currentPart, "text/plain") && !"attachment".equalsIgnoreCase(disposition)) {
            parsedComponents.plainContent.append(MimeMessageParser.parseContent(currentPart));
        } else if (MimeMessageParser.isMimeType(currentPart, "text/html") && !"attachment".equalsIgnoreCase(disposition)) {
            parsedComponents.htmlContent.append(MimeMessageParser.parseContent(currentPart));
        } else if (MimeMessageParser.isMimeType(currentPart, "text/calendar") && parsedComponents.calendarContent == null && !"attachment".equalsIgnoreCase(disposition)) {
            parsedComponents.calendarContent = MimeMessageParser.parseCalendarContent(currentPart);
            parsedComponents.calendarMethod = MimeMessageParser.parseCalendarMethod(currentPart);
        } else if (MimeMessageParser.isMimeType(currentPart, "multipart/*")) {
            Multipart mp = (Multipart)MimeMessageParser.parseContent(currentPart);
            int count = MimeMessageParser.countBodyParts(mp);
            for (int i2 = 0; i2 < count; ++i2) {
                MimeMessageParser.parseMimePartTree(MimeMessageParser.getBodyPartAtIndex(mp, i2), parsedComponents);
            }
        } else {
            DataSource ds2 = MimeMessageParser.createDataSource(currentPart);
            if ("attachment".equalsIgnoreCase(disposition)) {
                parsedComponents.attachmentList.put(MimeMessageParser.parseResourceNameOrUnnamed(MimeMessageParser.parseContentID(currentPart), MimeMessageParser.parseFileName(currentPart)), ds2);
            } else if (disposition == null || "inline".equalsIgnoreCase(disposition)) {
                if (MimeMessageParser.parseContentID(currentPart) != null) {
                    parsedComponents.cidMap.put(MimeMessageParser.parseContentID(currentPart), ds2);
                } else {
                    parsedComponents.attachmentList.put(MimeMessageParser.parseResourceNameOrUnnamed(null, MimeMessageParser.parseFileName(currentPart)), ds2);
                }
            } else {
                throw new IllegalStateException("invalid attachment type");
            }
        }
    }

    private static void parseHeader(Header header, @NotNull ParsedMimeMessageComponents parsedComponents) {
        if (MimeMessageParser.isEmailHeader(header, "Disposition-Notification-To")) {
            parsedComponents.dispositionNotificationTo = MimeMessageParser.createAddress(header.getValue(), "Disposition-Notification-To");
        } else if (MimeMessageParser.isEmailHeader(header, "Return-Receipt-To")) {
            parsedComponents.returnReceiptTo = MimeMessageParser.createAddress(header.getValue(), "Return-Receipt-To");
        } else if (MimeMessageParser.isEmailHeader(header, "Return-Path")) {
            parsedComponents.bounceToAddress = MimeMessageParser.createAddress(header.getValue(), "Return-Path");
        } else if (!HEADERS_TO_IGNORE.contains(header.getName())) {
            if (!parsedComponents.headers.containsKey(header.getName())) {
                parsedComponents.headers.put(header.getName(), new ArrayList());
            }
            ((Collection)parsedComponents.headers.get(header.getName())).add(header.getValue());
        }
    }

    private static boolean isEmailHeader(Header header, String emailHeaderName) {
        return header.getName().equals(emailHeaderName) && !MiscUtil.valueNullOrEmpty(header.getValue()) && !MiscUtil.valueNullOrEmpty(header.getValue().trim()) && !header.getValue().equals("<>");
    }

    public static String parseFileName(@NotNull Part currentPart) {
        try {
            return currentPart.getFileName();
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException("Error getting file name", e2);
        }
    }

    public static String parseCalendarContent(@NotNull MimePart currentPart) {
        Object content = MimeMessageParser.parseContent(currentPart);
        if (content instanceof InputStream) {
            InputStream calendarContent = (InputStream)content;
            try {
                return MiscUtil.readInputStreamToString(calendarContent, StandardCharsets.UTF_8);
            }
            catch (IOException e2) {
                throw new MimeMessageParseException("Error parsing MimeMessage Calendar content", e2);
            }
        }
        return String.valueOf(content);
    }

    public static String parseCalendarMethod(@NotNull MimePart currentPart) {
        String contentType;
        Pattern compile = Pattern.compile("method=\"?(\\w+)");
        try {
            contentType = currentPart.getDataHandler().getContentType();
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException("Error getting content type from Calendar bodypart. Unable to determine Calendar METHOD", e2);
        }
        Matcher matcher = compile.matcher(contentType);
        Preconditions.assumeTrue(matcher.find(), "Calendar METHOD not found in bodypart content type");
        return matcher.group(1);
    }

    @Nullable
    public static String parseContentID(@NotNull MimePart currentPart) {
        try {
            return currentPart.getContentID();
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException("Error getting content ID", e2);
        }
    }

    public static MimeBodyPart getBodyPartAtIndex(Multipart parentMultiPart, int index) {
        try {
            return (MimeBodyPart)parentMultiPart.getBodyPart(index);
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException(String.format("Error getting bodypart at index %s", index), e2);
        }
    }

    public static int countBodyParts(Multipart mp) {
        try {
            return mp.getCount();
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException("Error parsing MimeMessage multipart count", e2);
        }
    }

    public static <T> T parseContent(@NotNull MimePart currentPart) {
        try {
            return (T)currentPart.getContent();
        }
        catch (IOException | MessagingException e2) {
            throw new MimeMessageParseException("Error parsing MimeMessage Content", e2);
        }
    }

    @Nullable
    public static String parseDisposition(@NotNull MimePart currentPart) {
        try {
            return currentPart.getDisposition();
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException("Error parsing MimeMessage disposition", e2);
        }
    }

    @NotNull
    private static String parseResourceNameOrUnnamed(@Nullable String possibleWrappedContentID, @NotNull String fileName) {
        String resourceName = MimeMessageParser.parseResourceName(possibleWrappedContentID, fileName);
        return MiscUtil.valueNullOrEmpty(resourceName) ? "unnamed" : resourceName;
    }

    @NotNull
    private static String parseResourceName(@Nullable String possibleWrappedContentID, @NotNull String fileName) {
        if (MiscUtil.valueNullOrEmpty(fileName) && !MiscUtil.valueNullOrEmpty(possibleWrappedContentID)) {
            return possibleWrappedContentID.replaceAll("^<?(.*?)>?$", "$1");
        }
        return fileName;
    }

    @NotNull
    public static List<Header> retrieveAllHeaders(@NotNull MimePart part) {
        try {
            return Collections.list(part.getAllHeaders());
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException("Error getting all headers", e2);
        }
    }

    @Nullable
    static InternetAddress createAddress(String address, String typeOfAddress) {
        try {
            return address.trim().isEmpty() ? null : new InternetAddress(address);
        }
        catch (AddressException e2) {
            if (e2.getMessage().equals("Empty address")) {
                return null;
            }
            throw new MimeMessageParseException(String.format("Error parsing [%s] address [%s]", typeOfAddress, address), e2);
        }
    }

    public static boolean isMimeType(@NotNull MimePart part, @NotNull String mimeType) {
        try {
            ContentType contentType = new ContentType(MimeMessageParser.retrieveDataHandler(part).getContentType());
            return contentType.match(mimeType);
        }
        catch (ParseException ex2) {
            return MimeMessageParser.retrieveContentType(part).equalsIgnoreCase(mimeType);
        }
    }

    public static String retrieveContentType(@NotNull MimePart part) {
        try {
            return part.getContentType();
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException("Error getting content type", e2);
        }
    }

    public static DataHandler retrieveDataHandler(@NotNull MimePart part) {
        try {
            return part.getDataHandler();
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException("Error getting data handler", e2);
        }
    }

    @NotNull
    private static DataSource createDataSource(@NotNull MimePart part) {
        DataHandler dataHandler = MimeMessageParser.retrieveDataHandler(part);
        DataSource dataSource = dataHandler.getDataSource();
        String contentType = MimeMessageParser.parseBaseMimeType(dataSource.getContentType());
        byte[] content = MimeMessageParser.readContent(MimeMessageParser.retrieveInputStream(dataSource));
        ByteArrayDataSource result = new ByteArrayDataSource(content, contentType);
        String dataSourceName = MimeMessageParser.parseDataSourceName(part, dataSource);
        result.setName(dataSourceName);
        return result;
    }

    public static InputStream retrieveInputStream(DataSource dataSource) {
        try {
            return dataSource.getInputStream();
        }
        catch (IOException e2) {
            throw new MimeMessageParseException("Error getting input stream", e2);
        }
    }

    @Nullable
    private static String parseDataSourceName(@NotNull Part part, @NotNull DataSource dataSource) {
        String result = !MiscUtil.valueNullOrEmpty(dataSource.getName()) ? dataSource.getName() : MimeMessageParser.parseFileName(part);
        return !MiscUtil.valueNullOrEmpty(result) ? MimeMessageParser.decodeText(result) : null;
    }

    @NotNull
    private static String decodeText(@NotNull String result) {
        try {
            return MimeUtility.decodeText(result);
        }
        catch (UnsupportedEncodingException e2) {
            throw new MimeMessageParseException("Error decoding text", e2);
        }
    }

    @NotNull
    private static byte[] readContent(@NotNull InputStream is2) {
        try {
            return MiscUtil.readInputStreamToBytes(is2);
        }
        catch (IOException e2) {
            throw new MimeMessageParseException("Error reading content", e2);
        }
    }

    @NotNull
    private static String parseBaseMimeType(@NotNull String fullMimeType) {
        int pos = fullMimeType.indexOf(59);
        if (pos >= 0) {
            return fullMimeType.substring(0, pos);
        }
        return fullMimeType;
    }

    @NotNull
    public static List<InternetAddress> parseToAddresses(@NotNull MimeMessage mimeMessage) {
        return MimeMessageParser.parseInternetAddresses(MimeMessageParser.retrieveRecipients(mimeMessage, Message.RecipientType.TO));
    }

    @NotNull
    public static List<InternetAddress> parseCcAddresses(@NotNull MimeMessage mimeMessage) {
        return MimeMessageParser.parseInternetAddresses(MimeMessageParser.retrieveRecipients(mimeMessage, Message.RecipientType.CC));
    }

    @NotNull
    public static List<InternetAddress> parseBccAddresses(@NotNull MimeMessage mimeMessage) {
        return MimeMessageParser.parseInternetAddresses(MimeMessageParser.retrieveRecipients(mimeMessage, Message.RecipientType.BCC));
    }

    @Nullable
    public static Address[] retrieveRecipients(@NotNull MimeMessage mimeMessage, Message.RecipientType recipientType) {
        try {
            String s2 = mimeMessage.getHeader(MimeMessageParser.getHeaderName(recipientType), ",");
            return s2 == null ? null : InternetAddress.parseHeader(s2, false);
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException(String.format("Error getting [%s] recipient types", recipientType), e2);
        }
    }

    private static String getHeaderName(Message.RecipientType recipientType) {
        if (recipientType == Message.RecipientType.TO) {
            return "To";
        }
        if (recipientType == Message.RecipientType.CC) {
            return "Cc";
        }
        Preconditions.assumeTrue(recipientType == Message.RecipientType.BCC, "invalid recipient type: " + recipientType);
        return "Bcc";
    }

    @NotNull
    private static List<InternetAddress> parseInternetAddresses(@Nullable Address[] recipients) {
        ArrayList addresses = recipients != null ? Arrays.asList(recipients) : new ArrayList();
        ArrayList<InternetAddress> mailAddresses = new ArrayList<InternetAddress>();
        for (Address address : addresses) {
            if (!(address instanceof InternetAddress)) continue;
            mailAddresses.add((InternetAddress)address);
        }
        return mailAddresses;
    }

    @Nullable
    public static InternetAddress parseFromAddress(@NotNull MimeMessage mimeMessage) {
        try {
            Address[] addresses = mimeMessage.getFrom();
            return addresses == null || addresses.length == 0 ? null : (InternetAddress)addresses[0];
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException("Error parsing from-address", e2);
        }
    }

    @Nullable
    public static InternetAddress parseReplyToAddresses(@NotNull MimeMessage mimeMessage) {
        try {
            Address[] addresses = mimeMessage.getReplyTo();
            return addresses == null || addresses.length == 0 ? null : (InternetAddress)addresses[0];
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException("Error parsing replyTo addresses", e2);
        }
    }

    @NotNull
    public static String parseSubject(@NotNull MimeMessage mimeMessage) {
        try {
            return SimpleOptional.ofNullable(mimeMessage.getSubject()).orElse("");
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException("Error getting subject", e2);
        }
    }

    @Nullable
    public static String parseMessageId(@NotNull MimeMessage mimeMessage) {
        try {
            return mimeMessage.getMessageID();
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException("Error getting message ID", e2);
        }
    }

    @Nullable
    public static Date parseSentDate(@NotNull MimeMessage mimeMessage) {
        try {
            return mimeMessage.getSentDate();
        }
        catch (MessagingException e2) {
            throw new MimeMessageParseException("Error getting sent-date", e2);
        }
    }

    static void moveInvalidEmbeddedResourcesToAttachments(ParsedMimeMessageComponents parsedComponents) {
        String htmlContent = parsedComponents.htmlContent.toString();
        Iterator<Map.Entry<String, DataSource>> it2 = parsedComponents.cidMap.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry<String, DataSource> cidEntry = it2.next();
            String cid = MiscUtil.extractCID(cidEntry.getKey());
            if (htmlContent.contains("cid:" + cid)) continue;
            parsedComponents.attachmentList.put(cid, cidEntry.getValue());
            it2.remove();
        }
    }

    static {
        HEADERS_TO_IGNORE.add("Received");
        HEADERS_TO_IGNORE.add("Resent-Date");
        HEADERS_TO_IGNORE.add("Resent-From");
        HEADERS_TO_IGNORE.add("Resent-Sender");
        HEADERS_TO_IGNORE.add("Resent-To");
        HEADERS_TO_IGNORE.add("Resent-Cc");
        HEADERS_TO_IGNORE.add("Resent-Bcc");
        HEADERS_TO_IGNORE.add("Resent-Message-Id");
        HEADERS_TO_IGNORE.add("Date");
        HEADERS_TO_IGNORE.add("From");
        HEADERS_TO_IGNORE.add("Sender");
        HEADERS_TO_IGNORE.add("Reply-To");
        HEADERS_TO_IGNORE.add("To");
        HEADERS_TO_IGNORE.add("Cc");
        HEADERS_TO_IGNORE.add("Bcc");
        HEADERS_TO_IGNORE.add("Message-Id");
        HEADERS_TO_IGNORE.add("Subject");
        HEADERS_TO_IGNORE.add("Comments");
        HEADERS_TO_IGNORE.add("Keywords");
        HEADERS_TO_IGNORE.add("Errors-To");
        HEADERS_TO_IGNORE.add("MIME-Version");
        HEADERS_TO_IGNORE.add("Content-Type");
        HEADERS_TO_IGNORE.add("Content-Transfer-Encoding");
        HEADERS_TO_IGNORE.add("Content-MD5");
        HEADERS_TO_IGNORE.add(":");
        HEADERS_TO_IGNORE.add("Content-Length");
        HEADERS_TO_IGNORE.add("Status");
        HEADERS_TO_IGNORE.add("Content-Disposition");
        HEADERS_TO_IGNORE.add("size");
        HEADERS_TO_IGNORE.add("filename");
        HEADERS_TO_IGNORE.add("Content-ID");
        HEADERS_TO_IGNORE.add("name");
        HEADERS_TO_IGNORE.add("From");
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("text/calendar;; x-java-content-handler=" + text_calendar.class.getName());
        CommandMap.setDefaultCommandMap(mc);
    }

    static class text_calendar
    extends text_plain {
        private static final ActivationDataFlavor[] myDF = new ActivationDataFlavor[]{new ActivationDataFlavor(String.class, "text/calendar", "iCalendar String")};

        text_calendar() {
        }

        @Override
        protected ActivationDataFlavor[] getDataFlavors() {
            return myDF;
        }
    }

    public static class ParsedMimeMessageComponents {
        final Map<String, DataSource> attachmentList = new TreeMap<String, DataSource>();
        final Map<String, DataSource> cidMap = new TreeMap<String, DataSource>();
        private final Map<String, Collection<Object>> headers = new HashMap<String, Collection<Object>>();
        private final List<InternetAddress> toAddresses = new ArrayList<InternetAddress>();
        private final List<InternetAddress> ccAddresses = new ArrayList<InternetAddress>();
        private final List<InternetAddress> bccAddresses = new ArrayList<InternetAddress>();
        private String messageId;
        private String subject;
        private InternetAddress fromAddress;
        private InternetAddress replyToAddresses;
        private InternetAddress dispositionNotificationTo;
        private InternetAddress returnReceiptTo;
        private InternetAddress bounceToAddress;
        private final StringBuilder plainContent = new StringBuilder();
        final StringBuilder htmlContent = new StringBuilder();
        private String calendarMethod;
        private String calendarContent;
        private Date sentDate;

        @Nullable
        public String getMessageId() {
            return this.messageId;
        }

        public Map<String, DataSource> getAttachmentList() {
            return this.attachmentList;
        }

        public Map<String, DataSource> getCidMap() {
            return this.cidMap;
        }

        public Map<String, Collection<Object>> getHeaders() {
            return this.headers;
        }

        public List<InternetAddress> getToAddresses() {
            return this.toAddresses;
        }

        public List<InternetAddress> getCcAddresses() {
            return this.ccAddresses;
        }

        public List<InternetAddress> getBccAddresses() {
            return this.bccAddresses;
        }

        @Nullable
        public String getSubject() {
            return this.subject;
        }

        @Nullable
        public InternetAddress getFromAddress() {
            return this.fromAddress;
        }

        @Nullable
        public InternetAddress getReplyToAddresses() {
            return this.replyToAddresses;
        }

        @Nullable
        public InternetAddress getDispositionNotificationTo() {
            return this.dispositionNotificationTo;
        }

        @Nullable
        public InternetAddress getReturnReceiptTo() {
            return this.returnReceiptTo;
        }

        @Nullable
        public InternetAddress getBounceToAddress() {
            return this.bounceToAddress;
        }

        @Nullable
        public String getPlainContent() {
            return this.plainContent.length() == 0 ? null : this.plainContent.toString();
        }

        @Nullable
        public String getHtmlContent() {
            return this.htmlContent.length() == 0 ? null : this.htmlContent.toString();
        }

        @Nullable
        public String getCalendarContent() {
            return this.calendarContent;
        }

        @Nullable
        public String getCalendarMethod() {
            return this.calendarMethod;
        }

        @Nullable
        public Date getSentDate() {
            return this.sentDate != null ? new Date(this.sentDate.getTime()) : null;
        }
    }
}

