/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email;

import java.util.List;
import java.util.Objects;
import javax.activation.DataSource;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;

public final class EqualsHelper {
    public static boolean equalsEmail(Email email1, Email email2) {
        if (!Objects.equals(email1.getFromRecipient(), email2.getFromRecipient())) {
            return false;
        }
        if (!Objects.equals(email1.getId(), email2.getId())) {
            return false;
        }
        if (!Objects.equals(email1.getSentDate(), email2.getSentDate())) {
            return false;
        }
        if (!Objects.equals(email1.getReplyToRecipient(), email2.getReplyToRecipient())) {
            return false;
        }
        if (!Objects.equals(email1.getBounceToRecipient(), email2.getBounceToRecipient())) {
            return false;
        }
        if (!Objects.equals(email1.getPlainText(), email2.getPlainText())) {
            return false;
        }
        if (!Objects.equals(email1.getCalendarText(), email2.getCalendarText())) {
            return false;
        }
        if (!Objects.equals((Object)email1.getCalendarMethod(), (Object)email2.getCalendarMethod())) {
            return false;
        }
        if (email1.getEmailToForward() != null ? email2.getEmailToForward() == null : email2.getEmailToForward() != null) {
            return false;
        }
        if (email1.getHTMLText() != null ? !MiscUtil.normalizeNewlines(email1.getHTMLText()).equals(MiscUtil.normalizeNewlines(email2.getHTMLText())) : email2.getHTMLText() != null) {
            return false;
        }
        if (!Objects.equals(email1.getSubject(), email2.getSubject())) {
            return false;
        }
        if (!EqualsHelper.isEqualRecipientList(email1.getRecipients(), email2.getRecipients())) {
            return false;
        }
        if (!email1.getEmbeddedImages().containsAll(email2.getEmbeddedImages()) || !email2.getEmbeddedImages().containsAll(email1.getEmbeddedImages())) {
            return false;
        }
        if (!email1.getAttachments().containsAll(email2.getAttachments()) || !email2.getAttachments().containsAll(email1.getAttachments())) {
            return false;
        }
        if (!email1.getHeaders().equals(email2.getHeaders())) {
            return false;
        }
        if (email1.isUseDispositionNotificationTo() != email2.isUseDispositionNotificationTo()) {
            return false;
        }
        if (email1.isUseReturnReceiptTo() != email2.isUseReturnReceiptTo()) {
            return false;
        }
        if (!Objects.equals(email1.getDispositionNotificationTo(), email2.getDispositionNotificationTo())) {
            return false;
        }
        if (!Objects.equals(email1.getOriginalSmimeDetails(), email2.getOriginalSmimeDetails())) {
            return false;
        }
        if (!Objects.equals(email1.getPkcs12ConfigForSmimeSigning(), email2.getPkcs12ConfigForSmimeSigning())) {
            return false;
        }
        if (!Objects.equals(email1.getX509CertificateForSmimeEncryption(), email2.getX509CertificateForSmimeEncryption())) {
            return false;
        }
        return Objects.equals(email1.getReturnReceiptTo(), email2.getReturnReceiptTo());
    }

    private static boolean isEqualRecipientList(List<Recipient> recipients, List<Recipient> otherRecipients) {
        if (recipients.size() != otherRecipients.size()) {
            return false;
        }
        for (Recipient otherRecipient : otherRecipients) {
            if (EqualsHelper.containsRecipient(recipients, otherRecipient)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsRecipient(List<Recipient> recipients, @Nullable Recipient otherRecipient) {
        for (Recipient recipient : recipients) {
            if (!Objects.equals(recipient, otherRecipient)) continue;
            return true;
        }
        return false;
    }

    static boolean isEqualDataSource(@Nullable DataSource a2, @Nullable DataSource b2) {
        return a2 == b2 || a2 != null && b2 != null && Objects.equals(a2.getName(), b2.getName()) && Objects.equals(a2.getContentType(), b2.getContentType());
    }
}

