/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.mail.internet.MimeMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.email.CalendarMethod;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.email.EqualsHelper;
import org.simplejavamail.api.email.OriginalSmimeDetails;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.internal.smimesupport.model.PlainSmimeDetails;
import org.simplejavamail.api.mailer.config.Pkcs12Config;
import org.simplejavamail.internal.util.ListUtil;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public class Email
implements Serializable {
    private static final long serialVersionUID = 1234567L;
    private String id;
    private final Recipient fromRecipient;
    private final Recipient replyToRecipient;
    private final Recipient bounceToRecipient;
    private final String text;
    private final String textHTML;
    private final CalendarMethod calendarMethod;
    private final String textCalendar;
    private final String subject;
    @NotNull
    private final List<Recipient> recipients;
    @NotNull
    private final List<AttachmentResource> embeddedImages;
    @NotNull
    private final List<AttachmentResource> attachments;
    @NotNull
    private final List<AttachmentResource> decryptedAttachments;
    @NotNull
    private final Map<String, Collection<String>> headers;
    private final boolean useDispositionNotificationTo;
    private final Recipient dispositionNotificationTo;
    private final boolean useReturnReceiptTo;
    private final Recipient returnReceiptTo;
    private final transient MimeMessage emailToForward;
    private final byte[] dkimPrivateKeyData;
    private final String dkimSigningDomain;
    private final String dkimSelector;
    private final X509Certificate x509CertificateForSmimeEncryption;
    private final transient Pkcs12Config pkcs12ConfigForSmimeSigning;
    private final Email smimeSignedEmail;
    @NotNull
    private final OriginalSmimeDetails originalSmimeDetails;
    private final boolean wasMergedWithSmimeSignedMessage;
    @Nullable
    private final Date sentDate;

    public Email(@NotNull EmailPopulatingBuilder builder) {
        boolean smimeMerge;
        Preconditions.checkNonEmptyArgument(builder, "builder");
        this.smimeSignedEmail = builder.getSmimeSignedEmail();
        this.wasMergedWithSmimeSignedMessage = smimeMerge = builder.isMergeSingleSMIMESignedAttachment() && this.smimeSignedEmail != null;
        this.recipients = Collections.unmodifiableList(builder.getRecipients());
        this.embeddedImages = Collections.unmodifiableList(smimeMerge ? ListUtil.merge(builder.getEmbeddedImages(), this.smimeSignedEmail.getEmbeddedImages()) : builder.getEmbeddedImages());
        this.attachments = Collections.unmodifiableList(smimeMerge ? ListUtil.merge(builder.getAttachments(), this.smimeSignedEmail.getAttachments()) : builder.getAttachments());
        this.decryptedAttachments = Collections.unmodifiableList(smimeMerge ? ListUtil.merge(builder.getDecryptedAttachments(), this.smimeSignedEmail.getDecryptedAttachments()) : builder.getDecryptedAttachments());
        this.headers = Collections.unmodifiableMap(smimeMerge ? ListUtil.merge(builder.getHeaders(), this.smimeSignedEmail.getHeaders()) : builder.getHeaders());
        this.id = builder.getId();
        this.fromRecipient = builder.getFromRecipient();
        this.replyToRecipient = builder.getReplyToRecipient();
        this.bounceToRecipient = builder.getBounceToRecipient();
        this.text = smimeMerge ? this.smimeSignedEmail.getPlainText() : builder.getText();
        this.textHTML = smimeMerge ? this.smimeSignedEmail.getHTMLText() : builder.getTextHTML();
        this.calendarMethod = builder.getCalendarMethod();
        this.textCalendar = builder.getTextCalendar();
        this.subject = builder.getSubject();
        this.useDispositionNotificationTo = builder.isUseDispositionNotificationTo();
        this.useReturnReceiptTo = builder.isUseReturnReceiptTo();
        this.emailToForward = builder.getEmailToForward();
        this.originalSmimeDetails = builder.getOriginalSmimeDetails();
        this.sentDate = builder.getSentDate();
        this.x509CertificateForSmimeEncryption = builder.getX509CertificateForSmimeEncryption();
        this.pkcs12ConfigForSmimeSigning = builder.getPkcs12ConfigForSmimeSigning();
        this.dispositionNotificationTo = this.useDispositionNotificationTo && MiscUtil.valueNullOrEmpty(builder.getDispositionNotificationTo()) ? (builder.getReplyToRecipient() != null ? builder.getReplyToRecipient() : builder.getFromRecipient()) : builder.getDispositionNotificationTo();
        this.returnReceiptTo = this.useReturnReceiptTo && MiscUtil.valueNullOrEmpty(builder.getReturnReceiptTo()) ? (builder.getReplyToRecipient() != null ? builder.getReplyToRecipient() : builder.getFromRecipient()) : builder.getReturnReceiptTo();
        if (builder.getDkimPrivateKeyData() != null) {
            this.dkimPrivateKeyData = builder.getDkimPrivateKeyData();
            this.dkimSigningDomain = builder.getDkimSigningDomain();
            this.dkimSelector = builder.getDkimSelector();
        } else {
            this.dkimPrivateKeyData = null;
            this.dkimSigningDomain = null;
            this.dkimSelector = null;
        }
    }

    @Deprecated
    public void internalSetId(@NotNull String id2) {
        this.id = id2;
    }

    @Deprecated
    public boolean wasMergedWithSmimeSignedMessage() {
        return this.wasMergedWithSmimeSignedMessage;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(@Nullable Object o2) {
        return this == o2 || o2 != null && this.getClass() == o2.getClass() && EqualsHelper.equalsEmail(this, (Email)o2);
    }

    public String toString() {
        String s2 = "Email{\n\tid=" + this.id + "\n\tsentDate=" + this.formatDate(this.sentDate) + "\n\tfromRecipient=" + this.fromRecipient + ",\n\treplyToRecipient=" + this.replyToRecipient + ",\n\tbounceToRecipient=" + this.bounceToRecipient + ",\n\ttext='" + this.text + '\'' + ",\n\ttextHTML='" + this.textHTML + '\'' + ",\n\ttextCalendar='" + String.format("%s (method: %s)", new Object[]{this.textCalendar, this.calendarMethod}) + '\'' + ",\n\tsubject='" + this.subject + '\'' + ",\n\trecipients=" + this.recipients;
        if (!MiscUtil.valueNullOrEmpty(this.dkimSigningDomain)) {
            s2 = s2 + ",\n\tapplyDKIMSignature=true,\n\t\tdkimSelector=" + this.dkimSelector + ",\n\t\tdkimSigningDomain=" + this.dkimSigningDomain;
        }
        if (this.useDispositionNotificationTo) {
            s2 = s2 + ",\n\tuseDispositionNotificationTo=true,\n\t\tdispositionNotificationTo=" + this.dispositionNotificationTo;
        }
        if (this.useReturnReceiptTo) {
            s2 = s2 + ",\n\tuseReturnReceiptTo=true,\n\t\treturnReceiptTo=" + this.returnReceiptTo;
        }
        if (!this.headers.isEmpty()) {
            s2 = s2 + ",\n\theaders=" + this.headers;
        }
        if (!this.embeddedImages.isEmpty()) {
            s2 = s2 + ",\n\tembeddedImages=" + this.embeddedImages;
        }
        if (!this.attachments.isEmpty()) {
            s2 = s2 + ",\n\tattachments=" + this.attachments;
        }
        if (!this.decryptedAttachments.isEmpty()) {
            s2 = s2 + ",\n\tdecryptedAttachments=" + this.decryptedAttachments;
        }
        if (this.emailToForward != null) {
            s2 = s2 + ",\n\tforwardingEmail=true";
        }
        if (this.smimeSignedEmail != null || this.pkcs12ConfigForSmimeSigning != null || this.x509CertificateForSmimeEncryption != null || !(this.originalSmimeDetails instanceof PlainSmimeDetails)) {
            s2 = s2 + ",\n\tsmime details: {\n";
            s2 = s2 + "\t----------------------\n";
            if (this.smimeSignedEmail != null) {
                s2 = s2 + "\t\tsmimeSignedEmail=" + this.smimeSignedEmail + ",\n";
            }
            if (this.pkcs12ConfigForSmimeSigning != null) {
                s2 = s2 + "\t\tpkcs12ConfigForSmimeSigning=" + this.pkcs12ConfigForSmimeSigning + ",\n";
            }
            if (this.x509CertificateForSmimeEncryption != null) {
                s2 = s2 + "\t\tx509CertificateForSmimeEncryption=" + this.x509CertificateForSmimeEncryption;
            }
            s2 = s2 + "\t\toriginalSmimeDetails=" + this.originalSmimeDetails + "\n";
            s2 = s2 + "\t----------------------\n\t}";
        }
        s2 = s2 + "\n}";
        return s2;
    }

    @Nullable
    private String formatDate(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    @Nullable
    public Recipient getReplyToRecipient() {
        return this.replyToRecipient;
    }

    @Nullable
    public Recipient getBounceToRecipient() {
        return this.bounceToRecipient;
    }

    @Nullable
    public String getSubject() {
        return this.subject;
    }

    public boolean isUseDispositionNotificationTo() {
        return this.useDispositionNotificationTo;
    }

    @Nullable
    public Recipient getDispositionNotificationTo() {
        return this.dispositionNotificationTo;
    }

    public boolean isUseReturnReceiptTo() {
        return this.useReturnReceiptTo;
    }

    @Nullable
    public Recipient getReturnReceiptTo() {
        return this.returnReceiptTo;
    }

    @Nullable
    public MimeMessage getEmailToForward() {
        return this.emailToForward;
    }

    @Nullable
    public String getPlainText() {
        return this.text;
    }

    @Nullable
    public String getHTMLText() {
        return this.textHTML;
    }

    @Nullable
    public CalendarMethod getCalendarMethod() {
        return this.calendarMethod;
    }

    @Nullable
    public String getCalendarText() {
        return this.textCalendar;
    }

    @NotNull
    public List<AttachmentResource> getAttachments() {
        return this.attachments;
    }

    @NotNull
    public List<AttachmentResource> getDecryptedAttachments() {
        return this.decryptedAttachments;
    }

    @NotNull
    public List<AttachmentResource> getEmbeddedImages() {
        return this.embeddedImages;
    }

    @NotNull
    public List<Recipient> getRecipients() {
        return this.recipients;
    }

    @NotNull
    public Map<String, Collection<String>> getHeaders() {
        return this.headers;
    }

    @Nullable
    public byte[] getDkimPrivateKeyData() {
        return this.dkimPrivateKeyData;
    }

    @Nullable
    public String getDkimSigningDomain() {
        return this.dkimSigningDomain;
    }

    @Nullable
    public String getDkimSelector() {
        return this.dkimSelector;
    }

    @Nullable
    public X509Certificate getX509CertificateForSmimeEncryption() {
        return this.x509CertificateForSmimeEncryption;
    }

    @Nullable
    public Pkcs12Config getPkcs12ConfigForSmimeSigning() {
        return this.pkcs12ConfigForSmimeSigning;
    }

    @Nullable
    public Email getSmimeSignedEmail() {
        return this.smimeSignedEmail;
    }

    @NotNull
    public OriginalSmimeDetails getOriginalSmimeDetails() {
        return this.originalSmimeDetails;
    }

    @Nullable
    public Date getSentDate() {
        return this.sentDate != null ? new Date(this.sentDate.getTime()) : null;
    }
}

