/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.listeners;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

public class BroadcastSchedulerListener
implements SchedulerListener {
    private List<SchedulerListener> listeners = new LinkedList<SchedulerListener>();

    public BroadcastSchedulerListener() {
    }

    public BroadcastSchedulerListener(List<SchedulerListener> listeners) {
        this();
        this.listeners.addAll(listeners);
    }

    public void addListener(SchedulerListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(SchedulerListener listener) {
        return this.listeners.remove(listener);
    }

    public List<SchedulerListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void jobAdded(JobDetail jobDetail) {
        for (SchedulerListener l2 : this.listeners) {
            l2.jobAdded(jobDetail);
        }
    }

    @Override
    public void jobDeleted(JobKey jobKey) {
        for (SchedulerListener l2 : this.listeners) {
            l2.jobDeleted(jobKey);
        }
    }

    @Override
    public void jobScheduled(Trigger trigger) {
        for (SchedulerListener l2 : this.listeners) {
            l2.jobScheduled(trigger);
        }
    }

    @Override
    public void jobUnscheduled(TriggerKey triggerKey) {
        for (SchedulerListener l2 : this.listeners) {
            l2.jobUnscheduled(triggerKey);
        }
    }

    @Override
    public void triggerFinalized(Trigger trigger) {
        for (SchedulerListener l2 : this.listeners) {
            l2.triggerFinalized(trigger);
        }
    }

    @Override
    public void triggerPaused(TriggerKey key) {
        for (SchedulerListener l2 : this.listeners) {
            l2.triggerPaused(key);
        }
    }

    @Override
    public void triggersPaused(String triggerGroup) {
        for (SchedulerListener l2 : this.listeners) {
            l2.triggersPaused(triggerGroup);
        }
    }

    @Override
    public void triggerResumed(TriggerKey key) {
        for (SchedulerListener l2 : this.listeners) {
            l2.triggerResumed(key);
        }
    }

    @Override
    public void triggersResumed(String triggerGroup) {
        for (SchedulerListener l2 : this.listeners) {
            l2.triggersResumed(triggerGroup);
        }
    }

    @Override
    public void schedulingDataCleared() {
        for (SchedulerListener l2 : this.listeners) {
            l2.schedulingDataCleared();
        }
    }

    @Override
    public void jobPaused(JobKey key) {
        for (SchedulerListener l2 : this.listeners) {
            l2.jobPaused(key);
        }
    }

    @Override
    public void jobsPaused(String jobGroup) {
        for (SchedulerListener l2 : this.listeners) {
            l2.jobsPaused(jobGroup);
        }
    }

    @Override
    public void jobResumed(JobKey key) {
        for (SchedulerListener l2 : this.listeners) {
            l2.jobResumed(key);
        }
    }

    @Override
    public void jobsResumed(String jobGroup) {
        for (SchedulerListener l2 : this.listeners) {
            l2.jobsResumed(jobGroup);
        }
    }

    @Override
    public void schedulerError(String msg, SchedulerException cause) {
        for (SchedulerListener l2 : this.listeners) {
            l2.schedulerError(msg, cause);
        }
    }

    @Override
    public void schedulerStarted() {
        for (SchedulerListener l2 : this.listeners) {
            l2.schedulerStarted();
        }
    }

    @Override
    public void schedulerStarting() {
        for (SchedulerListener l2 : this.listeners) {
            l2.schedulerStarting();
        }
    }

    @Override
    public void schedulerInStandbyMode() {
        for (SchedulerListener l2 : this.listeners) {
            l2.schedulerInStandbyMode();
        }
    }

    @Override
    public void schedulerShutdown() {
        for (SchedulerListener l2 : this.listeners) {
            l2.schedulerShutdown();
        }
    }

    @Override
    public void schedulerShuttingdown() {
        for (SchedulerListener l2 : this.listeners) {
            l2.schedulerShuttingdown();
        }
    }
}

