/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class Strings {
    public static byte[] toUTF8ByteArray(char[] string) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            Strings.toUTF8ByteArray(string, bOut);
        }
        catch (IOException e2) {
            throw new IllegalStateException("cannot encode string to byte array!");
        }
        return bOut.toByteArray();
    }

    public static void toUTF8ByteArray(char[] string, OutputStream sOut) throws IOException {
        char[] c2 = string;
        for (int i2 = 0; i2 < c2.length; ++i2) {
            char ch2 = c2[i2];
            if (ch2 < '\u0080') {
                sOut.write(ch2);
                continue;
            }
            if (ch2 < '\u0800') {
                sOut.write(0xC0 | ch2 >> 6);
                sOut.write(0x80 | ch2 & 0x3F);
                continue;
            }
            if (ch2 >= '\ud800' && ch2 <= '\udfff') {
                if (i2 + 1 >= c2.length) {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                char W1 = ch2;
                char W2 = ch2 = c2[++i2];
                if (W1 > '\udbff') {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                int codePoint = ((W1 & 0x3FF) << 10 | W2 & 0x3FF) + 65536;
                sOut.write(0xF0 | codePoint >> 18);
                sOut.write(0x80 | codePoint >> 12 & 0x3F);
                sOut.write(0x80 | codePoint >> 6 & 0x3F);
                sOut.write(0x80 | codePoint & 0x3F);
                continue;
            }
            sOut.write(0xE0 | ch2 >> 12);
            sOut.write(0x80 | ch2 >> 6 & 0x3F);
            sOut.write(0x80 | ch2 & 0x3F);
        }
    }

    public static String fromByteArray(byte[] bytes) {
        return new String(Strings.asCharArray(bytes));
    }

    public static char[] asCharArray(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i2 = 0; i2 != chars.length; ++i2) {
            chars[i2] = (char)(bytes[i2] & 0xFF);
        }
        return chars;
    }
}

