/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.PGProperty;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.util.ExpressionProperties;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.LogWriterHandler;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.SharedTimer;
import org.postgresql.util.URLCoder;
import org.postgresql.util.internal.Nullness;

public class Driver
implements java.sql.Driver {
    private static @Nullable Driver registeredDriver;
    private static final Logger PARENT_LOGGER;
    private static final Logger LOGGER;
    private static final SharedTimer SHARED_TIMER;
    private static final String DEFAULT_PORT = "5432";
    private @Nullable Properties defaultProperties;
    private static @Nullable String loggerHandlerFile;

    private synchronized Properties getDefaultProperties() throws IOException {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException e2) {
            throw (IOException)e2.getException();
        }
        return this.defaultProperties;
    }

    private Properties loadDefaultProperties() throws IOException {
        Properties merged = new Properties();
        try {
            PGProperty.USER.set(merged, System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader cl2 = this.getClass().getClassLoader();
        if (cl2 == null) {
            LOGGER.log(Level.FINE, "Can't find our classloader for the Driver; attempt to use the system class loader");
            cl2 = ClassLoader.getSystemClassLoader();
        }
        if (cl2 == null) {
            LOGGER.log(Level.WARNING, "Can't find a classloader for the Driver; not loading driver configuration from org/postgresql/driverconfig.properties");
            return merged;
        }
        LOGGER.log(Level.FINE, "Loading driver configuration via classloader {0}", cl2);
        ArrayList<URL> urls2 = new ArrayList<URL>();
        Enumeration<URL> urlEnum = cl2.getResources("org/postgresql/driverconfig.properties");
        while (urlEnum.hasMoreElements()) {
            urls2.add(urlEnum.nextElement());
        }
        for (int i2 = urls2.size() - 1; i2 >= 0; --i2) {
            URL url = (URL)urls2.get(i2);
            LOGGER.log(Level.FINE, "Loading driver configuration from: {0}", url);
            InputStream is2 = url.openStream();
            merged.load(is2);
            is2.close();
        }
        return merged;
    }

    @Override
    public @Nullable Connection connect(String url, @Nullable Properties info) throws SQLException {
        Properties defaults;
        if (url == null) {
            throw new SQLException("url is null");
        }
        if (!url.startsWith("jdbc:postgresql:")) {
            return null;
        }
        try {
            defaults = this.getDefaultProperties();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Error loading default settings from driverconfig.properties", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties props = new Properties(defaults);
        if (info != null) {
            Set<String> e2 = info.stringPropertyNames();
            for (String propName : e2) {
                String propValue = info.getProperty(propName);
                if (propValue == null) {
                    throw new PSQLException(GT.tr("Properties for the driver contains a non-string value for the key ", new Object[0]) + propName, PSQLState.UNEXPECTED_ERROR);
                }
                props.setProperty(propName, propValue);
            }
        }
        if ((props = Driver.parseURL(url, props)) == null) {
            return null;
        }
        try {
            this.setupLoggerFromProperties(props);
            LOGGER.log(Level.FINE, "Connecting with URL: {0}", url);
            long timeout2 = Driver.timeout(props);
            if (timeout2 <= 0L) {
                return Driver.makeConnection(url, props);
            }
            ConnectThread ct2 = new ConnectThread(url, props);
            Thread thread2 = new Thread((Runnable)ct2, "PostgreSQL JDBC driver connection thread");
            thread2.setDaemon(true);
            thread2.start();
            return ct2.getResult(timeout2);
        }
        catch (PSQLException ex1) {
            LOGGER.log(Level.FINE, "Connection error: ", ex1);
            throw ex1;
        }
        catch (AccessControlException ace) {
            throw new PSQLException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ace);
        }
        catch (Exception ex2) {
            LOGGER.log(Level.FINE, "Unexpected connection error: ", ex2);
            throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    private void setupLoggerFromProperties(Properties props) {
        String driverLogLevel = PGProperty.LOGGER_LEVEL.get(props);
        if (driverLogLevel == null) {
            return;
        }
        if ("OFF".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.OFF);
            return;
        }
        if ("DEBUG".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.FINE);
        } else if ("TRACE".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.FINEST);
        }
        ExpressionProperties exprProps = new ExpressionProperties(props, System.getProperties());
        String driverLogFile = PGProperty.LOGGER_FILE.get(exprProps);
        if (driverLogFile != null && driverLogFile.equals(loggerHandlerFile)) {
            return;
        }
        for (Handler handlers : PARENT_LOGGER.getHandlers()) {
            handlers.close();
            PARENT_LOGGER.removeHandler(handlers);
            loggerHandlerFile = null;
        }
        Handler handler = null;
        if (driverLogFile != null) {
            try {
                handler = new FileHandler(driverLogFile);
                loggerHandlerFile = driverLogFile;
            }
            catch (Exception ex2) {
                System.err.println("Cannot enable FileHandler, fallback to ConsoleHandler.");
            }
        }
        SimpleFormatter formatter = new SimpleFormatter();
        if (handler == null) {
            handler = DriverManager.getLogWriter() != null ? new LogWriterHandler(DriverManager.getLogWriter()) : (DriverManager.getLogStream() != null ? new StreamHandler(DriverManager.getLogStream(), formatter) : new StreamHandler(System.err, formatter));
        } else {
            handler.setFormatter(formatter);
        }
        Level loggerLevel = PARENT_LOGGER.getLevel();
        if (loggerLevel != null) {
            handler.setLevel(loggerLevel);
        }
        PARENT_LOGGER.setUseParentHandlers(false);
        PARENT_LOGGER.addHandler(handler);
    }

    private static Connection makeConnection(String url, Properties props) throws SQLException {
        return new PgConnection(Driver.hostSpecs(props), Driver.user(props), Driver.database(props), props, url);
    }

    @Override
    public boolean acceptsURL(String url) {
        return Driver.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        Properties copy = new Properties(info);
        Properties parse = Driver.parseURL(url, copy);
        if (parse != null) {
            copy = parse;
        }
        PGProperty[] knownProperties = PGProperty.values();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i2 = 0; i2 < props.length; ++i2) {
            props[i2] = knownProperties[i2].toDriverPropertyInfo(copy);
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 42;
    }

    @Override
    public int getMinorVersion() {
        return 2;
    }

    @Deprecated
    public static String getVersion() {
        return "PostgreSQL JDBC Driver 42.2.20";
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static @Nullable Properties parseURL(String url, @Nullable Properties defaults) {
        String[] args2;
        Properties urlProps = new Properties(defaults);
        String urlServer = url;
        String urlArgs = "";
        int qPos = url.indexOf(63);
        if (qPos != -1) {
            urlServer = url.substring(0, qPos);
            urlArgs = url.substring(qPos + 1);
        }
        if (!urlServer.startsWith("jdbc:postgresql:")) {
            LOGGER.log(Level.FINE, "JDBC URL must start with \"jdbc:postgresql:\" but was: {0}", url);
            return null;
        }
        if ((urlServer = urlServer.substring("jdbc:postgresql:".length())).startsWith("//")) {
            int slash = (urlServer = urlServer.substring(2)).indexOf(47);
            if (slash == -1) {
                LOGGER.log(Level.WARNING, "JDBC URL must contain a / at the end of the host or port: {0}", url);
                return null;
            }
            urlProps.setProperty("PGDBNAME", URLCoder.decode(urlServer.substring(slash + 1)));
            String[] addresses = urlServer.substring(0, slash).split(",");
            StringBuilder hosts = new StringBuilder();
            StringBuilder ports = new StringBuilder();
            for (String address : addresses) {
                int portIdx = address.lastIndexOf(58);
                if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                    String portStr = address.substring(portIdx + 1);
                    try {
                        int port = Integer.parseInt(portStr);
                        if (port < 1 || port > 65535) {
                            LOGGER.log(Level.WARNING, "JDBC URL port: {0} not valid (1:65535) ", portStr);
                            return null;
                        }
                    }
                    catch (NumberFormatException ignore) {
                        LOGGER.log(Level.WARNING, "JDBC URL invalid port number: {0}", portStr);
                        return null;
                    }
                    ports.append(portStr);
                    hosts.append(address.subSequence(0, portIdx));
                } else {
                    ports.append(DEFAULT_PORT);
                    hosts.append(address);
                }
                ports.append(',');
                hosts.append(',');
            }
            ports.setLength(ports.length() - 1);
            hosts.setLength(hosts.length() - 1);
            urlProps.setProperty("PGPORT", ports.toString());
            urlProps.setProperty("PGHOST", hosts.toString());
        } else {
            if (defaults == null || !defaults.containsKey("PGPORT")) {
                urlProps.setProperty("PGPORT", DEFAULT_PORT);
            }
            if (defaults == null || !defaults.containsKey("PGHOST")) {
                urlProps.setProperty("PGHOST", "localhost");
            }
            if (defaults == null || !defaults.containsKey("PGDBNAME")) {
                urlProps.setProperty("PGDBNAME", URLCoder.decode(urlServer));
            }
        }
        for (String token : args2 = urlArgs.split("&")) {
            if (token.isEmpty()) continue;
            int pos = token.indexOf(61);
            if (pos == -1) {
                urlProps.setProperty(token, "");
                continue;
            }
            urlProps.setProperty(token.substring(0, pos), URLCoder.decode(token.substring(pos + 1)));
        }
        return urlProps;
    }

    private static HostSpec[] hostSpecs(Properties props) {
        String[] hosts = Nullness.castNonNull(props.getProperty("PGHOST")).split(",");
        String[] ports = Nullness.castNonNull(props.getProperty("PGPORT")).split(",");
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i2 = 0; i2 < hostSpecs.length; ++i2) {
            hostSpecs[i2] = new HostSpec(hosts[i2], Integer.parseInt(ports[i2]));
        }
        return hostSpecs;
    }

    private static String user(Properties props) {
        return props.getProperty("user", "");
    }

    private static String database(Properties props) {
        return props.getProperty("PGDBNAME", "");
    }

    private static long timeout(Properties props) {
        String timeout2 = PGProperty.LOGIN_TIMEOUT.get(props);
        if (timeout2 != null) {
            try {
                return (long)(Float.parseFloat(timeout2) * 1000.0f);
            }
            catch (NumberFormatException e2) {
                LOGGER.log(Level.WARNING, "Couldn't parse loginTimeout value: {0}", timeout2);
            }
        }
        return (long)DriverManager.getLoginTimeout() * 1000L;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class<?> callClass, String functionName) {
        return new SQLFeatureNotSupportedException(GT.tr("Method {0} is not yet implemented.", callClass.getName() + "." + functionName), PSQLState.NOT_IMPLEMENTED.getState());
    }

    @Override
    public Logger getParentLogger() {
        return PARENT_LOGGER;
    }

    public static SharedTimer getSharedTimer() {
        return SHARED_TIMER;
    }

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        Driver registeredDriver = new Driver();
        DriverManager.registerDriver(registeredDriver);
        Driver.registeredDriver = registeredDriver;
    }

    public static void deregister() throws SQLException {
        if (registeredDriver == null) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    static {
        PARENT_LOGGER = Logger.getLogger("org.postgresql");
        LOGGER = Logger.getLogger("org.postgresql.Driver");
        SHARED_TIMER = new SharedTimer();
        try {
            Driver.register();
        }
        catch (SQLException e2) {
            throw new ExceptionInInitializerError(e2);
        }
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private @Nullable Connection result;
        private @Nullable Throwable resultException;
        private boolean abandoned;

        ConnectThread(String url, Properties props) {
            this.url = url;
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable error;
            Connection conn;
            try {
                conn = Driver.makeConnection(this.url, this.props);
                error = null;
            }
            catch (Throwable t2) {
                conn = null;
                error = t2;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout2) throws SQLException {
            long expiry = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + timeout2;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long delay = expiry - TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    if (delay <= 0L) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Connection attempt timed out.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie2) {
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to connect.", new Object[0]));
                    }
                }
                return this.result;
            }
        }
    }
}

