/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class SctpChunkType
extends NamedNumber<Byte, SctpChunkType> {
    private static final long serialVersionUID = -5598298520049931819L;
    public static final SctpChunkType DATA = new SctpChunkType((byte)0, "Payload Data");
    public static final SctpChunkType INIT = new SctpChunkType((byte)1, "Initiation");
    public static final SctpChunkType INIT_ACK = new SctpChunkType((byte)2, "Initiation Acknowledgement");
    public static final SctpChunkType SACK = new SctpChunkType((byte)3, "Selective Acknowledgement");
    public static final SctpChunkType HEARTBEAT = new SctpChunkType((byte)4, "Heartbeat Request");
    public static final SctpChunkType HEARTBEAT_ACK = new SctpChunkType((byte)5, "Heartbeat Acknowledgement");
    public static final SctpChunkType ABORT = new SctpChunkType((byte)6, "Abort");
    public static final SctpChunkType SHUTDOWN = new SctpChunkType((byte)7, "Shutdown");
    public static final SctpChunkType SHUTDOWN_ACK = new SctpChunkType((byte)8, "Shutdown Acknowledgement");
    public static final SctpChunkType ERROR = new SctpChunkType((byte)9, "Operation Error");
    public static final SctpChunkType COOKIE_ECHO = new SctpChunkType((byte)10, "State Cookie");
    public static final SctpChunkType COOKIE_ACK = new SctpChunkType((byte)11, "Cookie Acknowledgement");
    public static final SctpChunkType ECNE = new SctpChunkType((byte)12, "Explicit Congestion Notification Echo");
    public static final SctpChunkType CWR = new SctpChunkType((byte)13, "Congestion Window Reduced");
    public static final SctpChunkType SHUTDOWN_COMPLETE = new SctpChunkType((byte)14, "Shutdown Complete");
    private static final Map<Byte, SctpChunkType> registry = new HashMap<Byte, SctpChunkType>();

    public ActionForUnkownType getActionForUnkownType() {
        int val = (Byte)this.value() >> 6 & 3;
        return ActionForUnkownType.values()[val];
    }

    public SctpChunkType(Byte value, String name) {
        super(value, name);
    }

    public static SctpChunkType getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new SctpChunkType(value, "unknown");
    }

    public static SctpChunkType register(SctpChunkType type) {
        return registry.put((Byte)type.value(), type);
    }

    public int valueAsInt() {
        return 0xFF & (Byte)this.value();
    }

    @Override
    public String valueAsString() {
        return String.valueOf(this.valueAsInt());
    }

    @Override
    public int compareTo(SctpChunkType o2) {
        return ((Byte)this.value()).compareTo((Byte)o2.value());
    }

    static {
        registry.put((Byte)DATA.value(), DATA);
        registry.put((Byte)INIT.value(), INIT);
        registry.put((Byte)INIT_ACK.value(), INIT_ACK);
        registry.put((Byte)SACK.value(), SACK);
        registry.put((Byte)HEARTBEAT.value(), HEARTBEAT);
        registry.put((Byte)HEARTBEAT_ACK.value(), HEARTBEAT_ACK);
        registry.put((Byte)ABORT.value(), ABORT);
        registry.put((Byte)SHUTDOWN.value(), SHUTDOWN);
        registry.put((Byte)SHUTDOWN_ACK.value(), SHUTDOWN_ACK);
        registry.put((Byte)ERROR.value(), ERROR);
        registry.put((Byte)COOKIE_ECHO.value(), COOKIE_ECHO);
        registry.put((Byte)COOKIE_ACK.value(), COOKIE_ACK);
        registry.put((Byte)ECNE.value(), ECNE);
        registry.put((Byte)CWR.value(), CWR);
        registry.put((Byte)SHUTDOWN_COMPLETE.value(), SHUTDOWN_COMPLETE);
    }

    public static enum ActionForUnkownType {
        DISCARD,
        DISCARD_AND_REPORT,
        SKIP,
        SKIP_AND_REPORT;

    }
}

