/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class LlcControlSupervisoryFunction
extends NamedNumber<Byte, LlcControlSupervisoryFunction> {
    private static final long serialVersionUID = 6818202103839595038L;
    public static final LlcControlSupervisoryFunction RR = new LlcControlSupervisoryFunction((byte)0, "Receive ready");
    public static final LlcControlSupervisoryFunction RNR = new LlcControlSupervisoryFunction((byte)1, "Receive not ready");
    public static final LlcControlSupervisoryFunction REJ = new LlcControlSupervisoryFunction((byte)2, "Reject");
    private static final Map<Byte, LlcControlSupervisoryFunction> registry = new HashMap<Byte, LlcControlSupervisoryFunction>();

    public LlcControlSupervisoryFunction(Byte value, String name) {
        super(value, name);
        if ((value & 0xFC) != 0) {
            throw new IllegalArgumentException(value + " is invalid value. It must be between 0 and 3");
        }
    }

    public static LlcControlSupervisoryFunction getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new LlcControlSupervisoryFunction(value, "unknown");
    }

    public static LlcControlSupervisoryFunction register(LlcControlSupervisoryFunction number) {
        return registry.put((Byte)number.value(), number);
    }

    @Override
    public int compareTo(LlcControlSupervisoryFunction o2) {
        return ((Byte)this.value()).compareTo((Byte)o2.value());
    }

    static {
        registry.put((Byte)RR.value(), RR);
        registry.put((Byte)RNR.value(), RNR);
        registry.put((Byte)REJ.value(), REJ);
    }
}

