/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class GtpV1MessageType
extends NamedNumber<Byte, GtpV1MessageType> {
    private static final long serialVersionUID = 7592798859079852877L;
    public static final GtpV1MessageType ECHO_REQUEST = new GtpV1MessageType((byte)1, "Echo Request");
    public static final GtpV1MessageType ECHO_RESPONSE = new GtpV1MessageType((byte)2, "Echo Response");
    public static final GtpV1MessageType VERSION_NOT_SUPPORTED = new GtpV1MessageType((byte)3, "Version Not Supported");
    public static final GtpV1MessageType NODE_ALIVE_REQUEST = new GtpV1MessageType((byte)4, "Node Alive Request");
    public static final GtpV1MessageType NODE_ALIVE_RESPONSE = new GtpV1MessageType((byte)5, "Node Alive Response");
    public static final GtpV1MessageType REDIRECTION_REQUEST = new GtpV1MessageType((byte)6, "Redirection Request");
    public static final GtpV1MessageType REDIRECTION_RESPONSE = new GtpV1MessageType((byte)7, "Redirection Response");
    public static final GtpV1MessageType CREATE_PDP_CONTEXT_REQUEST = new GtpV1MessageType((byte)16, "Create PDP Context Request");
    public static final GtpV1MessageType CREATE_PDP_CONTEXT_RESPONSE = new GtpV1MessageType((byte)17, "Create PDP Context Response");
    public static final GtpV1MessageType UPDATE_PDP_CONTEXT_REQUEST = new GtpV1MessageType((byte)18, "Update PDP Context Request");
    public static final GtpV1MessageType UPDATE_PDP_CONTEXT_RESPONSE = new GtpV1MessageType((byte)19, "Update PDP Context Response");
    public static final GtpV1MessageType DELETE_PDP_CONTEXT_REQUEST = new GtpV1MessageType((byte)20, "Delete PDP Context Request");
    public static final GtpV1MessageType DELETE_PDP_CONTEXT_RESPONSE = new GtpV1MessageType((byte)21, "Delete PDP Context Response");
    public static final GtpV1MessageType INITIATE_PDP_CONTEXT_ACTIVATION_REQUEST = new GtpV1MessageType((byte)22, "Initiate PDP Context Activation Request");
    public static final GtpV1MessageType INITIATE_PDP_CONTEXT_ACTIVATION_RESPONSE = new GtpV1MessageType((byte)22, "Initiate PDP Context Activation Response");
    public static final GtpV1MessageType ERROR_INDICATION = new GtpV1MessageType((byte)26, "Error Indication");
    public static final GtpV1MessageType PDU_NOTIFICATION_REQUEST = new GtpV1MessageType((byte)27, "PDU Notification Request");
    public static final GtpV1MessageType PDU_NOTIFICATION_RESPONSE = new GtpV1MessageType((byte)28, "PDU Notification Response");
    public static final GtpV1MessageType PDU_NOTIFICATION_REJECT_REQUEST = new GtpV1MessageType((byte)29, "PDU Notification Reject Request");
    public static final GtpV1MessageType PDU_NOTIFICATION_REJECT_RESPONSE = new GtpV1MessageType((byte)30, "PDU Notification Reject Response");
    public static final GtpV1MessageType SUPPORTED_EXTENSION_HEADERS_NOTIFICATION = new GtpV1MessageType((byte)31, "Supported Extension Headers Notification");
    public static final GtpV1MessageType SEND_ROUTING_INFORMATION_FOR_GPRS_REQUEST = new GtpV1MessageType((byte)32, "Send Routing Information for GPRS Request");
    public static final GtpV1MessageType SEND_ROUTING_INFORMATION_FOR_GPRS_RESPONSE = new GtpV1MessageType((byte)33, "Send Routing Information for GPRS Response");
    public static final GtpV1MessageType FAILURE_REPORT_REQUEST = new GtpV1MessageType((byte)34, "Failure Report Request");
    public static final GtpV1MessageType FAILURE_REPORT_RESPONSE = new GtpV1MessageType((byte)35, "Failure Report Response");
    public static final GtpV1MessageType NOTE_MS_GPRS_PRESENT_REQUEST = new GtpV1MessageType((byte)36, "Note MS GPRS Present Request");
    public static final GtpV1MessageType NOTE_MS_GPRS_PRESENT_RESPONSE = new GtpV1MessageType((byte)37, "Note MS GPRS Present Response");
    public static final GtpV1MessageType IDENTIFICATION_REQUEST = new GtpV1MessageType((byte)48, "Identification Request");
    public static final GtpV1MessageType IDENTIFICATION_RESPONSE = new GtpV1MessageType((byte)49, "Identification Response");
    public static final GtpV1MessageType SGSN_CONTEXT_REQUEST = new GtpV1MessageType((byte)50, "SGSN Context Request");
    public static final GtpV1MessageType SGSN_CONTEXT_RESPONSE = new GtpV1MessageType((byte)51, "SGSN Context Response");
    public static final GtpV1MessageType SGSN_CONTEXT_ACKNOWLEDGE = new GtpV1MessageType((byte)52, "SGSN Context Acknowledge");
    public static final GtpV1MessageType FORWARD_RELOCATION_REQUEST = new GtpV1MessageType((byte)53, "Forward Relocation Request");
    public static final GtpV1MessageType FORWARD_RELOCATION_RESPONSE = new GtpV1MessageType((byte)54, "Forward Relocation Response");
    public static final GtpV1MessageType FORWARD_RELOCATION_COMPLETE = new GtpV1MessageType((byte)55, "Forward Relocation Complete");
    public static final GtpV1MessageType RELOCATION_CANCEL_REQUEST = new GtpV1MessageType((byte)56, "Relocation Cancel Request");
    public static final GtpV1MessageType RELOCATION_CANCEL_RESPONSE = new GtpV1MessageType((byte)57, "Relocation Cancel Response");
    public static final GtpV1MessageType FORWARD_SNRS_CONTEXT = new GtpV1MessageType((byte)58, "Forward SNRS Context");
    public static final GtpV1MessageType FORWARD_RELOCATION_COMPLETE_ACKNOWLEDGE = new GtpV1MessageType((byte)59, "Forward Relocation Complete Acknowledge");
    public static final GtpV1MessageType FORWARD_SNRS_CONTEXT_ACKNOWLEDGE = new GtpV1MessageType((byte)60, "Forward SNRS Context Acknowledge");
    public static final GtpV1MessageType RAN_INFORMATION_RELAY = new GtpV1MessageType((byte)70, "RAN Information Relay");
    public static final GtpV1MessageType MBMS_NOTIFICATION_REQUEST = new GtpV1MessageType((byte)96, "MBMS Notification Request");
    public static final GtpV1MessageType MBMS_NOTIFICATION_RESPONSE = new GtpV1MessageType((byte)97, "MBMS Notification Response");
    public static final GtpV1MessageType MBMS_NOTIFICATION_REJECT_REQUEST = new GtpV1MessageType((byte)98, "MBMS Notification Request");
    public static final GtpV1MessageType MBMS_NOTIFICATION_REJECT_RESPONSE = new GtpV1MessageType((byte)99, "MBMS Notification Response");
    public static final GtpV1MessageType CREATE_MBMS_CONTEXT_REQUEST = new GtpV1MessageType((byte)100, "Create MBMS Context Request");
    public static final GtpV1MessageType CREATE_MBMS_CONTEXT_RESPONSE = new GtpV1MessageType((byte)101, "Create MBMS Context Response");
    public static final GtpV1MessageType UPDATE_MBMS_CONTEXT_REQUEST = new GtpV1MessageType((byte)102, "Update MBMS Context Request");
    public static final GtpV1MessageType UPDATE_MBMS_CONTEXT_RESPONSE = new GtpV1MessageType((byte)103, "Update MBMS Context Response");
    public static final GtpV1MessageType DELETE_MBMS_CONTEXT_REQUEST = new GtpV1MessageType((byte)104, "Delete MBMS Context Request");
    public static final GtpV1MessageType DELETE_MBMS_CONTEXT_RESPONSE = new GtpV1MessageType((byte)105, "Delete MBMS Context Response");
    public static final GtpV1MessageType MBMS_REGISTRATION_REQUEST = new GtpV1MessageType((byte)112, "MBMS Registration Request");
    public static final GtpV1MessageType MBMS_REGISTRATION_RESPONSE = new GtpV1MessageType((byte)113, "MBMS Registration Response");
    public static final GtpV1MessageType MBMS_DE_REGISTRATION_REQUEST = new GtpV1MessageType((byte)114, "MBMS De Registration Request");
    public static final GtpV1MessageType MBMS_DE_REGISTRATION_RESPONSE = new GtpV1MessageType((byte)115, "MBMS De Registration Response");
    public static final GtpV1MessageType MBMS_SESSION_START_REQUEST = new GtpV1MessageType((byte)116, "MBMS Session Start Request");
    public static final GtpV1MessageType MBMS_SESSION_START_RESPONSE = new GtpV1MessageType((byte)117, "MBMS Session Start Response");
    public static final GtpV1MessageType MBMS_SESSION_STOP_REQUEST = new GtpV1MessageType((byte)118, "MBMS Session Stop Request");
    public static final GtpV1MessageType MBMS_SESSION_STOP_RESPONSE = new GtpV1MessageType((byte)119, "MBMS Session Stop Response");
    public static final GtpV1MessageType MBMS_SESSION_UPDATE_REQUEST = new GtpV1MessageType((byte)120, "MBMS Session Update Request");
    public static final GtpV1MessageType MBMS_SESSION_UPDATE_RESPONSE = new GtpV1MessageType((byte)121, "MBMS Session Update Response");
    public static final GtpV1MessageType MS_INFO_CHANGE_NOTIFICATION_REQUEST = new GtpV1MessageType((byte)-128, "MS Info Change Notification Request");
    public static final GtpV1MessageType MS_INFO_CHANGE_NOTIFICATION_RESPONSE = new GtpV1MessageType((byte)-127, "MS Info Change Notification Response");
    public static final GtpV1MessageType DATA_RECORD_TRANSFER_REQUEST = new GtpV1MessageType((byte)-16, "Data Record Transfer Request");
    public static final GtpV1MessageType DATA_RECORD_TRANSFER_RESPONSE = new GtpV1MessageType((byte)-15, "Data Record Transfer Response");
    public static final GtpV1MessageType END_MARKER = new GtpV1MessageType((byte)-2, "End Marker");
    public static final GtpV1MessageType G_PDU = new GtpV1MessageType((byte)-1, "G-PDU");
    private static final Map<Byte, GtpV1MessageType> registry = new HashMap<Byte, GtpV1MessageType>();

    public GtpV1MessageType(Byte value, String name) {
        super(value, name);
    }

    public static GtpV1MessageType getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new GtpV1MessageType(value, "unknown");
    }

    public static GtpV1MessageType register(GtpV1MessageType type) {
        return registry.put((Byte)type.value(), type);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    @Override
    public int compareTo(GtpV1MessageType o2) {
        return ((Byte)this.value()).compareTo((Byte)o2.value());
    }

    static {
        registry.put((Byte)ECHO_REQUEST.value(), ECHO_REQUEST);
        registry.put((Byte)ECHO_RESPONSE.value(), ECHO_RESPONSE);
        registry.put((Byte)VERSION_NOT_SUPPORTED.value(), VERSION_NOT_SUPPORTED);
        registry.put((Byte)NODE_ALIVE_REQUEST.value(), NODE_ALIVE_REQUEST);
        registry.put((Byte)NODE_ALIVE_RESPONSE.value(), NODE_ALIVE_RESPONSE);
        registry.put((Byte)REDIRECTION_REQUEST.value(), REDIRECTION_REQUEST);
        registry.put((Byte)REDIRECTION_RESPONSE.value(), REDIRECTION_RESPONSE);
        registry.put((Byte)CREATE_PDP_CONTEXT_REQUEST.value(), CREATE_PDP_CONTEXT_REQUEST);
        registry.put((Byte)CREATE_PDP_CONTEXT_RESPONSE.value(), CREATE_PDP_CONTEXT_RESPONSE);
        registry.put((Byte)UPDATE_PDP_CONTEXT_REQUEST.value(), UPDATE_PDP_CONTEXT_REQUEST);
        registry.put((Byte)UPDATE_PDP_CONTEXT_RESPONSE.value(), UPDATE_PDP_CONTEXT_RESPONSE);
        registry.put((Byte)DELETE_PDP_CONTEXT_REQUEST.value(), DELETE_PDP_CONTEXT_REQUEST);
        registry.put((Byte)DELETE_PDP_CONTEXT_RESPONSE.value(), DELETE_PDP_CONTEXT_RESPONSE);
        registry.put((Byte)INITIATE_PDP_CONTEXT_ACTIVATION_REQUEST.value(), INITIATE_PDP_CONTEXT_ACTIVATION_REQUEST);
        registry.put((Byte)INITIATE_PDP_CONTEXT_ACTIVATION_RESPONSE.value(), INITIATE_PDP_CONTEXT_ACTIVATION_RESPONSE);
        registry.put((Byte)ERROR_INDICATION.value(), ERROR_INDICATION);
        registry.put((Byte)PDU_NOTIFICATION_REQUEST.value(), PDU_NOTIFICATION_REQUEST);
        registry.put((Byte)PDU_NOTIFICATION_RESPONSE.value(), PDU_NOTIFICATION_RESPONSE);
        registry.put((Byte)PDU_NOTIFICATION_REJECT_REQUEST.value(), PDU_NOTIFICATION_REJECT_REQUEST);
        registry.put((Byte)PDU_NOTIFICATION_REJECT_RESPONSE.value(), PDU_NOTIFICATION_REJECT_RESPONSE);
        registry.put((Byte)SUPPORTED_EXTENSION_HEADERS_NOTIFICATION.value(), SUPPORTED_EXTENSION_HEADERS_NOTIFICATION);
        registry.put((Byte)SEND_ROUTING_INFORMATION_FOR_GPRS_REQUEST.value(), SEND_ROUTING_INFORMATION_FOR_GPRS_REQUEST);
        registry.put((Byte)SEND_ROUTING_INFORMATION_FOR_GPRS_RESPONSE.value(), SEND_ROUTING_INFORMATION_FOR_GPRS_RESPONSE);
        registry.put((Byte)FAILURE_REPORT_REQUEST.value(), FAILURE_REPORT_REQUEST);
        registry.put((Byte)FAILURE_REPORT_RESPONSE.value(), FAILURE_REPORT_RESPONSE);
        registry.put((Byte)NOTE_MS_GPRS_PRESENT_REQUEST.value(), NOTE_MS_GPRS_PRESENT_REQUEST);
        registry.put((Byte)NOTE_MS_GPRS_PRESENT_RESPONSE.value(), NOTE_MS_GPRS_PRESENT_RESPONSE);
        registry.put((Byte)IDENTIFICATION_REQUEST.value(), IDENTIFICATION_REQUEST);
        registry.put((Byte)IDENTIFICATION_RESPONSE.value(), IDENTIFICATION_RESPONSE);
        registry.put((Byte)SGSN_CONTEXT_REQUEST.value(), SGSN_CONTEXT_REQUEST);
        registry.put((Byte)SGSN_CONTEXT_RESPONSE.value(), SGSN_CONTEXT_RESPONSE);
        registry.put((Byte)SGSN_CONTEXT_ACKNOWLEDGE.value(), SGSN_CONTEXT_ACKNOWLEDGE);
        registry.put((Byte)FORWARD_RELOCATION_REQUEST.value(), FORWARD_RELOCATION_REQUEST);
        registry.put((Byte)FORWARD_RELOCATION_RESPONSE.value(), FORWARD_RELOCATION_RESPONSE);
        registry.put((Byte)FORWARD_RELOCATION_COMPLETE.value(), FORWARD_RELOCATION_COMPLETE);
        registry.put((Byte)FORWARD_RELOCATION_COMPLETE_ACKNOWLEDGE.value(), FORWARD_RELOCATION_COMPLETE_ACKNOWLEDGE);
        registry.put((Byte)RELOCATION_CANCEL_REQUEST.value(), RELOCATION_CANCEL_REQUEST);
        registry.put((Byte)RELOCATION_CANCEL_RESPONSE.value(), RELOCATION_CANCEL_RESPONSE);
        registry.put((Byte)FORWARD_SNRS_CONTEXT.value(), FORWARD_SNRS_CONTEXT);
        registry.put((Byte)FORWARD_SNRS_CONTEXT_ACKNOWLEDGE.value(), FORWARD_SNRS_CONTEXT_ACKNOWLEDGE);
        registry.put((Byte)RAN_INFORMATION_RELAY.value(), RAN_INFORMATION_RELAY);
        registry.put((Byte)MBMS_NOTIFICATION_REQUEST.value(), MBMS_NOTIFICATION_REQUEST);
        registry.put((Byte)MBMS_NOTIFICATION_RESPONSE.value(), MBMS_NOTIFICATION_RESPONSE);
        registry.put((Byte)MBMS_NOTIFICATION_REJECT_REQUEST.value(), MBMS_NOTIFICATION_REJECT_REQUEST);
        registry.put((Byte)MBMS_NOTIFICATION_REJECT_RESPONSE.value(), MBMS_NOTIFICATION_REJECT_RESPONSE);
        registry.put((Byte)CREATE_MBMS_CONTEXT_REQUEST.value(), CREATE_MBMS_CONTEXT_REQUEST);
        registry.put((Byte)CREATE_MBMS_CONTEXT_RESPONSE.value(), CREATE_MBMS_CONTEXT_RESPONSE);
        registry.put((Byte)UPDATE_MBMS_CONTEXT_REQUEST.value(), UPDATE_MBMS_CONTEXT_REQUEST);
        registry.put((Byte)UPDATE_MBMS_CONTEXT_RESPONSE.value(), UPDATE_MBMS_CONTEXT_RESPONSE);
        registry.put((Byte)DELETE_MBMS_CONTEXT_REQUEST.value(), DELETE_MBMS_CONTEXT_REQUEST);
        registry.put((Byte)DELETE_MBMS_CONTEXT_RESPONSE.value(), DELETE_MBMS_CONTEXT_RESPONSE);
        registry.put((Byte)MBMS_REGISTRATION_REQUEST.value(), MBMS_REGISTRATION_REQUEST);
        registry.put((Byte)MBMS_REGISTRATION_RESPONSE.value(), MBMS_REGISTRATION_RESPONSE);
        registry.put((Byte)MBMS_DE_REGISTRATION_REQUEST.value(), MBMS_DE_REGISTRATION_REQUEST);
        registry.put((Byte)MBMS_DE_REGISTRATION_RESPONSE.value(), MBMS_DE_REGISTRATION_RESPONSE);
        registry.put((Byte)MBMS_SESSION_START_REQUEST.value(), MBMS_SESSION_START_REQUEST);
        registry.put((Byte)MBMS_SESSION_START_RESPONSE.value(), MBMS_SESSION_START_RESPONSE);
        registry.put((Byte)MBMS_SESSION_STOP_REQUEST.value(), MBMS_SESSION_STOP_REQUEST);
        registry.put((Byte)MBMS_SESSION_STOP_RESPONSE.value(), MBMS_SESSION_STOP_RESPONSE);
        registry.put((Byte)MBMS_SESSION_UPDATE_REQUEST.value(), MBMS_SESSION_UPDATE_REQUEST);
        registry.put((Byte)MBMS_SESSION_UPDATE_RESPONSE.value(), MBMS_SESSION_UPDATE_RESPONSE);
        registry.put((Byte)MS_INFO_CHANGE_NOTIFICATION_REQUEST.value(), MS_INFO_CHANGE_NOTIFICATION_REQUEST);
        registry.put((Byte)MS_INFO_CHANGE_NOTIFICATION_RESPONSE.value(), MS_INFO_CHANGE_NOTIFICATION_RESPONSE);
        registry.put((Byte)DATA_RECORD_TRANSFER_REQUEST.value(), DATA_RECORD_TRANSFER_REQUEST);
        registry.put((Byte)DATA_RECORD_TRANSFER_RESPONSE.value(), DATA_RECORD_TRANSFER_RESPONSE);
        registry.put((Byte)END_MARKER.value(), END_MARKER);
        registry.put((Byte)G_PDU.value(), G_PDU);
    }
}

