/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class Dot11ServiceIntervalGranularity
extends NamedNumber<Byte, Dot11ServiceIntervalGranularity> {
    private static final long serialVersionUID = -935382239962360264L;
    public static final Dot11ServiceIntervalGranularity SIG_5_MS = new Dot11ServiceIntervalGranularity((byte)0, "5 ms");
    public static final Dot11ServiceIntervalGranularity SIG_10_MS = new Dot11ServiceIntervalGranularity((byte)1, "10 ms");
    public static final Dot11ServiceIntervalGranularity SIG_15_MS = new Dot11ServiceIntervalGranularity((byte)2, "15 ms");
    public static final Dot11ServiceIntervalGranularity SIG_20_MS = new Dot11ServiceIntervalGranularity((byte)3, "20 ms");
    public static final Dot11ServiceIntervalGranularity SIG_25_MS = new Dot11ServiceIntervalGranularity((byte)4, "25 ms");
    public static final Dot11ServiceIntervalGranularity SIG_30_MS = new Dot11ServiceIntervalGranularity((byte)5, "30 ms");
    public static final Dot11ServiceIntervalGranularity SIG_35_MS = new Dot11ServiceIntervalGranularity((byte)6, "35 ms");
    public static final Dot11ServiceIntervalGranularity SIG_40_MS = new Dot11ServiceIntervalGranularity((byte)7, "40 ms");
    private static final Map<Byte, Dot11ServiceIntervalGranularity> registry = new HashMap<Byte, Dot11ServiceIntervalGranularity>();

    public Dot11ServiceIntervalGranularity(Byte value, String name) {
        super(value, name);
        if ((value & 0xF8) != 0) {
            throw new IllegalArgumentException("The value must be between 0 and 7 but is actually: " + value);
        }
    }

    public static Dot11ServiceIntervalGranularity getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new Dot11ServiceIntervalGranularity(value, "unknown");
    }

    public static Dot11ServiceIntervalGranularity register(Dot11ServiceIntervalGranularity number) {
        return registry.put((Byte)number.value(), number);
    }

    @Override
    public int compareTo(Dot11ServiceIntervalGranularity o2) {
        return ((Byte)this.value()).compareTo((Byte)o2.value());
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    static {
        registry.put((Byte)SIG_5_MS.value(), SIG_5_MS);
        registry.put((Byte)SIG_10_MS.value(), SIG_10_MS);
        registry.put((Byte)SIG_15_MS.value(), SIG_15_MS);
        registry.put((Byte)SIG_20_MS.value(), SIG_20_MS);
        registry.put((Byte)SIG_25_MS.value(), SIG_25_MS);
        registry.put((Byte)SIG_30_MS.value(), SIG_30_MS);
        registry.put((Byte)SIG_35_MS.value(), SIG_35_MS);
        registry.put((Byte)SIG_40_MS.value(), SIG_40_MS);
    }
}

