/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataRxFlags
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = -1269108995049803687L;
    private static final int LENGTH = 2;
    private final boolean lsb;
    private final boolean badPlcpCrc;
    private final boolean thirdLsb;
    private final boolean fourthLsb;
    private final boolean fifthLsb;
    private final boolean sixthLsb;
    private final boolean seventhLsb;
    private final boolean eighthLsb;
    private final boolean ninthLsb;
    private final boolean tenthLsb;
    private final boolean eleventhLsb;
    private final boolean twelvethLsb;
    private final boolean thirteenthLsb;
    private final boolean fourteenthLsb;
    private final boolean fifteenthLsb;
    private final boolean sixteenthLsb;

    public static RadiotapDataRxFlags newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataRxFlags(rawData, offset, length);
    }

    private RadiotapDataRxFlags(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 2) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapRxFlags (").append(2).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.lsb = (rawData[offset] & 1) != 0;
        this.badPlcpCrc = (rawData[offset] & 2) != 0;
        this.thirdLsb = (rawData[offset] & 4) != 0;
        this.fourthLsb = (rawData[offset] & 8) != 0;
        this.fifthLsb = (rawData[offset] & 0x10) != 0;
        this.sixthLsb = (rawData[offset] & 0x20) != 0;
        this.seventhLsb = (rawData[offset] & 0x40) != 0;
        this.eighthLsb = (rawData[offset] & 0x80) != 0;
        this.ninthLsb = (rawData[offset + 1] & 1) != 0;
        this.tenthLsb = (rawData[offset + 1] & 2) != 0;
        this.eleventhLsb = (rawData[offset + 1] & 4) != 0;
        this.twelvethLsb = (rawData[offset + 1] & 8) != 0;
        this.thirteenthLsb = (rawData[offset + 1] & 0x10) != 0;
        this.fourteenthLsb = (rawData[offset + 1] & 0x20) != 0;
        this.fifteenthLsb = (rawData[offset + 1] & 0x40) != 0;
        this.sixteenthLsb = (rawData[offset + 1] & 0x80) != 0;
    }

    private RadiotapDataRxFlags(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is null.");
        }
        this.lsb = builder.lsb;
        this.badPlcpCrc = builder.badPlcpCrc;
        this.thirdLsb = builder.thirdLsb;
        this.fourthLsb = builder.fourthLsb;
        this.fifthLsb = builder.fifthLsb;
        this.sixthLsb = builder.sixthLsb;
        this.seventhLsb = builder.seventhLsb;
        this.eighthLsb = builder.eighthLsb;
        this.ninthLsb = builder.ninthLsb;
        this.tenthLsb = builder.tenthLsb;
        this.eleventhLsb = builder.eleventhLsb;
        this.twelvethLsb = builder.twelvethLsb;
        this.thirteenthLsb = builder.thirteenthLsb;
        this.fourteenthLsb = builder.fourteenthLsb;
        this.fifteenthLsb = builder.fifteenthLsb;
        this.sixteenthLsb = builder.sixteenthLsb;
    }

    public boolean getLsb() {
        return this.lsb;
    }

    public boolean isBadPlcpCrc() {
        return this.badPlcpCrc;
    }

    public boolean getThirdLsb() {
        return this.thirdLsb;
    }

    public boolean getFourthLsb() {
        return this.fourthLsb;
    }

    public boolean getFifthLsb() {
        return this.fifthLsb;
    }

    public boolean getSixthLsb() {
        return this.sixthLsb;
    }

    public boolean getSeventhLsb() {
        return this.seventhLsb;
    }

    public boolean getEighthLsb() {
        return this.eighthLsb;
    }

    public boolean getNinthLsb() {
        return this.ninthLsb;
    }

    public boolean getTenthLsb() {
        return this.tenthLsb;
    }

    public boolean getEleventhLsb() {
        return this.eleventhLsb;
    }

    public boolean getTwelvethLsb() {
        return this.twelvethLsb;
    }

    public boolean getThirteenthLsb() {
        return this.thirteenthLsb;
    }

    public boolean getFourteenthLsb() {
        return this.fourteenthLsb;
    }

    public boolean getFifteenthLsb() {
        return this.fifteenthLsb;
    }

    public boolean getSixteenthLsb() {
        return this.sixteenthLsb;
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] data = new byte[2];
        if (this.lsb) {
            data[0] = (byte)(data[0] | 1);
        }
        if (this.badPlcpCrc) {
            data[0] = (byte)(data[0] | 2);
        }
        if (this.thirdLsb) {
            data[0] = (byte)(data[0] | 4);
        }
        if (this.fourthLsb) {
            data[0] = (byte)(data[0] | 8);
        }
        if (this.fifthLsb) {
            data[0] = (byte)(data[0] | 0x10);
        }
        if (this.sixthLsb) {
            data[0] = (byte)(data[0] | 0x20);
        }
        if (this.seventhLsb) {
            data[0] = (byte)(data[0] | 0x40);
        }
        if (this.eighthLsb) {
            data[0] = (byte)(data[0] | 0x80);
        }
        if (this.ninthLsb) {
            data[1] = (byte)(data[1] | 1);
        }
        if (this.tenthLsb) {
            data[1] = (byte)(data[1] | 2);
        }
        if (this.eleventhLsb) {
            data[1] = (byte)(data[1] | 4);
        }
        if (this.twelvethLsb) {
            data[1] = (byte)(data[1] | 8);
        }
        if (this.thirteenthLsb) {
            data[1] = (byte)(data[1] | 0x10);
        }
        if (this.fourteenthLsb) {
            data[1] = (byte)(data[1] | 0x20);
        }
        if (this.fifteenthLsb) {
            data[1] = (byte)(data[1] | 0x40);
        }
        if (this.sixteenthLsb) {
            data[1] = (byte)(data[1] | 0x80);
        }
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls2 = System.getProperty("line.separator");
        sb.append(indent).append("RX flags: ").append(ls2).append(indent).append("  LSB: ").append(this.lsb).append(ls2).append(indent).append("  Bad PLCP CRC: ").append(this.badPlcpCrc).append(ls2).append(indent).append("  3rd LSB: ").append(this.thirdLsb).append(ls2).append(indent).append("  4th LSB: ").append(this.fourthLsb).append(ls2).append(indent).append("  5th LSB: ").append(this.fifthLsb).append(ls2).append(indent).append("  6th LSB: ").append(this.sixthLsb).append(ls2).append(indent).append("  7th LSB: ").append(this.seventhLsb).append(ls2).append(indent).append("  8th LSB: ").append(this.eighthLsb).append(ls2).append(indent).append("  9th LSB: ").append(this.ninthLsb).append(ls2).append(indent).append("  10th LSB: ").append(this.tenthLsb).append(ls2).append(indent).append("  11th LSB: ").append(this.eleventhLsb).append(ls2).append(indent).append("  12th LSB: ").append(this.twelvethLsb).append(ls2).append(indent).append("  13th LSB: ").append(this.thirteenthLsb).append(ls2).append(indent).append("  14th LSB: ").append(this.fourteenthLsb).append(ls2).append(indent).append("  15th LSB: ").append(this.fifteenthLsb).append(ls2).append(indent).append("  16th LSB: ").append(this.sixteenthLsb).append(ls2);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sixthLsb ? 1231 : 1237);
        result = 31 * result + (this.eleventhLsb ? 1231 : 1237);
        result = 31 * result + (this.ninthLsb ? 1231 : 1237);
        result = 31 * result + (this.fourthLsb ? 1231 : 1237);
        result = 31 * result + (this.twelvethLsb ? 1231 : 1237);
        result = 31 * result + (this.thirteenthLsb ? 1231 : 1237);
        result = 31 * result + (this.fifteenthLsb ? 1231 : 1237);
        result = 31 * result + (this.lsb ? 1231 : 1237);
        result = 31 * result + (this.seventhLsb ? 1231 : 1237);
        result = 31 * result + (this.tenthLsb ? 1231 : 1237);
        result = 31 * result + (this.sixteenthLsb ? 1231 : 1237);
        result = 31 * result + (this.badPlcpCrc ? 1231 : 1237);
        result = 31 * result + (this.fourteenthLsb ? 1231 : 1237);
        result = 31 * result + (this.thirdLsb ? 1231 : 1237);
        result = 31 * result + (this.fifthLsb ? 1231 : 1237);
        result = 31 * result + (this.eighthLsb ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RadiotapDataRxFlags other = (RadiotapDataRxFlags)obj;
        if (this.sixthLsb != other.sixthLsb) {
            return false;
        }
        if (this.eleventhLsb != other.eleventhLsb) {
            return false;
        }
        if (this.ninthLsb != other.ninthLsb) {
            return false;
        }
        if (this.fourthLsb != other.fourthLsb) {
            return false;
        }
        if (this.twelvethLsb != other.twelvethLsb) {
            return false;
        }
        if (this.thirteenthLsb != other.thirteenthLsb) {
            return false;
        }
        if (this.fifteenthLsb != other.fifteenthLsb) {
            return false;
        }
        if (this.lsb != other.lsb) {
            return false;
        }
        if (this.seventhLsb != other.seventhLsb) {
            return false;
        }
        if (this.tenthLsb != other.tenthLsb) {
            return false;
        }
        if (this.sixteenthLsb != other.sixteenthLsb) {
            return false;
        }
        if (this.badPlcpCrc != other.badPlcpCrc) {
            return false;
        }
        if (this.fourteenthLsb != other.fourteenthLsb) {
            return false;
        }
        if (this.thirdLsb != other.thirdLsb) {
            return false;
        }
        if (this.fifthLsb != other.fifthLsb) {
            return false;
        }
        return this.eighthLsb == other.eighthLsb;
    }

    public static final class Builder {
        private boolean lsb;
        private boolean badPlcpCrc;
        private boolean thirdLsb;
        private boolean fourthLsb;
        private boolean fifthLsb;
        private boolean sixthLsb;
        private boolean seventhLsb;
        private boolean eighthLsb;
        private boolean ninthLsb;
        private boolean tenthLsb;
        private boolean eleventhLsb;
        private boolean twelvethLsb;
        private boolean thirteenthLsb;
        private boolean fourteenthLsb;
        private boolean fifteenthLsb;
        private boolean sixteenthLsb;

        public Builder() {
        }

        private Builder(RadiotapDataRxFlags obj) {
            this.lsb = obj.lsb;
            this.badPlcpCrc = obj.badPlcpCrc;
            this.thirdLsb = obj.thirdLsb;
            this.fourthLsb = obj.fourthLsb;
            this.fifthLsb = obj.fifthLsb;
            this.sixthLsb = obj.sixthLsb;
            this.seventhLsb = obj.seventhLsb;
            this.eighthLsb = obj.eighthLsb;
            this.ninthLsb = obj.ninthLsb;
            this.tenthLsb = obj.tenthLsb;
            this.eleventhLsb = obj.eleventhLsb;
            this.twelvethLsb = obj.twelvethLsb;
            this.thirteenthLsb = obj.thirteenthLsb;
            this.fourteenthLsb = obj.fourteenthLsb;
            this.fifteenthLsb = obj.fifteenthLsb;
            this.sixteenthLsb = obj.sixteenthLsb;
        }

        public Builder lsb(boolean lsb) {
            this.lsb = lsb;
            return this;
        }

        public Builder badPlcpCrc(boolean badPlcpCrc) {
            this.badPlcpCrc = badPlcpCrc;
            return this;
        }

        public Builder thirdLsb(boolean thirdLsb) {
            this.thirdLsb = thirdLsb;
            return this;
        }

        public Builder fourthLsb(boolean fourthLsb) {
            this.fourthLsb = fourthLsb;
            return this;
        }

        public Builder fifthLsb(boolean fifthLsb) {
            this.fifthLsb = fifthLsb;
            return this;
        }

        public Builder sixthLsb(boolean sixthLsb) {
            this.sixthLsb = sixthLsb;
            return this;
        }

        public Builder seventhLsb(boolean seventhLsb) {
            this.seventhLsb = seventhLsb;
            return this;
        }

        public Builder eighthLsb(boolean eighthLsb) {
            this.eighthLsb = eighthLsb;
            return this;
        }

        public Builder ninthLsb(boolean ninthLsb) {
            this.ninthLsb = ninthLsb;
            return this;
        }

        public Builder tenthLsb(boolean tenthLsb) {
            this.tenthLsb = tenthLsb;
            return this;
        }

        public Builder eleventhLsb(boolean eleventhLsb) {
            this.eleventhLsb = eleventhLsb;
            return this;
        }

        public Builder twelvethLsb(boolean twelvethLsb) {
            this.twelvethLsb = twelvethLsb;
            return this;
        }

        public Builder thirteenthLsb(boolean thirteenthLsb) {
            this.thirteenthLsb = thirteenthLsb;
            return this;
        }

        public Builder fourteenthLsb(boolean fourteenthLsb) {
            this.fourteenthLsb = fourteenthLsb;
            return this;
        }

        public Builder fifteenthLsb(boolean fifteenthLsb) {
            this.fifteenthLsb = fifteenthLsb;
            return this;
        }

        public Builder sixteenthLsb(boolean sixteenthLsb) {
            this.sixteenthLsb = sixteenthLsb;
            return this;
        }

        public RadiotapDataRxFlags build() {
            return new RadiotapDataRxFlags(this);
        }
    }
}

