/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataRate
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = 3381222627210403160L;
    private static final int LENGTH = 1;
    private final byte rate;

    public static RadiotapDataRate newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataRate(rawData, offset, length);
    }

    private RadiotapDataRate(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 1) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapRate (").append(1).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.rate = ByteArrays.getByte(rawData, offset);
    }

    private RadiotapDataRate(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is null.");
        }
        this.rate = builder.rate;
    }

    public byte getRate() {
        return this.rate;
    }

    public int getRateAsInt() {
        return this.rate & 0xFF;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.toByteArray(this.rate);
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls2 = System.getProperty("line.separator");
        sb.append(indent).append("Rate: ").append(ls2).append(indent).append("  Rate: ").append(this.getRateAsInt() * 500).append(" Kbps").append(ls2);
        return sb.toString();
    }

    public int hashCode() {
        return this.rate;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        RadiotapDataRate other = (RadiotapDataRate)obj;
        return this.rate == other.rate;
    }

    public static final class Builder {
        private byte rate;

        public Builder() {
        }

        private Builder(RadiotapDataRate obj) {
            this.rate = obj.rate;
        }

        public Builder rate(byte rate) {
            this.rate = rate;
            return this;
        }

        public RadiotapDataRate build() {
            return new RadiotapDataRate(this);
        }
    }
}

