/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public class IcmpV6MobilePrefixSolicitationPacket
extends AbstractPacket {
    private static final long serialVersionUID = -6996114480884459960L;
    private final IcmpV6MobilePrefixSolicitationHeader header;

    public static IcmpV6MobilePrefixSolicitationPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IcmpV6MobilePrefixSolicitationPacket(rawData, offset, length);
    }

    private IcmpV6MobilePrefixSolicitationPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IcmpV6MobilePrefixSolicitationHeader(rawData, offset, length);
    }

    private IcmpV6MobilePrefixSolicitationPacket(Builder builder) {
        this.header = new IcmpV6MobilePrefixSolicitationHeader(builder);
    }

    @Override
    public IcmpV6MobilePrefixSolicitationHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6MobilePrefixSolicitationHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -2991706817314703570L;
        private static final int IDENTIFIER_OFFSET = 0;
        private static final int IDENTIFIER_SIZE = 2;
        private static final int RESERVED_OFFSET = 2;
        private static final int RESERVED_SIZE = 2;
        private static final int ICMPV6_MOBILE_PREFIX_SOLICITATION_HEADER_SIZE = 4;
        private final short identifier;
        private final short reserved;

        private IcmpV6MobilePrefixSolicitationHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb = new StringBuilder();
                sb.append("The data is too short to build an ICMPv6 Mobile Prefix Solicitation Header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.identifier = ByteArrays.getShort(rawData, 0 + offset);
            this.reserved = ByteArrays.getShort(rawData, 2 + offset);
        }

        private IcmpV6MobilePrefixSolicitationHeader(Builder builder) {
            this.identifier = builder.identifier;
            this.reserved = builder.reserved;
        }

        public short getIdentifier() {
            return this.identifier;
        }

        public int getIdentifierAsInt() {
            return this.identifier & 0xFFFF;
        }

        public short getReserved() {
            return this.reserved;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.identifier));
            rawFields.add(ByteArrays.toByteArray(this.reserved));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb.append("[ICMPv6 Mobile Prefix Solicitation Header (").append(this.length()).append(" bytes)]").append(ls2);
            sb.append("  Identifier: ").append(this.getIdentifierAsInt()).append(ls2);
            sb.append("  Reserved: ").append(this.reserved).append(ls2);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IcmpV6MobilePrefixSolicitationHeader other = (IcmpV6MobilePrefixSolicitationHeader)obj;
            return this.identifier == other.identifier && this.reserved == other.reserved;
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.identifier;
            result = 31 * result + this.reserved;
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private short identifier;
        private short reserved;

        public Builder() {
        }

        private Builder(IcmpV6MobilePrefixSolicitationPacket packet) {
            this.identifier = packet.header.identifier;
            this.reserved = packet.header.reserved;
        }

        public Builder identifier(short identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder reserved(short reserved) {
            this.reserved = reserved;
            return this;
        }

        @Override
        public IcmpV6MobilePrefixSolicitationPacket build() {
            return new IcmpV6MobilePrefixSolicitationPacket(this);
        }
    }
}

