/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.PacketPropertiesLoader;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.IcmpV4Code;
import org.pcap4j.packet.namednumber.IcmpV4Type;
import org.pcap4j.util.ByteArrays;

public final class IcmpV4CommonPacket
extends AbstractPacket {
    private static final long serialVersionUID = 7643067752830062365L;
    private final IcmpV4CommonHeader header;
    private final Packet payload;

    public static IcmpV4CommonPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IcmpV4CommonPacket(rawData, offset, length);
    }

    private IcmpV4CommonPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IcmpV4CommonHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        this.payload = payloadLength > 0 ? PacketFactories.getFactory(Packet.class, IcmpV4Type.class).newInstance(rawData, offset + this.header.length(), payloadLength, this.header.getType()) : null;
    }

    private IcmpV4CommonPacket(Builder builder) {
        if (builder == null || builder.type == null || builder.code == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.type: ").append(builder.type).append(" builder.code: ").append(builder.code);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new IcmpV4CommonHeader(builder, this.payload != null ? this.payload.getRawData() : new byte[]{});
    }

    @Override
    public IcmpV4CommonHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public boolean hasValidChecksum(boolean acceptZero) {
        byte[] payloadData = this.payload != null ? this.payload.getRawData() : new byte[]{};
        short calculatedChecksum = this.header.calcChecksum(this.header.getRawData(), payloadData);
        if (calculatedChecksum == 0) {
            return true;
        }
        return this.header.checksum == 0 && acceptZero;
    }

    public static final class IcmpV4CommonHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 504881105187659087L;
        private static final int TYPE_OFFSET = 0;
        private static final int TYPE_SIZE = 1;
        private static final int CODE_OFFSET = 1;
        private static final int CODE_SIZE = 1;
        private static final int CHECKSUM_OFFSET = 2;
        private static final int CHECKSUM_SIZE = 2;
        private static final int ICMPV4_COMMON_HEADER_SIZE = 4;
        private final IcmpV4Type type;
        private final IcmpV4Code code;
        private final short checksum;

        private IcmpV4CommonHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an ICMPv4 common header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.type = IcmpV4Type.getInstance(ByteArrays.getByte(rawData, 0 + offset));
            this.code = IcmpV4Code.getInstance((Byte)this.type.value(), ByteArrays.getByte(rawData, 1 + offset));
            this.checksum = ByteArrays.getShort(rawData, 2 + offset);
        }

        private IcmpV4CommonHeader(Builder builder, byte[] payload) {
            this.type = builder.type;
            this.code = builder.code;
            this.checksum = builder.correctChecksumAtBuild ? (PacketPropertiesLoader.getInstance().icmpV4CalcChecksum() ? this.calcChecksum(this.buildRawData(true), payload) : (short)0) : builder.checksum;
        }

        private short calcChecksum(byte[] header, byte[] payload) {
            int packetLength = payload.length + this.length();
            byte[] data = packetLength % 2 != 0 ? new byte[packetLength + 1] : new byte[packetLength];
            System.arraycopy(header, 0, data, 0, header.length);
            System.arraycopy(payload, 0, data, header.length, payload.length);
            return ByteArrays.calcChecksum(data);
        }

        public IcmpV4Type getType() {
            return this.type;
        }

        public IcmpV4Code getCode() {
            return this.code;
        }

        public short getChecksum() {
            return this.checksum;
        }

        @Override
        protected List<byte[]> getRawFields() {
            return this.getRawFields(false);
        }

        private List<byte[]> getRawFields(boolean zeroInsteadOfChecksum) {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Byte)this.type.value()));
            rawFields.add(ByteArrays.toByteArray((Byte)this.code.value()));
            rawFields.add(ByteArrays.toByteArray(zeroInsteadOfChecksum ? (short)0 : this.checksum));
            return rawFields;
        }

        private byte[] buildRawData(boolean zeroInsteadOfChecksum) {
            return ByteArrays.concatenate(this.getRawFields(zeroInsteadOfChecksum));
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb.append("[ICMPv4 Common Header (").append(this.length()).append(" bytes)]").append(ls2);
            sb.append("  Type: ").append(this.type).append(ls2);
            sb.append("  Code: ").append(this.code).append(ls2);
            sb.append("  Checksum: 0x").append(ByteArrays.toHexString(this.checksum, "")).append(ls2);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IcmpV4CommonHeader other = (IcmpV4CommonHeader)obj;
            return this.checksum == other.checksum && this.type.equals(other.type) && this.code.equals(other.code);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.code.hashCode();
            result = 31 * result + this.checksum;
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements ChecksumBuilder<IcmpV4CommonPacket> {
        private IcmpV4Type type;
        private IcmpV4Code code;
        private short checksum;
        private Packet.Builder payloadBuilder;
        private boolean correctChecksumAtBuild;

        public Builder() {
        }

        private Builder(IcmpV4CommonPacket packet) {
            this.type = packet.header.type;
            this.code = packet.header.code;
            this.checksum = packet.header.checksum;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder type(IcmpV4Type type) {
            this.type = type;
            return this;
        }

        public Builder code(IcmpV4Code code) {
            this.code = code;
            return this;
        }

        public Builder checksum(short checksum) {
            this.checksum = checksum;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder correctChecksumAtBuild(boolean correctChecksumAtBuild) {
            this.correctChecksumAtBuild = correctChecksumAtBuild;
            return this;
        }

        @Override
        public IcmpV4CommonPacket build() {
            return new IcmpV4CommonPacket(this);
        }
    }
}

