/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.Dot11InformationElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.util.ByteArrays;

public final class Dot11RequestElement
extends Dot11InformationElement {
    private static final long serialVersionUID = -4248529314922213901L;
    private final List<Dot11InformationElementId> requestedElementIds;

    public static Dot11RequestElement newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11RequestElement(rawData, offset, length);
    }

    private Dot11RequestElement(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        super(rawData, offset, length, Dot11InformationElementId.REQUEST);
        int infoLen = this.getLengthAsInt();
        this.requestedElementIds = new ArrayList<Dot11InformationElementId>(infoLen);
        for (int i2 = 0; i2 < infoLen; ++i2) {
            this.requestedElementIds.add(Dot11InformationElementId.getInstance(rawData[offset + 2 + i2]));
        }
    }

    private Dot11RequestElement(Builder builder) {
        super(builder);
        if (builder.requestedElementIds.size() > 255) {
            throw new IllegalArgumentException("Too long requestedElementIds: " + builder.requestedElementIds);
        }
        this.requestedElementIds = new ArrayList<Dot11InformationElementId>(builder.requestedElementIds);
    }

    public List<Dot11InformationElementId> getRequestedElementIds() {
        return new ArrayList<Dot11InformationElementId>(this.requestedElementIds);
    }

    @Override
    public int length() {
        return 2 + this.requestedElementIds.size();
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getElementId().value();
        rawData[1] = this.getLength();
        int i2 = 0;
        for (Dot11InformationElementId id2 : this.requestedElementIds) {
            rawData[2 + i2] = (Byte)id2.value();
            ++i2;
        }
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.requestedElementIds.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Dot11RequestElement other = (Dot11RequestElement)obj;
        return this.requestedElementIds.equals(other.requestedElementIds);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls2 = System.getProperty("line.separator");
        sb.append(indent).append("Request:").append(ls2);
        sb.append(indent).append("  Element ID: ").append(this.getElementId()).append(ls2);
        sb.append(indent).append("  Length: ").append(this.getLengthAsInt()).append(" bytes").append(ls2);
        for (Dot11InformationElementId id2 : this.requestedElementIds) {
            sb.append(indent).append("  Requested Element: ").append(id2).append(ls2);
        }
        return sb.toString();
    }

    public static final class Builder
    extends Dot11InformationElement.Builder {
        private List<Dot11InformationElementId> requestedElementIds;

        public Builder() {
            this.elementId(Dot11InformationElementId.getInstance((Byte)Dot11InformationElementId.REQUEST.value()));
        }

        private Builder(Dot11RequestElement elem) {
            super(elem);
            this.requestedElementIds = elem.requestedElementIds;
        }

        public Builder requestedElementIds(List<Dot11InformationElementId> requestedElementIds) {
            this.requestedElementIds = requestedElementIds;
            return this;
        }

        @Override
        public Builder length(byte length) {
            super.length(length);
            return this;
        }

        @Override
        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            super.correctLengthAtBuild(correctLengthAtBuild);
            return this;
        }

        @Override
        public Dot11RequestElement build() {
            if (this.requestedElementIds == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("requestedElementIds: ").append(this.requestedElementIds);
                throw new NullPointerException(sb.toString());
            }
            if (this.getCorrectLengthAtBuild()) {
                this.length((byte)this.requestedElementIds.size());
            }
            return new Dot11RequestElement(this);
        }
    }
}

