/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.Dot11FrameControl;
import org.pcap4j.packet.Dot11HtControl;
import org.pcap4j.packet.Dot11SequenceControl;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.MacAddress;

public abstract class Dot11ManagementPacket
extends AbstractPacket {
    private static final long serialVersionUID = -3972573868672848666L;
    private final Integer fcs;

    protected Dot11ManagementPacket(byte[] rawData, int offset, int length, int headerLen) {
        int remainingLen = length - headerLen;
        this.fcs = remainingLen >= 4 ? Integer.valueOf(ByteArrays.getInt(rawData, offset + headerLen, ByteOrder.LITTLE_ENDIAN)) : null;
    }

    protected Dot11ManagementPacket(Builder builder, Dot11ManagementHeader header) {
        this.fcs = builder.correctChecksumAtBuild ? Integer.valueOf(ByteArrays.calcCrc32Checksum(header.getRawData())) : builder.fcs;
    }

    @Override
    public abstract Dot11ManagementHeader getHeader();

    public Integer getFcs() {
        return this.fcs;
    }

    @Override
    protected int calcLength() {
        int length = super.calcLength();
        if (this.fcs != null) {
            length += 4;
        }
        return length;
    }

    @Override
    protected byte[] buildRawData() {
        byte[] rawData = super.buildRawData();
        if (this.fcs != null) {
            System.arraycopy(ByteArrays.toByteArray((int)this.fcs, ByteOrder.LITTLE_ENDIAN), 0, rawData, rawData.length - 4, 4);
        }
        return rawData;
    }

    @Override
    protected String buildString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHeader().toString());
        if (this.fcs != null) {
            String ls2 = System.getProperty("line.separator");
            sb.append("[IEEE802.11 Management Packet FCS]").append(ls2).append("  FCS: 0x").append(ByteArrays.toHexString(this.fcs, "")).append(ls2);
        }
        return sb.toString();
    }

    @Override
    public abstract Builder getBuilder();

    public boolean hasValidFcs() {
        if (this.fcs == null) {
            return false;
        }
        return ByteArrays.calcCrc32Checksum(this.getHeader().getRawData()) == this.fcs;
    }

    public static abstract class Dot11ManagementHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 615170086003609919L;
        private static final int FRAME_CONTROL_OFFSET = 0;
        private static final int FRAME_CONTROL_SIZE = 2;
        private static final int DURATION_OFFSET = 2;
        private static final int DURATION_SIZE = 2;
        private static final int ADDRESS1_OFFSET = 4;
        private static final int ADDRESS1_SIZE = 6;
        private static final int ADDRESS2_OFFSET = 10;
        private static final int ADDRESS2_SIZE = 6;
        private static final int ADDRESS3_OFFSET = 16;
        private static final int ADDRESS3_SIZE = 6;
        private static final int SEQUENCE_CONTROL_OFFSET = 22;
        private static final int SEQUENCE_CONTROL_SIZE = 2;
        private static final int HT_CONTROL_OFFSET = 24;
        private static final int HT_CONTROL_SIZE = 4;
        private static final int DOT11_HEADER_MIN_SIZE = 24;
        private final Dot11FrameControl frameControl;
        private final short duration;
        private final MacAddress address1;
        private final MacAddress address2;
        private final MacAddress address3;
        private final Dot11SequenceControl sequenceControl;
        private final Dot11HtControl htControl;

        protected Dot11ManagementHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 24) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("The data is too short to build a Dot11ManagementHeader (").append(24).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.frameControl = Dot11FrameControl.newInstance(rawData, offset + 0, length);
            this.duration = ByteArrays.getShort(rawData, offset + 2, ByteOrder.LITTLE_ENDIAN);
            this.address1 = ByteArrays.getMacAddress(rawData, offset + 4);
            this.address2 = ByteArrays.getMacAddress(rawData, offset + 10);
            this.address3 = ByteArrays.getMacAddress(rawData, offset + 16);
            this.sequenceControl = Dot11SequenceControl.newInstance(rawData, offset + 22, length - 22);
            if (this.frameControl.isOrder()) {
                if (length < 28) {
                    StringBuilder sb = new StringBuilder(200);
                    sb.append("The data is too short to build a Dot11ManagementHeader (").append(28).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                    throw new IllegalRawDataException(sb.toString());
                }
                this.htControl = Dot11HtControl.newInstance(rawData, offset + 24, length - 24);
            } else {
                this.htControl = null;
            }
        }

        protected Dot11ManagementHeader(Builder builder) {
            this.frameControl = builder.frameControl;
            this.duration = builder.duration;
            this.address1 = builder.address1;
            this.address2 = builder.address2;
            this.address3 = builder.address3;
            this.sequenceControl = builder.sequenceControl;
            this.htControl = builder.htControl;
        }

        public Dot11FrameControl getFrameControl() {
            return this.frameControl;
        }

        public short getDuration() {
            return this.duration;
        }

        public int getDurationAsInt() {
            return this.duration & 0xFFFF;
        }

        public MacAddress getAddress1() {
            return this.address1;
        }

        public MacAddress getAddress2() {
            return this.address2;
        }

        public MacAddress getAddress3() {
            return this.address3;
        }

        public Dot11SequenceControl getSequenceControl() {
            return this.sequenceControl;
        }

        public Dot11HtControl getHtControl() {
            return this.htControl;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(this.frameControl.getRawData());
            rawFields.add(ByteArrays.toByteArray(this.duration, ByteOrder.LITTLE_ENDIAN));
            rawFields.add(this.address1.getAddress());
            rawFields.add(this.address2.getAddress());
            rawFields.add(this.address3.getAddress());
            rawFields.add(this.sequenceControl.getRawData());
            if (this.htControl != null) {
                rawFields.add(this.htControl.getRawData());
            }
            return rawFields;
        }

        @Override
        public int calcLength() {
            if (this.htControl != null) {
                return 28;
            }
            return 24;
        }

        protected abstract String getHeaderName();

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb.append("[").append(this.getHeaderName()).append(" (").append(this.length()).append(" bytes)]").append(ls2);
            sb.append("  Frame Control:").append(ls2).append(this.frameControl.toString("    "));
            sb.append("  Duration: ").append(this.getDurationAsInt()).append(ls2);
            sb.append("  Address1: ").append(this.address1).append(ls2);
            sb.append("  Address2: ").append(this.address2).append(ls2);
            sb.append("  Address3: ").append(this.address3).append(ls2);
            sb.append("  Sequence Control: ").append(this.sequenceControl).append(ls2);
            if (this.htControl != null) {
                sb.append("  HT Control:").append(ls2).append(this.htControl.toString("    "));
            }
            return sb.toString();
        }

        @Override
        protected int calcHashCode() {
            int prime = 31;
            int result = 17;
            result = 31 * result + this.address1.hashCode();
            result = 31 * result + this.address2.hashCode();
            result = 31 * result + this.address3.hashCode();
            result = 31 * result + this.duration;
            result = 31 * result + this.frameControl.hashCode();
            result = 31 * result + (this.htControl != null ? this.htControl.hashCode() : 0);
            result = 31 * result + this.sequenceControl.hashCode();
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Dot11ManagementHeader other = (Dot11ManagementHeader)obj;
            if (!this.address1.equals(other.address1)) {
                return false;
            }
            if (!this.address2.equals(other.address2)) {
                return false;
            }
            if (!this.address3.equals(other.address3)) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            if (!this.frameControl.equals(other.frameControl)) {
                return false;
            }
            if (this.htControl == null ? other.htControl != null : !this.htControl.equals(other.htControl)) {
                return false;
            }
            return this.sequenceControl.equals(other.sequenceControl);
        }
    }

    public static abstract class Builder
    extends AbstractPacket.AbstractBuilder
    implements ChecksumBuilder<Dot11ManagementPacket> {
        private Dot11FrameControl frameControl;
        private short duration;
        private MacAddress address1;
        private MacAddress address2;
        private MacAddress address3;
        private Dot11SequenceControl sequenceControl;
        private Dot11HtControl htControl;
        private Integer fcs;
        private boolean correctChecksumAtBuild;

        public Builder() {
        }

        protected Builder(Dot11ManagementPacket packet) {
            this.frameControl = packet.getHeader().frameControl;
            this.duration = packet.getHeader().duration;
            this.address1 = packet.getHeader().address1;
            this.address2 = packet.getHeader().address2;
            this.address3 = packet.getHeader().address3;
            this.sequenceControl = packet.getHeader().sequenceControl;
            this.htControl = packet.getHeader().htControl;
            this.fcs = packet.fcs;
        }

        public Builder frameControl(Dot11FrameControl frameControl) {
            this.frameControl = frameControl;
            return this;
        }

        public Builder duration(short duration) {
            this.duration = duration;
            return this;
        }

        public Builder address1(MacAddress address1) {
            this.address1 = address1;
            return this;
        }

        public Builder address2(MacAddress address2) {
            this.address2 = address2;
            return this;
        }

        public Builder address3(MacAddress address3) {
            this.address3 = address3;
            return this;
        }

        public Builder sequenceControl(Dot11SequenceControl sequenceControl) {
            this.sequenceControl = sequenceControl;
            return this;
        }

        public Builder htControl(Dot11HtControl htControl) {
            this.htControl = htControl;
            return this;
        }

        public Builder fcs(Integer fcs) {
            this.fcs = fcs;
            return this;
        }

        public Builder correctChecksumAtBuild(boolean correctChecksumAtBuild) {
            this.correctChecksumAtBuild = correctChecksumAtBuild;
            return this;
        }

        protected void checkForNull() {
            if (this.frameControl == null || this.address1 == null || this.address2 == null || this.address3 == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("frameControl: ").append(this.frameControl).append(" address1: ").append(this.address1).append(" address2: ").append(this.address2).append(" address3: ").append(this.address3);
                throw new NullPointerException(sb.toString());
            }
        }

        @Override
        public abstract Dot11ManagementPacket build();
    }
}

