/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.util.ByteArrays;

public abstract class Dot11InformationElement
implements Serializable {
    private static final long serialVersionUID = 3620485938137514351L;
    private final Dot11InformationElementId elementId;
    private final byte length;

    protected Dot11InformationElement(byte[] rawData, int offset, int length, Dot11InformationElementId id2) throws IllegalRawDataException {
        if (length < 2) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data length must be more than 1. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[offset] != (Byte)id2.value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The element ID must be ").append(id2.valueAsString()).append(" but is actually ").append(rawData[offset]).append(". rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.elementId = id2;
        this.length = rawData[1 + offset];
        int lenAsInt = this.getLengthAsInt();
        if (lenAsInt > length - 2) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("rawData is too short. length field: ").append(lenAsInt).append(", rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
    }

    protected Dot11InformationElement(Builder builder) {
        if (builder == null || builder.elementId == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.elementId: ").append(builder.elementId);
            throw new NullPointerException(sb.toString());
        }
        this.elementId = builder.elementId;
        this.length = builder.length;
    }

    public Dot11InformationElementId getElementId() {
        return this.elementId;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public abstract int length();

    public abstract byte[] getRawData();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.elementId.hashCode();
        result = 31 * result + this.length;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dot11InformationElement other = (Dot11InformationElement)obj;
        if (!this.elementId.equals(other.elementId)) {
            return false;
        }
        return this.length == other.length;
    }

    public static abstract class Builder
    implements LengthBuilder<Dot11InformationElement> {
        private Dot11InformationElementId elementId;
        private byte length;
        private boolean correctLengthAtBuild;

        protected Builder() {
        }

        protected Builder(Dot11InformationElement elem) {
            this.elementId = elem.elementId;
            this.length = elem.length;
        }

        protected Builder elementId(Dot11InformationElementId elementId) {
            this.elementId = elementId;
            return this;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        protected boolean getCorrectLengthAtBuild() {
            return this.correctLengthAtBuild;
        }
    }
}

