/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataNull
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = -8881175833056081958L;
    private final byte[] rawData;

    public static DnsRDataNull newInstance(byte[] rawData, int offset, int length) {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataNull(rawData, offset, length);
    }

    private DnsRDataNull(byte[] rawData, int offset, int length) {
        this.rawData = ByteArrays.getSubArray(rawData, offset, length);
    }

    private DnsRDataNull(Builder builder) {
        if (builder == null || builder.rawData == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.rawData: ").append(builder.rawData);
            throw new NullPointerException(sb.toString());
        }
        this.rawData = ByteArrays.clone(builder.rawData);
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.clone(this.rawData);
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls2 = System.getProperty("line.separator");
        sb.append(indent).append("NULL RDATA:").append(ls2).append(indent).append("  data: ").append(ByteArrays.toHexString(this.rawData, "")).append(ls2);
        return sb.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawData);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        DnsRDataNull other = (DnsRDataNull)obj;
        return Arrays.equals(this.rawData, other.rawData);
    }

    public static final class Builder {
        private byte[] rawData;

        public Builder() {
        }

        private Builder(DnsRDataNull obj) {
            this.rawData = obj.rawData;
        }

        public Builder rawData(byte[] rawData) {
            this.rawData = rawData;
            return this;
        }

        public DnsRDataNull build() {
            return new DnsRDataNull(this);
        }
    }
}

