/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataHInfo
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = -4910328276617707827L;
    private final String cpu;
    private final String os;

    public static DnsRDataHInfo newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataHInfo(rawData, offset, length);
    }

    private DnsRDataHInfo(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        int cpuLen = rawData[offset] & 0xFF;
        int cursor = 1;
        if (cpuLen + 1 > length - cursor) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build cpu and os in DnsRDataHInfo. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor);
            throw new IllegalRawDataException(sb.toString());
        }
        this.cpu = new String(rawData, offset + cursor, cpuLen);
        cursor += cpuLen;
        int osLen = rawData[offset + cursor] & 0xFF;
        if (osLen > length - ++cursor) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build os in DnsRDataHInfo (").append(osLen).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor);
            throw new IllegalRawDataException(sb.toString());
        }
        this.os = new String(rawData, offset + cursor, osLen);
    }

    private DnsRDataHInfo(Builder builder) {
        if (builder == null || builder.cpu == null || builder.os == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.cpu: ").append(builder.cpu).append(" builder.os: ").append(builder.os);
            throw new NullPointerException(sb.toString());
        }
        if (builder.cpu.getBytes().length > 255) {
            throw new IllegalArgumentException("Length of cpu must be less than 256. cpu: " + builder.cpu);
        }
        if (builder.os.getBytes().length > 255) {
            throw new IllegalArgumentException("Length of os must be less than 256. os: " + builder.os);
        }
        this.cpu = builder.cpu;
        this.os = builder.os;
    }

    public String getCpu() {
        return this.cpu;
    }

    public String getOs() {
        return this.os;
    }

    @Override
    public int length() {
        return this.cpu.getBytes().length + this.os.getBytes().length + 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] data = new byte[this.length()];
        int cursor = 0;
        byte[] rawCpu = this.cpu.getBytes();
        data[cursor] = (byte)rawCpu.length;
        System.arraycopy(rawCpu, 0, data, ++cursor, rawCpu.length);
        byte[] rawOs = this.os.getBytes();
        data[cursor += rawCpu.length] = (byte)rawOs.length;
        System.arraycopy(rawOs, 0, data, ++cursor, rawOs.length);
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls2 = System.getProperty("line.separator");
        sb.append(indent).append("HINFO RDATA:").append(ls2).append(indent).append("  CPU: ").append(this.cpu).append(ls2).append(indent).append("  OS: ").append(this.os).append(ls2);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cpu.hashCode();
        result = 31 * result + this.os.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DnsRDataHInfo other = (DnsRDataHInfo)obj;
        if (!this.cpu.equals(other.cpu)) {
            return false;
        }
        return this.os.equals(other.os);
    }

    public static final class Builder {
        private String cpu;
        private String os;

        public Builder() {
        }

        private Builder(DnsRDataHInfo obj) {
            this.cpu = obj.cpu;
            this.os = obj.os;
        }

        public Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public Builder os(String os) {
            this.os = os;
            return this;
        }

        public DnsRDataHInfo build() {
            return new DnsRDataHInfo(this);
        }
    }
}

