/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.field.FieldUtils;

public abstract class AbstractPartialFieldProperty {
    protected AbstractPartialFieldProperty() {
    }

    public abstract DateTimeField getField();

    public DateTimeFieldType getFieldType() {
        return this.getField().getType();
    }

    public String getName() {
        return this.getField().getName();
    }

    protected abstract ReadablePartial getReadablePartial();

    public abstract int get();

    public String getAsString() {
        return Integer.toString(this.get());
    }

    public String getAsText() {
        return this.getAsText(null);
    }

    public String getAsText(Locale locale) {
        return this.getField().getAsText(this.getReadablePartial(), this.get(), locale);
    }

    public String getAsShortText() {
        return this.getAsShortText(null);
    }

    public String getAsShortText(Locale locale) {
        return this.getField().getAsShortText(this.getReadablePartial(), this.get(), locale);
    }

    public DurationField getDurationField() {
        return this.getField().getDurationField();
    }

    public DurationField getRangeDurationField() {
        return this.getField().getRangeDurationField();
    }

    public int getMinimumValueOverall() {
        return this.getField().getMinimumValue();
    }

    public int getMinimumValue() {
        return this.getField().getMinimumValue(this.getReadablePartial());
    }

    public int getMaximumValueOverall() {
        return this.getField().getMaximumValue();
    }

    public int getMaximumValue() {
        return this.getField().getMaximumValue(this.getReadablePartial());
    }

    public int getMaximumTextLength(Locale locale) {
        return this.getField().getMaximumTextLength(locale);
    }

    public int getMaximumShortTextLength(Locale locale) {
        return this.getField().getMaximumShortTextLength(locale);
    }

    public int compareTo(ReadableInstant readableInstant) {
        int n2;
        if (readableInstant == null) {
            throw new IllegalArgumentException("The instant must not be null");
        }
        int n3 = this.get();
        if (n3 < (n2 = readableInstant.get(this.getFieldType()))) {
            return -1;
        }
        if (n3 > n2) {
            return 1;
        }
        return 0;
    }

    public int compareTo(ReadablePartial readablePartial) {
        int n2;
        if (readablePartial == null) {
            throw new IllegalArgumentException("The instant must not be null");
        }
        int n3 = this.get();
        if (n3 < (n2 = readablePartial.get(this.getFieldType()))) {
            return -1;
        }
        if (n3 > n2) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractPartialFieldProperty)) {
            return false;
        }
        AbstractPartialFieldProperty abstractPartialFieldProperty = (AbstractPartialFieldProperty)object;
        return this.get() == abstractPartialFieldProperty.get() && this.getFieldType() == abstractPartialFieldProperty.getFieldType() && FieldUtils.equals(this.getReadablePartial().getChronology(), abstractPartialFieldProperty.getReadablePartial().getChronology());
    }

    public int hashCode() {
        int n2 = 19;
        n2 = 13 * n2 + this.get();
        n2 = 13 * n2 + this.getFieldType().hashCode();
        n2 = 13 * n2 + this.getReadablePartial().getChronology().hashCode();
        return n2;
    }

    public String toString() {
        return "Property[" + this.getName() + "]";
    }
}

