/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.FieldUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSingleFieldPeriod
implements ReadablePeriod,
Comparable<BaseSingleFieldPeriod>,
Serializable {
    private static final long serialVersionUID = 9386874258972L;
    private static final long START_1972 = 63072000000L;
    private volatile int iPeriod;

    protected static int between(ReadableInstant readableInstant, ReadableInstant readableInstant2, DurationFieldType durationFieldType) {
        if (readableInstant == null || readableInstant2 == null) {
            throw new IllegalArgumentException("ReadableInstant objects must not be null");
        }
        Chronology chronology = DateTimeUtils.getInstantChronology(readableInstant);
        int n2 = durationFieldType.getField(chronology).getDifference(readableInstant2.getMillis(), readableInstant.getMillis());
        return n2;
    }

    protected static int between(ReadablePartial readablePartial, ReadablePartial readablePartial2, ReadablePeriod readablePeriod) {
        if (readablePartial == null || readablePartial2 == null) {
            throw new IllegalArgumentException("ReadablePartial objects must not be null");
        }
        if (readablePartial.size() != readablePartial2.size()) {
            throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
        }
        int n2 = readablePartial.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (readablePartial.getFieldType(i2) == readablePartial2.getFieldType(i2)) continue;
            throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
        }
        if (!DateTimeUtils.isContiguous(readablePartial)) {
            throw new IllegalArgumentException("ReadablePartial objects must be contiguous");
        }
        Chronology chronology = DateTimeUtils.getChronology(readablePartial.getChronology()).withUTC();
        int[] nArray = chronology.get(readablePeriod, chronology.set(readablePartial, 63072000000L), chronology.set(readablePartial2, 63072000000L));
        return nArray[0];
    }

    protected static int standardPeriodIn(ReadablePeriod readablePeriod, long l2) {
        if (readablePeriod == null) {
            return 0;
        }
        ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
        long l3 = 0L;
        for (int i2 = 0; i2 < readablePeriod.size(); ++i2) {
            int n2 = readablePeriod.getValue(i2);
            if (n2 == 0) continue;
            DurationField durationField = readablePeriod.getFieldType(i2).getField(iSOChronology);
            if (!durationField.isPrecise()) {
                throw new IllegalArgumentException("Cannot convert period to duration as " + durationField.getName() + " is not precise in the period " + readablePeriod);
            }
            l3 = FieldUtils.safeAdd(l3, FieldUtils.safeMultiply(durationField.getUnitMillis(), n2));
        }
        return FieldUtils.safeToInt(l3 / l2);
    }

    protected BaseSingleFieldPeriod(int n2) {
        this.iPeriod = n2;
    }

    protected int getValue() {
        return this.iPeriod;
    }

    protected void setValue(int n2) {
        this.iPeriod = n2;
    }

    public abstract DurationFieldType getFieldType();

    @Override
    public abstract PeriodType getPeriodType();

    @Override
    public int size() {
        return 1;
    }

    @Override
    public DurationFieldType getFieldType(int n2) {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return this.getFieldType();
    }

    @Override
    public int getValue(int n2) {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return this.getValue();
    }

    @Override
    public int get(DurationFieldType durationFieldType) {
        if (durationFieldType == this.getFieldType()) {
            return this.getValue();
        }
        return 0;
    }

    @Override
    public boolean isSupported(DurationFieldType durationFieldType) {
        return durationFieldType == this.getFieldType();
    }

    @Override
    public Period toPeriod() {
        return Period.ZERO.withFields(this);
    }

    @Override
    public MutablePeriod toMutablePeriod() {
        MutablePeriod mutablePeriod = new MutablePeriod();
        mutablePeriod.add(this);
        return mutablePeriod;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReadablePeriod)) {
            return false;
        }
        ReadablePeriod readablePeriod = (ReadablePeriod)object;
        return readablePeriod.getPeriodType() == this.getPeriodType() && readablePeriod.getValue(0) == this.getValue();
    }

    @Override
    public int hashCode() {
        int n2 = 17;
        n2 = 27 * n2 + this.getValue();
        n2 = 27 * n2 + this.getFieldType().hashCode();
        return n2;
    }

    @Override
    public int compareTo(BaseSingleFieldPeriod baseSingleFieldPeriod) {
        if (baseSingleFieldPeriod.getClass() != this.getClass()) {
            throw new ClassCastException(this.getClass() + " cannot be compared to " + baseSingleFieldPeriod.getClass());
        }
        int n2 = baseSingleFieldPeriod.getValue();
        int n3 = this.getValue();
        if (n3 > n2) {
            return 1;
        }
        if (n3 < n2) {
            return -1;
        }
        return 0;
    }
}

