/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.statement.ColonPrefixSqlParser;
import org.jdbi.v3.core.statement.DefinedAttributeTemplateEngine;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementCustomizer;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.core.statement.TimingCollector;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.meta.Beta;

public final class SqlStatements
implements JdbiConfig<SqlStatements> {
    private final Map<String, Object> attributes;
    private TemplateEngine templateEngine;
    private Cache<Map.Entry<TemplateEngine, String>, Function<StatementContext, String>> templateCache;
    private SqlParser sqlParser;
    private SqlLogger sqlLogger;
    private Integer queryTimeout;
    private boolean allowUnusedBindings;
    private final Collection<StatementCustomizer> customizers = new CopyOnWriteArrayList<StatementCustomizer>();

    public SqlStatements() {
        this.attributes = Collections.synchronizedMap(new HashMap());
        this.templateEngine = new DefinedAttributeTemplateEngine();
        this.sqlParser = new ColonPrefixSqlParser();
        this.sqlLogger = SqlLogger.NOP_SQL_LOGGER;
        this.queryTimeout = null;
        this.templateCache = Caffeine.newBuilder().maximumSize(1000L).build();
    }

    private SqlStatements(SqlStatements that) {
        this.attributes = Collections.synchronizedMap(that.getAttributes());
        this.templateEngine = that.templateEngine;
        this.sqlParser = that.sqlParser;
        this.sqlLogger = that.sqlLogger;
        this.queryTimeout = that.queryTimeout;
        this.allowUnusedBindings = that.allowUnusedBindings;
        this.customizers.addAll(that.customizers);
        this.templateCache = that.templateCache;
    }

    public SqlStatements define(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public SqlStatements defineMap(Map<String, ?> values2) {
        if (values2 != null) {
            this.attributes.putAll(values2);
        }
        return this;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>(this.attributes);
    }

    public SqlStatements addCustomizer(StatementCustomizer customizer) {
        this.customizers.add(customizer);
        return this;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public SqlStatements setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        return this;
    }

    @Beta
    public SqlStatements setTemplateCache(Caffeine<Object, Object> caffeineSpec) {
        this.templateCache = caffeineSpec.build();
        return this;
    }

    public SqlParser getSqlParser() {
        return this.sqlParser;
    }

    public SqlStatements setSqlParser(SqlParser sqlParser) {
        this.sqlParser = sqlParser;
        return this;
    }

    @Deprecated
    public TimingCollector getTimingCollector() {
        return (elapsed, ctx) -> this.sqlLogger.logAfterExecution(ctx);
    }

    @Deprecated
    public SqlStatements setTimingCollector(final TimingCollector timingCollector) {
        this.sqlLogger = timingCollector == null ? SqlLogger.NOP_SQL_LOGGER : new SqlLogger(){

            @Override
            public void logAfterExecution(StatementContext context) {
                timingCollector.collect(context.getElapsedTime(ChronoUnit.NANOS), context);
            }
        };
        return this;
    }

    public SqlLogger getSqlLogger() {
        return this.sqlLogger;
    }

    public SqlStatements setSqlLogger(SqlLogger sqlLogger) {
        this.sqlLogger = sqlLogger == null ? SqlLogger.NOP_SQL_LOGGER : sqlLogger;
        return this;
    }

    @Beta
    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    @Beta
    public SqlStatements setQueryTimeout(@Nullable Integer seconds) {
        if (seconds != null && seconds < 0) {
            throw new IllegalArgumentException("queryTimeout must not be < 0");
        }
        this.queryTimeout = seconds;
        return this;
    }

    public boolean isUnusedBindingAllowed() {
        return this.allowUnusedBindings;
    }

    public SqlStatements setUnusedBindingAllowed(boolean unusedBindingAllowed) {
        this.allowUnusedBindings = unusedBindingAllowed;
        return this;
    }

    void customize(Statement statement) throws SQLException {
        if (this.queryTimeout != null) {
            statement.setQueryTimeout(this.queryTimeout);
        }
    }

    @Override
    public SqlStatements createCopy() {
        return new SqlStatements(this);
    }

    Collection<StatementCustomizer> getCustomizers() {
        return this.customizers;
    }

    String preparedRender(String template, StatementContext ctx) {
        try {
            return Optional.ofNullable(this.templateCache.get(new AbstractMap.SimpleEntry<TemplateEngine, String>(this.templateEngine, template), e2 -> ((TemplateEngine)e2.getKey()).parse((String)e2.getValue(), ctx.getConfig()).orElse(null))).orElse(cx2 -> this.templateEngine.render(template, (StatementContext)cx2)).apply(ctx);
        }
        catch (IllegalArgumentException e3) {
            throw new UnableToCreateStatementException("Exception rendering SQL template", e3, ctx);
        }
    }
}

