/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.Token;
import org.jdbi.v3.core.internal.lexer.HashStatementLexer;
import org.jdbi.v3.core.statement.CachingSqlParser;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.internal.ErrorListener;
import org.jdbi.v3.meta.Beta;

public class HashPrefixSqlParser
extends CachingSqlParser {
    public HashPrefixSqlParser() {
    }

    @Beta
    public HashPrefixSqlParser(Caffeine<Object, Object> cache) {
        super(cache);
    }

    @Override
    public String nameParameter(String rawName, StatementContext ctx) {
        return "#" + rawName;
    }

    @Override
    ParsedSql internalParse(String sql) {
        ParsedSql.Builder parsedSql = ParsedSql.builder();
        HashStatementLexer lexer = new HashStatementLexer(CharStreams.fromString(sql));
        lexer.addErrorListener(new ErrorListener());
        Token t2 = lexer.nextToken();
        while (t2.getType() != -1) {
            switch (t2.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    parsedSql.append(t2.getText());
                    break;
                }
                case 5: {
                    parsedSql.appendNamedParameter(t2.getText().substring(1));
                    break;
                }
                case 6: {
                    parsedSql.appendPositionalParameter();
                    break;
                }
                case 4: {
                    parsedSql.append(t2.getText().substring(1));
                    break;
                }
            }
            t2 = lexer.nextToken();
        }
        return parsedSql.build();
    }
}

