/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.result;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.result.ResultSetResultIterator;
import org.jdbi.v3.core.result.StreamCallback;
import org.jdbi.v3.core.result.StreamConsumer;
import org.jdbi.v3.core.statement.StatementContext;

@FunctionalInterface
public interface ResultIterable<T>
extends Iterable<T> {
    public static <T> ResultIterable<T> of(Supplier<ResultSet> supplier, RowMapper<T> mapper, StatementContext ctx) {
        return () -> {
            try {
                return new ResultSetResultIterator((ResultSet)supplier.get(), mapper, ctx);
            }
            catch (SQLException e2) {
                try {
                    ctx.close();
                }
                catch (Exception e1) {
                    e2.addSuppressed(e1);
                }
                throw new ResultSetException("Unable to iterator result set", e2, ctx);
            }
        };
    }

    public static <T> ResultIterable<T> of(ResultIterator<T> iterator2) {
        return () -> iterator2;
    }

    @Override
    public ResultIterator<T> iterator();

    default public <U> ResultIterable<U> map(final Function<? super T, ? extends U> mapper) {
        return () -> new ResultIterator<U>(){
            private final ResultIterator<T> delegate;
            {
                this.delegate = ResultIterable.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(this.delegate.next());
            }

            @Override
            public StatementContext getContext() {
                return this.delegate.getContext();
            }

            @Override
            public void close() {
                this.delegate.close();
            }
        };
    }

    @Override
    default public void forEach(Consumer<? super T> action) {
        try (Iterator iterator2 = this.iterator();){
            iterator2.forEachRemaining(action);
        }
    }

    default public T one() {
        try (Iterator iter = this.iterator();){
            if (!iter.hasNext()) {
                throw new IllegalStateException("Expected one element, but found none");
            }
            Object r2 = iter.next();
            if (iter.hasNext()) {
                throw new IllegalStateException("Expected one element, but found multiple");
            }
            Object e2 = r2;
            return (T)e2;
        }
    }

    default public Optional<T> findOne() {
        try (Iterator iter = this.iterator();){
            if (!iter.hasNext()) {
                Optional optional = Optional.empty();
                return optional;
            }
            Object r2 = iter.next();
            if (iter.hasNext()) {
                throw new IllegalStateException("Expected zero to one elements, but found multiple");
            }
            Optional optional = Optional.ofNullable(r2);
            return optional;
        }
    }

    @Deprecated
    default public T findOnly() {
        return this.one();
    }

    default public T first() {
        try (Iterator iter = this.iterator();){
            if (!iter.hasNext()) {
                throw new IllegalStateException("Expected at least one element, but found none");
            }
            Object e2 = iter.next();
            return (T)e2;
        }
    }

    default public Optional<T> findFirst() {
        try (Iterator iter = this.iterator();){
            Optional optional = iter.hasNext() ? Optional.ofNullable(iter.next()) : Optional.empty();
            return optional;
        }
    }

    default public Stream<T> stream() {
        Iterator iterator2 = this.iterator();
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator2, 0), false).onClose(((ResultIterator)iterator2)::close);
    }

    default public <X extends Exception> void useStream(StreamConsumer<T, X> consumer) throws X {
        this.withStream(stream -> {
            consumer.useStream(stream);
            return null;
        });
    }

    default public <R, X extends Exception> R withStream(StreamCallback<T, R, X> callback) throws X {
        try (Stream<T> stream = this.stream();){
            R r2 = callback.withStream(stream);
            return r2;
        }
    }

    default public List<T> list() {
        return this.collect(Collectors.toList());
    }

    default public <R> R collect(Collector<? super T, ?, R> collector) {
        try (Stream<? super T> stream = this.stream();){
            R r2 = stream.collect(collector);
            return r2;
        }
    }

    default public <U> U reduce(U identity, BiFunction<U, T, U> accumulator) {
        try (Stream<T> stream = this.stream();){
            U u3 = stream.reduce(identity, accumulator, (u2, v2) -> {
                throw new UnsupportedOperationException("parallel operation not supported");
            });
            return u3;
        }
    }
}

