/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.result;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jdbi.v3.core.collector.ElementTypeNotFoundException;
import org.jdbi.v3.core.collector.NoSuchCollectorException;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.GenericMapMapperFactory;
import org.jdbi.v3.core.mapper.MapMapper;
import org.jdbi.v3.core.mapper.NoSuchMapperException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowViewMapper;
import org.jdbi.v3.core.mapper.SingleColumnMapper;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.result.ResultSetAccumulator;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.result.ResultSetScanner;
import org.jdbi.v3.core.result.RowReducer;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.result.UnableToProduceResultException;
import org.jdbi.v3.core.result.internal.RowViewImpl;
import org.jdbi.v3.core.statement.StatementContext;

public interface ResultBearing {
    public static ResultBearing of(final Supplier<ResultSet> resultSetSupplier, final StatementContext ctx) {
        return new ResultBearing(){

            @Override
            public <R> R scanResultSet(ResultSetScanner<R> mapper) {
                try {
                    return mapper.scanResultSet(resultSetSupplier, ctx);
                }
                catch (SQLException e2) {
                    throw new ResultSetException("Error reading result set", e2, ctx);
                }
            }
        };
    }

    public <R> R scanResultSet(ResultSetScanner<R> var1);

    default public <T> ResultIterable<T> mapTo(Class<T> type) {
        return this.mapTo(QualifiedType.of(type));
    }

    default public <T> ResultIterable<T> mapTo(GenericType<T> type) {
        return this.mapTo(QualifiedType.of(type));
    }

    default public ResultIterable<?> mapTo(Type type) {
        return this.mapTo(QualifiedType.of(type));
    }

    default public <T> ResultIterable<T> mapTo(QualifiedType<T> type) {
        return this.scanResultSet((supplier, ctx) -> {
            RowMapper mapper = ctx.findMapperFor(type).orElseThrow(() -> new NoSuchMapperException("No mapper registered for type " + type));
            return ResultIterable.of(supplier, mapper, ctx);
        });
    }

    default public <T> ResultIterable<T> mapToBean(Class<T> type) {
        return this.map(BeanMapper.of(type));
    }

    default public ResultIterable<Map<String, Object>> mapToMap() {
        return this.map(new MapMapper());
    }

    default public <T> ResultIterable<Map<String, T>> mapToMap(Class<T> valueType) {
        return this.scanResultSet((supplier, ctx) -> ResultIterable.of(supplier, GenericMapMapperFactory.getMapperForValueType(valueType, ctx.getConfig()), ctx));
    }

    default public <T> ResultIterable<Map<String, T>> mapToMap(GenericType<T> valueType) {
        return this.scanResultSet((supplier, ctx) -> ResultIterable.of(supplier, GenericMapMapperFactory.getMapperForValueType(valueType, ctx.getConfig()), ctx));
    }

    default public <T> ResultIterable<T> map(ColumnMapper<T> mapper) {
        return this.map(new SingleColumnMapper<T>(mapper));
    }

    default public <T> ResultIterable<T> map(RowMapper<T> mapper) {
        return this.scanResultSet((supplier, ctx) -> ResultIterable.of(supplier, mapper, ctx));
    }

    default public <T> ResultIterable<T> map(RowViewMapper<T> mapper) {
        return this.map((RowMapper<T>)mapper);
    }

    default public <C, R> Stream<R> reduceRows(RowReducer<C, R> reducer) {
        return this.scanResultSet((supplier, ctx) -> {
            try {
                Stream stream;
                block12: {
                    ResultSet rs = (ResultSet)supplier.get();
                    try {
                        RowViewImpl rowView = new RowViewImpl(rs, ctx);
                        Object container = reducer.container();
                        while (rs.next()) {
                            reducer.accumulate(container, rowView);
                        }
                        stream = reducer.stream(container);
                        if (rs == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e2) {
                            throw new UnableToProduceResultException(e2, ctx);
                        }
                    }
                    rs.close();
                }
                return stream;
            }
            finally {
                ctx.close();
            }
        });
    }

    default public <K, V> Stream<V> reduceRows(BiConsumer<Map<K, V>, RowView> accumulator) {
        return this.reduceRows(accumulator::accept);
    }

    default public <U> U reduceRows(U seed, BiFunction<U, RowView, U> accumulator) {
        return (U)this.scanResultSet((supplier, ctx) -> {
            try {
                Object object;
                block12: {
                    ResultSet rs = (ResultSet)supplier.get();
                    try {
                        RowViewImpl rv = new RowViewImpl(rs, ctx);
                        Object result = seed;
                        while (rs.next()) {
                            result = accumulator.apply(result, rv);
                        }
                        object = result;
                        if (rs == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e2) {
                            throw new UnableToProduceResultException(e2, ctx);
                        }
                    }
                    rs.close();
                }
                return object;
            }
            finally {
                ctx.close();
            }
        });
    }

    default public <U> U reduceResultSet(U seed, ResultSetAccumulator<U> accumulator) {
        return (U)this.scanResultSet((supplier, ctx) -> {
            try {
                Object object;
                block12: {
                    ResultSet rs = (ResultSet)supplier.get();
                    try {
                        Object result = seed;
                        while (rs.next()) {
                            result = accumulator.apply(result, rs, ctx);
                        }
                        object = result;
                        if (rs == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e2) {
                            throw new UnableToProduceResultException(e2, ctx);
                        }
                    }
                    rs.close();
                }
                return object;
            }
            finally {
                ctx.close();
            }
        });
    }

    default public <A, R> R collectRows(Collector<RowView, A, R> collector) {
        return (R)this.scanResultSet((supplier, ctx) -> {
            try {
                Object r2;
                block12: {
                    ResultSet rs = (ResultSet)supplier.get();
                    try {
                        RowViewImpl rv = new RowViewImpl(rs, ctx);
                        Object acc = collector.supplier().get();
                        BiConsumer consumer = collector.accumulator();
                        while (rs.next()) {
                            consumer.accept(acc, rv);
                        }
                        r2 = collector.finisher().apply(acc);
                        if (rs == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e2) {
                            throw new UnableToProduceResultException(e2, ctx);
                        }
                    }
                    rs.close();
                }
                return r2;
            }
            finally {
                ctx.close();
            }
        });
    }

    default public <R> R collectInto(Class<R> containerType) {
        return (R)this.collectInto((Type)containerType);
    }

    default public <R> R collectInto(GenericType<R> containerType) {
        return (R)this.collectInto(containerType.getType());
    }

    default public Object collectInto(Type containerType) {
        return this.scanResultSet((rs, ctx) -> {
            Collector<?, ?, ?> collector = ctx.findCollectorFor(containerType).orElseThrow(() -> new NoSuchCollectorException("No collector registered for container type " + containerType));
            Type elementType = ctx.findElementTypeFor(containerType).orElseThrow(() -> new ElementTypeNotFoundException("Unknown element type for container type " + containerType));
            RowMapper<?> mapper = ctx.findMapperFor(elementType).orElseThrow(() -> new NoSuchMapperException("No mapper registered for element type " + elementType));
            return ResultIterable.of(rs, mapper, ctx).collect(collector);
        });
    }
}

