/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect.internal;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.annotation.Unmappable;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.Nested;
import org.jdbi.v3.core.mapper.NoSuchMapperException;
import org.jdbi.v3.core.mapper.PropagateNull;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.SingleColumnMapper;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.ReflectionMapperUtil;
import org.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import org.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import org.jdbi.v3.core.mapper.reflect.internal.PojoTypes;
import org.jdbi.v3.core.result.UnableToProduceResultException;
import org.jdbi.v3.core.statement.StatementContext;

public class PojoMapper<T>
implements RowMapper<T> {
    private static final String NO_MATCHING_COLUMNS = "Mapping bean %s didn't find any matching columns in result set";
    private static final String UNMATCHED_COLUMNS_STRICT = "Mapping bean %s could not match properties for columns: %s";
    protected boolean strictColumnTypeMapping = true;
    protected final Type type;
    protected final String prefix;
    private final Map<PojoProperties.PojoProperty<T>, PojoMapper<?>> nestedMappers = new ConcurrentHashMap();

    public PojoMapper(Type type, String prefix) {
        this.type = type;
        this.prefix = prefix.toLowerCase();
    }

    @Override
    public T map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.specialize(rs, ctx).map(rs, ctx);
    }

    @Override
    public RowMapper<T> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        List<String> columnNames = ReflectionMapperUtil.getColumnNames(rs);
        List<ColumnNameMatcher> columnNameMatchers = ctx.getConfig(ReflectionMappers.class).getColumnNameMatchers();
        ArrayList<String> unmatchedColumns = new ArrayList<String>(columnNames);
        RowMapper<T> result = this.specialize0(ctx, columnNames, columnNameMatchers, unmatchedColumns).orElseThrow(() -> new IllegalArgumentException(String.format(NO_MATCHING_COLUMNS, this.type)));
        if (ctx.getConfig(ReflectionMappers.class).isStrictMatching() && ReflectionMapperUtil.anyColumnsStartWithPrefix(unmatchedColumns, this.prefix, columnNameMatchers)) {
            throw new IllegalArgumentException(String.format(UNMATCHED_COLUMNS_STRICT, this.type, unmatchedColumns));
        }
        return result;
    }

    private Optional<RowMapper<T>> specialize0(StatementContext ctx, List<String> columnNames, List<ColumnNameMatcher> columnNameMatchers, List<String> unmatchedColumns) {
        ArrayList propList = new ArrayList();
        for (PojoProperties.PojoProperty property : this.getProperties(ctx.getConfig()).getProperties().values()) {
            Nested anno = property.getAnnotation(Nested.class).orElse(null);
            if (property.getAnnotation(Unmappable.class).map(Unmappable::value).orElse(false).booleanValue()) continue;
            if (anno == null) {
                String paramName = this.prefix + this.getName(property);
                ReflectionMapperUtil.findColumnIndex(paramName, columnNames, columnNameMatchers, () -> this.debugName(property)).ifPresent(index -> {
                    ColumnMapper mapper = ctx.findColumnMapperFor(property.getQualifiedType().mapType(GenericTypes::box)).orElseGet(() -> this.defaultColumnMapper(property));
                    propList.add(new PropertyData(property, new SingleColumnMapper(mapper, index + 1)));
                    unmatchedColumns.remove(columnNames.get(index));
                });
                continue;
            }
            String nestedPrefix = this.prefix + anno.value();
            if (!ReflectionMapperUtil.anyColumnsStartWithPrefix(columnNames, nestedPrefix, columnNameMatchers)) continue;
            this.nestedMappers.computeIfAbsent(property, d2 -> this.createNestedMapper(ctx, (PojoProperties.PojoProperty<T>)d2, nestedPrefix)).specialize0(ctx, columnNames, columnNameMatchers, unmatchedColumns).ifPresent(nestedMapper -> propList.add(new PropertyData(property, (RowMapper<?>)nestedMapper)));
        }
        if (propList.isEmpty() && !columnNames.isEmpty()) {
            return Optional.empty();
        }
        Collections.sort(propList, Comparator.comparing(p2 -> p2.propagateNull ? 1 : 0));
        Optional<String> nullMarkerColumn = Optional.ofNullable(GenericTypes.getErasedType(this.type).getAnnotation(PropagateNull.class)).map(PropagateNull::value);
        return Optional.of((r2, c2) -> {
            if (PojoMapper.propagateNull(r2, nullMarkerColumn)) {
                return null;
            }
            PojoProperties.PojoBuilder pojo = this.getProperties(c2.getConfig()).create();
            for (PropertyData p2 : propList) {
                Object value = p2.mapper.map(r2, ctx);
                if (p2.propagateNull && (value == null || p2.isPrimitive && r2.wasNull())) {
                    return null;
                }
                if (value == null) continue;
                pojo.set(p2.property, value);
            }
            return pojo.build();
        });
    }

    protected PojoProperties<T> getProperties(ConfigRegistry config) {
        return config.get(PojoTypes.class).findFor(this.type).orElseThrow(() -> new UnableToProduceResultException("Couldn't find properties for " + this.type));
    }

    protected PojoMapper<?> createNestedMapper(StatementContext ctx, PojoProperties.PojoProperty<T> property, String nestedPrefix) {
        Type propertyType = property.getQualifiedType().getType();
        return new PojoMapper<T>(GenericTypes.getErasedType(propertyType), nestedPrefix);
    }

    public static boolean propagateNull(ResultSet r2, Optional<String> nullMarkerColumn) {
        return nullMarkerColumn.map(Unchecked.function(col -> {
            r2.getObject((String)col);
            return r2.wasNull();
        })).orElse(false);
    }

    private ColumnMapper<?> defaultColumnMapper(PojoProperties.PojoProperty<T> property) {
        if (this.strictColumnTypeMapping) {
            throw new NoSuchMapperException(String.format("Couldn't find mapper for property '%s' of type '%s' from %s", property.getName(), property.getQualifiedType(), this.type));
        }
        return (r2, n2, c2) -> r2.getObject(n2);
    }

    private String getName(PojoProperties.PojoProperty<T> property) {
        return property.getAnnotation(ColumnName.class).map(ColumnName::value).orElseGet(property::getName);
    }

    private String debugName(PojoProperties.PojoProperty<T> p2) {
        return String.format("%s.%s", this.type, p2.getName());
    }

    private static class PropertyData<T> {
        final PojoProperties.PojoProperty<T> property;
        final RowMapper<?> mapper;
        final boolean propagateNull;
        final boolean isPrimitive;

        PropertyData(PojoProperties.PojoProperty<T> property, RowMapper<?> mapper) {
            this.property = property;
            this.mapper = mapper;
            this.propagateNull = property.getAnnotation(PropagateNull.class).isPresent();
            this.isPrimitive = GenericTypes.getErasedType(property.getQualifiedType().getType()).isPrimitive();
        }
    }
}

