/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.mapper.reflect.ColumnName;

public class PojoBuilderUtils {
    private static final String[] GETTER_PREFIXES = new String[]{"get", "is"};

    private PojoBuilderUtils() {
        throw new UtilityClassException();
    }

    public static boolean isProperty(Method m3) {
        return m3.getParameterCount() == 0 && !m3.isSynthetic() && !Modifier.isStatic(m3.getModifiers()) && m3.getDeclaringClass() != Object.class;
    }

    public static String propertyName(Method m3) {
        ColumnName colName = m3.getAnnotation(ColumnName.class);
        if (colName != null) {
            return colName.value();
        }
        return PojoBuilderUtils.defaultSetterName(m3.getName());
    }

    public static String defaultSetterName(String name) {
        for (String prefix : GETTER_PREFIXES) {
            if (!name.startsWith(prefix) || name.length() <= prefix.length() || !Character.isUpperCase(name.charAt(prefix.length()))) continue;
            return PojoBuilderUtils.chopPrefix(name, prefix.length());
        }
        return name;
    }

    public static String chopPrefix(String name, int off) {
        return name.substring(off, off + 1).toLowerCase() + name.substring(off + 1);
    }

    private static Set<String> setterNames(String name) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        String rest = name.substring(0, 1).toUpperCase() + name.substring(1);
        names.add("set" + rest);
        names.add("is" + rest);
        return names;
    }

    public static MethodHandle findBuilderSetter(Class<?> builderClass, String name, Method decl, Type type) throws IllegalAccessException {
        ColumnName columnName;
        ArrayList<NoSuchMethodException> failures = new ArrayList<NoSuchMethodException>();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.add(PojoBuilderUtils.defaultSetterName(decl.getName()));
        names.add(name);
        if (name.length() > 1) {
            names.addAll(PojoBuilderUtils.setterNames(name));
        }
        if ((columnName = decl.getAnnotation(ColumnName.class)) != null && columnName.value().equals(name)) {
            names.addAll(PojoBuilderUtils.setterNames(PojoBuilderUtils.defaultSetterName(decl.getName())));
        }
        for (String tryName : names) {
            try {
                return MethodHandles.lookup().unreflect(builderClass.getMethod(tryName, GenericTypes.getErasedType(type)));
            }
            catch (NoSuchMethodException e2) {
                failures.add(e2);
            }
        }
        for (Method m3 : builderClass.getMethods()) {
            if (!names.contains(m3.getName()) || m3.getParameterCount() != 1) continue;
            return MethodHandles.lookup().unreflect(m3);
        }
        IllegalArgumentException iae = new IllegalArgumentException("Failed to find builder setter for property " + name + " on " + builderClass);
        failures.forEach(iae::addSuppressed);
        return MethodHandles.dropArguments(MethodHandles.throwException(Object.class, IllegalArgumentException.class), 1, Arrays.asList(Object.class, Object.class)).bindTo(iae);
    }

    public static MethodHandle alwaysSet() {
        return MethodHandles.dropArguments(MethodHandles.constant(Boolean.TYPE, true), 0, new Class[]{Object.class});
    }
}

