/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnGetter;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.ColumnMappers;
import org.jdbi.v3.core.mapper.GetterMapper;
import org.jdbi.v3.core.mapper.NoSuchMapperException;

class OptionalMapperFactory
implements ColumnMapperFactory {
    private static final Map<Class<?>, BiFunction<Type, ConfigRegistry, ColumnMapper<?>>> STRATEGIES;

    OptionalMapperFactory() {
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        return Optional.ofNullable(STRATEGIES.get(GenericTypes.getErasedType(type))).map(strategy -> (ColumnMapper)strategy.apply(type, config));
    }

    static BiFunction<Type, ConfigRegistry, ColumnMapper<?>> singleton(ColumnMapper<?> instance) {
        return (t2, c2) -> instance;
    }

    static <Opt, Box> ColumnMapper<?> create(ColumnGetter<Box> columnGetter, Supplier<Opt> empty, Function<Box, Opt> present) {
        return (r2, columnNumber, ctx) -> Optional.ofNullable(new GetterMapper(columnGetter).map(r2, columnNumber, ctx)).map(present).orElseGet(empty);
    }

    private static ColumnMapper<?> create(Type type, ConfigRegistry config) {
        ColumnMapper<?> mapper = config.get(ColumnMappers.class).findFor(GenericTypes.findGenericParameter(type, Optional.class).orElseThrow(() -> new NoSuchMapperException("No mapper for raw Optional type"))).orElseThrow(() -> new NoSuchMapperException("No mapper for type " + type + " nested in Optional"));
        return (r2, i2, ctx) -> Optional.ofNullable(mapper.map(r2, i2, ctx));
    }

    static {
        HashMap s2 = new HashMap();
        s2.put(Optional.class, OptionalMapperFactory::create);
        s2.put(OptionalInt.class, OptionalMapperFactory.singleton(OptionalMapperFactory.create(ResultSet::getInt, OptionalInt::empty, OptionalInt::of)));
        s2.put(OptionalLong.class, OptionalMapperFactory.singleton(OptionalMapperFactory.create(ResultSet::getLong, OptionalLong::empty, OptionalLong::of)));
        s2.put(OptionalDouble.class, OptionalMapperFactory.singleton(OptionalMapperFactory.create(ResultSet::getDouble, OptionalDouble::empty, OptionalDouble::of)));
        STRATEGIES = Collections.unmodifiableMap(s2);
    }
}

