/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.GetterMapper;

class JavaTimeMapperFactory
implements ColumnMapperFactory {
    private final Map<Class<?>, ColumnMapper<?>> mappers = new IdentityHashMap();

    JavaTimeMapperFactory() {
        this.mappers.put(Instant.class, new GetterMapper<Instant>(JavaTimeMapperFactory::getInstant));
        this.mappers.put(LocalDate.class, new GetterMapper<LocalDate>(JavaTimeMapperFactory::getLocalDate));
        this.mappers.put(LocalTime.class, new GetterMapper<LocalTime>(JavaTimeMapperFactory::getLocalTime));
        this.mappers.put(LocalDateTime.class, new GetterMapper<LocalDateTime>(JavaTimeMapperFactory::getLocalDateTime));
        this.mappers.put(OffsetDateTime.class, new GetterMapper<OffsetDateTime>(JavaTimeMapperFactory::getOffsetDateTime));
        this.mappers.put(ZonedDateTime.class, new GetterMapper<ZonedDateTime>(JavaTimeMapperFactory::getZonedDateTime));
        this.mappers.put(ZoneId.class, new GetterMapper<ZoneId>(JavaTimeMapperFactory::getZoneId));
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        Class<?> rawType = GenericTypes.getErasedType(type);
        return Optional.ofNullable(this.mappers.get(rawType));
    }

    private static Instant getInstant(ResultSet r2, int i2) throws SQLException {
        Timestamp ts = r2.getTimestamp(i2);
        return ts == null ? null : ts.toInstant();
    }

    private static LocalDate getLocalDate(ResultSet r2, int i2) throws SQLException {
        Timestamp ts = r2.getTimestamp(i2);
        return ts == null ? null : ts.toLocalDateTime().toLocalDate();
    }

    private static LocalDateTime getLocalDateTime(ResultSet r2, int i2) throws SQLException {
        Timestamp ts = r2.getTimestamp(i2);
        return ts == null ? null : ts.toLocalDateTime();
    }

    private static OffsetDateTime getOffsetDateTime(ResultSet r2, int i2) throws SQLException {
        Timestamp ts = r2.getTimestamp(i2);
        return ts == null ? null : OffsetDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
    }

    private static ZonedDateTime getZonedDateTime(ResultSet r2, int i2) throws SQLException {
        Timestamp ts = r2.getTimestamp(i2);
        return ts == null ? null : ZonedDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
    }

    private static LocalTime getLocalTime(ResultSet r2, int i2) throws SQLException {
        Time time = r2.getTime(i2);
        return time == null ? null : time.toLocalTime();
    }

    private static ZoneId getZoneId(ResultSet r2, int i2) throws SQLException {
        String id2 = r2.getString(i2);
        return id2 == null ? null : ZoneId.of(id2);
    }
}

