/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jdbi.v3.core.config.JdbiCache;
import org.jdbi.v3.core.config.JdbiCaches;
import org.jdbi.v3.core.enums.DatabaseValue;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.result.UnableToProduceResultException;
import org.jdbi.v3.core.statement.StatementContext;

public abstract class EnumMapper<E extends Enum<E>>
implements ColumnMapper<E> {
    EnumMapper() {
    }

    public static <E extends Enum<E>> ColumnMapper<E> byName(Class<E> type) {
        return new EnumByNameColumnMapper(type);
    }

    public static <E extends Enum<E>> ColumnMapper<E> byOrdinal(Class<E> type) {
        return new EnumByOrdinalColumnMapper(type);
    }

    static class EnumByNameColumnMapper<E extends Enum<E>>
    implements ColumnMapper<E> {
        private static final JdbiCache<Class<? extends Enum<?>>, JdbiCache<String, Enum<?>>> BY_NAME_CACHE = JdbiCaches.declare(e2 -> JdbiCaches.declare(name -> (Enum)e2.cast(EnumByNameColumnMapper.getValueByName(e2, name))));
        private final Class<E> enumClass;

        private EnumByNameColumnMapper(Class<E> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        public E map(ResultSet rs, int columnNumber, StatementContext ctx) throws SQLException {
            String name = rs.getString(columnNumber);
            return (E)(name == null || name.isEmpty() ? null : (Enum)this.enumClass.cast(BY_NAME_CACHE.get(this.enumClass, ctx).get(name, ctx)));
        }

        private static Object getValueByName(Class<? extends Enum<?>> enumClass, String name) {
            return Stream.concat(EnumByNameColumnMapper.enumConstants(enumClass).filter(EnumByNameColumnMapper.enumValueMatches(name, String::equals)), EnumByNameColumnMapper.enumConstants(enumClass).filter(EnumByNameColumnMapper.enumValueMatches(name, String::equalsIgnoreCase))).findFirst().orElseThrow(() -> new UnableToProduceResultException(String.format("no %s value could be matched to the name %s", enumClass.getSimpleName(), name)));
        }

        private static Predicate<Enum<?>> enumValueMatches(String name, BiPredicate<String, String> comparer) {
            return e2 -> Optional.ofNullable(Unchecked.function(e2.getClass()::getField).apply(e2.name()).getAnnotation(DatabaseValue.class)).map(DatabaseValue::value).map(dbName -> comparer.test((String)dbName, name)).orElseGet(() -> comparer.test(e2.name(), name));
        }

        private static Stream<Enum<?>> enumConstants(Class<? extends Enum<?>> enumClass) {
            return Arrays.stream(enumClass.getEnumConstants());
        }
    }

    static class EnumByOrdinalColumnMapper<E extends Enum<E>>
    implements ColumnMapper<E> {
        private final Class<E> enumClass;
        private final E[] enumConstants;

        private EnumByOrdinalColumnMapper(Class<E> enumClass) {
            this.enumClass = enumClass;
            this.enumConstants = (Enum[])enumClass.getEnumConstants();
        }

        @Override
        public E map(ResultSet rs, int columnNumber, StatementContext ctx) throws SQLException {
            int ordinal = rs.getInt(columnNumber);
            try {
                return rs.wasNull() ? null : (E)this.enumConstants[ordinal];
            }
            catch (ArrayIndexOutOfBoundsException oob) {
                throw new UnableToProduceResultException(String.format("no %s value could be matched to the ordinal %s", this.enumClass.getSimpleName(), ordinal), oob, ctx);
            }
        }
    }
}

