/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal.exceptions;

import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.internal.exceptions.CheckedBiConsumer;
import org.jdbi.v3.core.internal.exceptions.CheckedBiFunction;
import org.jdbi.v3.core.internal.exceptions.CheckedCallable;
import org.jdbi.v3.core.internal.exceptions.CheckedConsumer;
import org.jdbi.v3.core.internal.exceptions.CheckedFunction;
import org.jdbi.v3.core.internal.exceptions.CheckedSupplier;
import org.jdbi.v3.core.internal.exceptions.Sneaky;

public class Unchecked {
    private Unchecked() {
        throw new UtilityClassException();
    }

    public static <T> Consumer<T> consumer(CheckedConsumer<T> checkedConsumer) {
        return x2 -> {
            try {
                checkedConsumer.accept(x2);
            }
            catch (Throwable t2) {
                throw Sneaky.throwAnyway(t2);
            }
        };
    }

    public static Runnable runnable(CheckedRunnable checkedRunnable) {
        return () -> {
            try {
                checkedRunnable.run();
            }
            catch (Throwable t2) {
                throw Sneaky.throwAnyway(t2);
            }
        };
    }

    public static <T> SneakyCallable<T> callable(CheckedCallable<T> checkedCallable) {
        return () -> {
            try {
                return checkedCallable.call();
            }
            catch (Throwable t2) {
                throw Sneaky.throwAnyway(t2);
            }
        };
    }

    public static <T> Supplier<T> supplier(CheckedSupplier<T> checkedSupplier) {
        return () -> {
            try {
                return checkedSupplier.get();
            }
            catch (Throwable t2) {
                throw Sneaky.throwAnyway(t2);
            }
        };
    }

    public static <X, T> Function<X, T> function(CheckedFunction<X, T> checkedFunction) {
        return x2 -> {
            try {
                return checkedFunction.apply(x2);
            }
            catch (Throwable t2) {
                throw Sneaky.throwAnyway(t2);
            }
        };
    }

    public static <X, Y, T> BiFunction<X, Y, T> biFunction(CheckedBiFunction<X, Y, T> checkedBiFunction) {
        return (x2, y2) -> {
            try {
                return checkedBiFunction.apply(x2, y2);
            }
            catch (Throwable t2) {
                throw Sneaky.throwAnyway(t2);
            }
        };
    }

    public static <X, Y> BiConsumer<X, Y> biConsumer(CheckedBiConsumer<X, Y> checkedBiConsumer) {
        return (x2, y2) -> {
            try {
                checkedBiConsumer.accept(x2, y2);
            }
            catch (Throwable t2) {
                throw Sneaky.throwAnyway(t2);
            }
        };
    }

    public static interface CheckedRunnable {
        public void run() throws Exception;
    }

    public static interface SneakyCallable<T>
    extends Callable<T> {
        @Override
        public T call();
    }
}

