/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal.exceptions;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.internal.exceptions.DummyException;

public class Sneaky {
    private Sneaky() {
        throw new UtilityClassException();
    }

    @CheckReturnValue
    @Nonnull
    public static DummyException throwAnyway(Throwable t2) {
        if (t2 instanceof Error) {
            throw (Error)t2;
        }
        if (t2 instanceof RuntimeException) {
            throw (RuntimeException)t2;
        }
        if (t2 instanceof IOException) {
            throw new UncheckedIOException((IOException)t2);
        }
        if (t2 instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (t2 instanceof InvocationTargetException) {
            throw Sneaky.throwAnyway(t2.getCause());
        }
        Sneaky.throwEvadingChecks(t2);
        return null;
    }

    private static <E extends Throwable> void throwEvadingChecks(Throwable throwable) throws E {
        throw throwable;
    }
}

