/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Token;
import org.jdbi.v3.core.internal.lexer.SqlScriptLexer;
import org.jdbi.v3.core.statement.internal.ErrorListener;

public class SqlScriptParser {
    private final TokenHandler semicolonHandler;

    public SqlScriptParser(TokenHandler semicolonHandler) {
        this.semicolonHandler = semicolonHandler;
    }

    public String parse(CharStream charStream) {
        StringBuilder sb = new StringBuilder();
        SqlScriptLexer lexer = new SqlScriptLexer(charStream);
        lexer.addErrorListener(new ErrorListener());
        boolean endOfFile = false;
        block7: while (!endOfFile) {
            Token t2 = lexer.nextToken();
            switch (t2.getType()) {
                case -1: {
                    endOfFile = true;
                    continue block7;
                }
                case 5: {
                    this.semicolonHandler.handle(t2, sb);
                    continue block7;
                }
                case 1: 
                case 2: {
                    continue block7;
                }
                case 3: {
                    if (sb.length() <= 0) continue block7;
                    sb.append(' ');
                    continue block7;
                }
                case 4: 
                case 6: 
                case 7: {
                    sb.append(t2.getText());
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unrecognizable token " + t2);
        }
        return sb.toString();
    }

    public static interface TokenHandler {
        public void handle(Token var1, StringBuilder var2);
    }
}

