/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.internal.exceptions.Unchecked;

public class OnDemandExtensions
implements JdbiConfig<OnDemandExtensions> {
    private static final Method EQUALS_METHOD;
    private static final Method HASHCODE_METHOD;
    private static final Method TOSTRING_METHOD;
    private Factory factory;

    public OnDemandExtensions() {
        this.factory = (d2, x2, t2) -> Optional.empty();
    }

    private OnDemandExtensions(OnDemandExtensions other) {
        this.factory = other.factory;
    }

    public OnDemandExtensions setFactory(Factory factory2) {
        this.factory = factory2;
        return this;
    }

    public <E> E create(Jdbi db2, Class<E> extensionType, Class<?> ... extraTypes) {
        return extensionType.cast(this.factory.onDemand(db2, extensionType, extraTypes).orElseGet(() -> this.createProxy(db2, extensionType, extraTypes)));
    }

    private Object createProxy(Jdbi db2, Class<?> extensionType, Class<?> ... extraTypes) {
        db2.getConfig(Extensions.class).onCreateProxy();
        InvocationHandler handler = (proxy, method, args2) -> {
            if (EQUALS_METHOD.equals(method)) {
                return proxy == args2[0];
            }
            if (HASHCODE_METHOD.equals(method)) {
                return System.identityHashCode(proxy);
            }
            if (TOSTRING_METHOD.equals(method)) {
                return extensionType + "@" + Integer.toHexString(System.identityHashCode(proxy));
            }
            return db2.withExtension(extensionType, extension -> OnDemandExtensions.invoke(extension, method, args2));
        };
        Class[] types = (Class[])Stream.of(Stream.of(extensionType), Arrays.stream(extensionType.getInterfaces()), Arrays.stream(extraTypes)).flatMap(Function.identity()).distinct().toArray(Class[]::new);
        return Proxy.newProxyInstance(extensionType.getClassLoader(), types, handler);
    }

    private static Object invoke(Object target, Method method, Object[] args2) {
        if (Proxy.isProxyClass(target.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(target);
            return Unchecked.function(params -> handler.invoke(target, method, (Object[])params)).apply(args2);
        }
        MethodHandle handle = Unchecked.function(MethodHandles.lookup()::unreflect).apply(method).bindTo(target);
        return Unchecked.function(handle::invokeWithArguments).apply(args2);
    }

    @Override
    public OnDemandExtensions createCopy() {
        return new OnDemandExtensions(this);
    }

    static {
        try {
            EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
            HASHCODE_METHOD = Object.class.getMethod("hashCode", new Class[0]);
            TOSTRING_METHOD = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException wat) {
            throw new IllegalStateException("OnDemandExtensions initialization failed", wat);
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public Optional<Object> onDemand(Jdbi var1, Class<?> var2, Class<?> ... var3);
    }
}

