/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.array;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import org.jdbi.v3.core.array.SqlArrayType;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;

@FunctionalInterface
public interface SqlArrayTypeFactory {
    public Optional<SqlArrayType<?>> build(Type var1, ConfigRegistry var2);

    public static <T> SqlArrayTypeFactory of(Class<T> elementType, String typeName, Function<T, ?> conversion) {
        Optional arrayType = Optional.of(SqlArrayType.of(typeName, conversion));
        return (t2, c2) -> elementType == GenericTypes.getErasedType(t2) ? arrayType : Optional.empty();
    }
}

