/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.array;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.statement.StatementContext;

class CollectorColumnMapper<T, A, R>
implements ColumnMapper<R> {
    private final ColumnMapper<T> elementMapper;
    private final Collector<T, A, R> collector;

    CollectorColumnMapper(ColumnMapper<T> elementMapper, Collector<T, A, R> collector) {
        this.elementMapper = elementMapper;
        this.collector = collector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R map(ResultSet r2, int columnNumber, StatementContext ctx) throws SQLException {
        Array array = r2.getArray(columnNumber);
        if (array == null) {
            return null;
        }
        try {
            R r3 = this.buildFromResultSet(array, ctx);
            return r3;
        }
        finally {
            array.free();
        }
    }

    private R buildFromResultSet(Array array, StatementContext ctx) throws SQLException {
        A result = this.collector.supplier().get();
        BiConsumer<A, A> accumulator = this.collector.accumulator();
        try (ResultSet rs = array.getResultSet();){
            while (rs.next()) {
                accumulator.accept(result, this.elementMapper.map(rs, 2, ctx));
            }
        }
        return this.collector.finisher().apply(result);
    }
}

