/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.util.concurrent.Callable;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.internal.Invocations;
import org.jdbi.v3.core.internal.OnDemandHandleSupplier;

class LazyHandleSupplier
implements HandleSupplier,
AutoCloseable,
OnDemandHandleSupplier {
    private final Object[] lock = new Object[0];
    private final Jdbi db;
    private final ThreadLocal<ConfigRegistry> localConfig;
    private final ThreadLocal<ExtensionMethod> localExtensionMethod = new ThreadLocal();
    private volatile Handle handle;
    private volatile boolean closed = false;

    LazyHandleSupplier(Jdbi db2, ConfigRegistry config) {
        this.db = db2;
        this.localConfig = ThreadLocal.withInitial(() -> config);
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.localConfig.get();
    }

    @Override
    public Jdbi getJdbi() {
        return this.db;
    }

    @Override
    public Handle getHandle() {
        if (this.handle == null) {
            this.initHandle();
        }
        return this.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHandle() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            if (this.handle == null) {
                if (this.closed) {
                    throw new IllegalStateException("Handle is closed");
                }
                this.handle = this.db.open();
                this.handle.setExtensionMethodThreadLocal(this.localExtensionMethod);
                this.handle.setLocalConfig(this.localConfig);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public <V> V invokeInContext(ExtensionMethod extensionMethod, ConfigRegistry config, Callable<V> task) throws Exception {
        return (V)Invocations.invokeWith(this.localExtensionMethod, extensionMethod, () -> Invocations.invokeWith(this.localConfig, config, task));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            this.closed = true;
            if (this.handle == null) {
                this.localConfig.remove();
                this.localExtensionMethod.remove();
            } else {
                this.handle.close();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

