/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.gelfclient.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.graylog2.gelfclient.GelfConfiguration;
import org.graylog2.gelfclient.encoder.GelfMessageJsonEncoder;
import org.graylog2.gelfclient.encoder.GelfTcpFrameDelimiterEncoder;
import org.graylog2.gelfclient.transport.AbstractGelfTransport;
import org.graylog2.gelfclient.transport.GelfSenderThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GelfTcpTransport
extends AbstractGelfTransport {
    private static final Logger LOG = LoggerFactory.getLogger(GelfTcpTransport.class);

    public GelfTcpTransport(GelfConfiguration config) {
        super(config);
    }

    @Override
    protected void createBootstrap(EventLoopGroup workerGroup) {
        Bootstrap bootstrap = new Bootstrap();
        final GelfSenderThread senderThread = new GelfSenderThread(this.queue, this.config.getMaxInflightSends());
        this.senderThreadReference.set(senderThread);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.config.getConnectTimeout())).option(ChannelOption.TCP_NODELAY, this.config.isTcpNoDelay())).option(ChannelOption.SO_KEEPALIVE, this.config.isTcpKeepAlive())).remoteAddress(this.config.getRemoteAddress()).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch2) throws Exception {
                if (GelfTcpTransport.this.config.isTlsEnabled()) {
                    SslContext sslContext;
                    LOG.debug("TLS enabled.");
                    if (!GelfTcpTransport.this.config.isTlsCertVerificationEnabled()) {
                        LOG.debug("TLS certificate verification disabled!");
                        sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                    } else if (GelfTcpTransport.this.config.getTlsTrustCertChainFile() != null) {
                        LOG.debug("TLS certificate chain file: {}", (Object)GelfTcpTransport.this.config.getTlsTrustCertChainFile());
                        sslContext = SslContextBuilder.forClient().trustManager(GelfTcpTransport.this.config.getTlsTrustCertChainFile()).build();
                    } else {
                        sslContext = SslContextBuilder.forClient().build();
                    }
                    ch2.pipeline().addLast(sslContext.newHandler(ch2.alloc()));
                }
                ch2.pipeline().addLast(new GelfTcpFrameDelimiterEncoder());
                ch2.pipeline().addLast(new GelfMessageJsonEncoder());
                ch2.pipeline().addLast(new SimpleChannelInboundHandler<ByteBuf>(){

                    @Override
                    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
                    }

                    @Override
                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        senderThread.start(ctx.channel());
                    }

                    @Override
                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        LOG.info("Channel disconnected!");
                        senderThread.stop();
                        GelfTcpTransport.this.scheduleReconnect(ctx.channel().eventLoop());
                    }

                    @Override
                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        LOG.error("Exception caught", cause);
                    }
                });
            }
        });
        if (this.config.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, this.config.getSendBufferSize());
        }
        bootstrap.connect().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    LOG.debug("Connected!");
                } else {
                    LOG.error("Connection failed: {}", (Object)future.cause().getMessage());
                    GelfTcpTransport.this.scheduleReconnect(future.channel().eventLoop());
                }
            }
        });
    }
}

