/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.gelfclient.encoder;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Map;
import org.graylog2.gelfclient.GelfMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class GelfMessageJsonEncoder
extends MessageToMessageEncoder<GelfMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(GelfMessageJsonEncoder.class);
    private final JsonFactory jsonFactory;

    public GelfMessageJsonEncoder() {
        this(new JsonFactory());
    }

    public GelfMessageJsonEncoder(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        LOG.error("JSON encoding error", cause);
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, GelfMessage message, List<Object> out) throws Exception {
        out.add(Unpooled.wrappedBuffer(this.toJson(message)));
    }

    private byte[] toJson(GelfMessage message) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JsonGenerator jg2 = this.jsonFactory.createGenerator(out, JsonEncoding.UTF8);){
            jg2.writeStartObject();
            jg2.writeStringField("version", message.getVersion().toString());
            jg2.writeNumberField("timestamp", message.getTimestamp());
            jg2.writeStringField("host", message.getHost());
            jg2.writeStringField("short_message", message.getMessage());
            if (message.getLevel() != null) {
                jg2.writeNumberField("level", message.getLevel().getNumericLevel());
            }
            if (null != message.getFullMessage()) {
                jg2.writeStringField("full_message", message.getFullMessage());
            }
            for (Map.Entry<String, Object> field : message.getAdditionalFields().entrySet()) {
                String realKey;
                String string = realKey = field.getKey().startsWith("_") ? field.getKey() : "_" + field.getKey();
                if (field.getValue() instanceof Number) {
                    jg2.writeObjectField(realKey, field.getValue());
                    continue;
                }
                if (field.getValue() == null) {
                    jg2.writeNullField(realKey);
                    continue;
                }
                jg2.writeStringField(realKey, field.getValue().toString());
            }
            jg2.writeEndObject();
        }
        return out.toByteArray();
    }
}

