/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.spi;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.glassfish.jersey.spi.AbstractThreadPoolProvider;
import org.glassfish.jersey.spi.ExecutorServiceProvider;

public class ThreadPoolExecutorProvider
extends AbstractThreadPoolProvider<ThreadPoolExecutor>
implements ExecutorServiceProvider {
    private static final long CACHED_POOL_KEEP_ALIVE_DEFAULT_TIMEOUT = 60L;

    public ThreadPoolExecutorProvider(String name) {
        super(name);
    }

    @Override
    public ExecutorService getExecutorService() {
        return super.getExecutor();
    }

    @Override
    protected final ThreadPoolExecutor createExecutor(int corePoolSize, ThreadFactory threadFactory2, RejectedExecutionHandler handler) {
        return this.createExecutor(corePoolSize, this.getMaximumPoolSize(), this.getKeepAliveTime(), this.getWorkQueue(), threadFactory2, handler);
    }

    protected ThreadPoolExecutor createExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory2, RejectedExecutionHandler handler) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, workQueue, threadFactory2, handler);
    }

    protected int getMaximumPoolSize() {
        return Integer.MAX_VALUE;
    }

    protected long getKeepAliveTime() {
        return 60L;
    }

    protected BlockingQueue<Runnable> getWorkQueue() {
        return this.getMaximumPoolSize() == Integer.MAX_VALUE ? new SynchronousQueue() : new LinkedBlockingQueue();
    }

    @Override
    public void dispose(ExecutorService executorService) {
    }

    @PreDestroy
    public void preDestroy() {
        this.close();
    }
}

