/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.internal.util.ReflectionHelper;

public class AnnotatedMethod
implements AnnotatedElement {
    private static final Set<Class<? extends Annotation>> METHOD_META_ANNOTATIONS = AnnotatedMethod.getSet(HttpMethod.class);
    private static final Set<Class<? extends Annotation>> METHOD_ANNOTATIONS = AnnotatedMethod.getSet(Path.class, Produces.class, Consumes.class);
    private static final Set<Class<? extends Annotation>> PARAMETER_ANNOTATIONS = AnnotatedMethod.getSet(Context.class, Encoded.class, DefaultValue.class, MatrixParam.class, QueryParam.class, CookieParam.class, HeaderParam.class, PathParam.class, FormParam.class);
    private final Method m;
    private final Method am;
    private final Annotation[] methodAnnotations;
    private final Annotation[][] parameterAnnotations;

    @SafeVarargs
    private static Set<Class<? extends Annotation>> getSet(Class<? extends Annotation> ... cs2) {
        HashSet<Class<? extends Annotation>> s2 = new HashSet<Class<? extends Annotation>>();
        s2.addAll(Arrays.asList(cs2));
        return s2;
    }

    public AnnotatedMethod(Method method) {
        this.m = method;
        this.am = AnnotatedMethod.findAnnotatedMethod(method);
        if (method.equals(this.am)) {
            this.methodAnnotations = method.getAnnotations();
            this.parameterAnnotations = method.getParameterAnnotations();
        } else {
            this.methodAnnotations = AnnotatedMethod.mergeMethodAnnotations(method, this.am);
            this.parameterAnnotations = AnnotatedMethod.mergeParameterAnnotations(method, this.am);
        }
    }

    public Method getMethod() {
        return this.am;
    }

    public Method getDeclaredMethod() {
        return this.m;
    }

    public Annotation[][] getParameterAnnotations() {
        return (Annotation[][])this.parameterAnnotations.clone();
    }

    public Class<?>[] getParameterTypes() {
        return this.am.getParameterTypes();
    }

    public TypeVariable<Method>[] getTypeParameters() {
        return this.am.getTypeParameters();
    }

    public Type[] getGenericParameterTypes() {
        return this.am.getGenericParameterTypes();
    }

    public <T extends Annotation> List<T> getMetaMethodAnnotations(Class<T> annotation) {
        ArrayList<T> ma = new ArrayList<T>();
        for (Annotation a2 : this.methodAnnotations) {
            T metaAnnotation = a2.annotationType().getAnnotation(annotation);
            if (metaAnnotation == null) continue;
            ma.add(metaAnnotation);
        }
        return ma;
    }

    public String toString() {
        return this.m.toString();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        for (Annotation ma : this.methodAnnotations) {
            if (ma.annotationType() != annotationType) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation ma : this.methodAnnotations) {
            if (ma.annotationType() != annotationType) continue;
            return (T)((Annotation)annotationType.cast(ma));
        }
        return this.am.getAnnotation(annotationType);
    }

    @Override
    public Annotation[] getAnnotations() {
        return (Annotation[])this.methodAnnotations.clone();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    private static Annotation[] mergeMethodAnnotations(Method m3, Method am2) {
        List<Annotation> al2 = AnnotatedMethod.asList(m3.getAnnotations());
        for (Annotation a2 : am2.getAnnotations()) {
            if (m3.isAnnotationPresent(a2.getClass())) continue;
            al2.add(a2);
        }
        return al2.toArray(new Annotation[al2.size()]);
    }

    private static Annotation[][] mergeParameterAnnotations(Method m3, Method am2) {
        Annotation[][] methodParamAnnotations = m3.getParameterAnnotations();
        Annotation[][] annotatedMethodParamAnnotations = am2.getParameterAnnotations();
        ArrayList<List<Annotation>> methodParamAnnotationsList = new ArrayList<List<Annotation>>();
        for (int i2 = 0; i2 < methodParamAnnotations.length; ++i2) {
            List<Annotation> al2 = AnnotatedMethod.asList(methodParamAnnotations[i2]);
            for (Annotation a2 : annotatedMethodParamAnnotations[i2]) {
                if (!AnnotatedMethod.annotationNotInList(a2.getClass(), al2)) continue;
                al2.add(a2);
            }
            methodParamAnnotationsList.add(al2);
        }
        Annotation[][] mergedAnnotations = new Annotation[methodParamAnnotations.length][];
        for (int i3 = 0; i3 < methodParamAnnotations.length; ++i3) {
            List paramAnnotations = (List)methodParamAnnotationsList.get(i3);
            mergedAnnotations[i3] = paramAnnotations.toArray(new Annotation[paramAnnotations.size()]);
        }
        return mergedAnnotations;
    }

    private static boolean annotationNotInList(Class<? extends Annotation> ca2, List<Annotation> la2) {
        for (Annotation a2 : la2) {
            if (ca2 != a2.getClass()) continue;
            return false;
        }
        return true;
    }

    private static Method findAnnotatedMethod(Method m3) {
        Method am2 = AnnotatedMethod.findAnnotatedMethod(m3.getDeclaringClass(), m3);
        return am2 != null ? am2 : m3;
    }

    private static Method findAnnotatedMethod(Class<?> c2, Method m3) {
        Method sm;
        if (c2 == Object.class) {
            return null;
        }
        if ((m3 = AccessController.doPrivileged(ReflectionHelper.findMethodOnClassPA(c2, m3))) == null) {
            return null;
        }
        if (AnnotatedMethod.hasAnnotations(m3)) {
            return m3;
        }
        Class<?> sc = c2.getSuperclass();
        if (sc != null && sc != Object.class && (sm = AnnotatedMethod.findAnnotatedMethod(sc, m3)) != null) {
            return sm;
        }
        for (Class<?> ic2 : c2.getInterfaces()) {
            Method im2 = AnnotatedMethod.findAnnotatedMethod(ic2, m3);
            if (im2 == null) continue;
            return im2;
        }
        return null;
    }

    private static boolean hasAnnotations(Method m3) {
        return AnnotatedMethod.hasMetaMethodAnnotations(m3) || AnnotatedMethod.hasMethodAnnotations(m3) || AnnotatedMethod.hasParameterAnnotations(m3);
    }

    private static boolean hasMetaMethodAnnotations(Method m3) {
        for (Class<? extends Annotation> ac2 : METHOD_META_ANNOTATIONS) {
            for (Annotation a2 : m3.getAnnotations()) {
                if (a2.annotationType().getAnnotation(ac2) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasMethodAnnotations(Method m3) {
        for (Class<? extends Annotation> ac2 : METHOD_ANNOTATIONS) {
            if (!m3.isAnnotationPresent(ac2)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasParameterAnnotations(Method m3) {
        Annotation[][] annotationArray = m3.getParameterAnnotations();
        int n2 = annotationArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Annotation[] as2;
            for (Annotation a2 : as2 = annotationArray[i2]) {
                if (!PARAMETER_ANNOTATIONS.contains(a2.annotationType())) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    private static <T> List<T> asList(T ... ts) {
        ArrayList<T> l2 = new ArrayList<T>();
        l2.addAll(Arrays.asList(ts));
        return l2;
    }
}

