/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.AcceptableLanguageTag;
import org.glassfish.jersey.message.internal.AcceptableMediaType;
import org.glassfish.jersey.message.internal.AcceptableToken;
import org.glassfish.jersey.message.internal.InboundMessageContext;
import org.glassfish.jersey.message.internal.Qualified;
import org.glassfish.jersey.message.internal.QualitySourceMediaType;

public final class VariantSelector {
    private static final DimensionChecker<AcceptableMediaType, MediaType> MEDIA_TYPE_DC = new DimensionChecker<AcceptableMediaType, MediaType>(){

        @Override
        public MediaType getDimension(VariantHolder v2) {
            return v2.v.getMediaType();
        }

        @Override
        public boolean isCompatible(AcceptableMediaType t2, MediaType u2) {
            return t2.isCompatible(u2);
        }

        @Override
        public int getQualitySource(VariantHolder v2, MediaType u2) {
            return v2.mediaTypeQs;
        }

        @Override
        public String getVaryHeaderValue() {
            return "Accept";
        }
    };
    private static final DimensionChecker<AcceptableLanguageTag, Locale> LANGUAGE_TAG_DC = new DimensionChecker<AcceptableLanguageTag, Locale>(){

        @Override
        public Locale getDimension(VariantHolder v2) {
            return v2.v.getLanguage();
        }

        @Override
        public boolean isCompatible(AcceptableLanguageTag t2, Locale u2) {
            return t2.isCompatible(u2);
        }

        @Override
        public int getQualitySource(VariantHolder qsv, Locale u2) {
            return 0;
        }

        @Override
        public String getVaryHeaderValue() {
            return "Accept-Language";
        }
    };
    private static final DimensionChecker<AcceptableToken, String> CHARSET_DC = new DimensionChecker<AcceptableToken, String>(){

        @Override
        public String getDimension(VariantHolder v2) {
            MediaType m3 = v2.v.getMediaType();
            return m3 != null ? m3.getParameters().get("charset") : null;
        }

        @Override
        public boolean isCompatible(AcceptableToken t2, String u2) {
            return t2.isCompatible(u2);
        }

        @Override
        public int getQualitySource(VariantHolder qsv, String u2) {
            return 0;
        }

        @Override
        public String getVaryHeaderValue() {
            return "Accept-Charset";
        }
    };
    private static final DimensionChecker<AcceptableToken, String> ENCODING_DC = new DimensionChecker<AcceptableToken, String>(){

        @Override
        public String getDimension(VariantHolder v2) {
            return v2.v.getEncoding();
        }

        @Override
        public boolean isCompatible(AcceptableToken t2, String u2) {
            return t2.isCompatible(u2);
        }

        @Override
        public int getQualitySource(VariantHolder qsv, String u2) {
            return 0;
        }

        @Override
        public String getVaryHeaderValue() {
            return "Accept-Encoding";
        }
    };

    private VariantSelector() {
    }

    private static <T extends Qualified, U> LinkedList<VariantHolder> selectVariants(List<VariantHolder> variantHolders, List<T> acceptableValues, DimensionChecker<T, U> dimensionChecker, Set<String> vary) {
        int cq2 = 0;
        int cqs = 0;
        LinkedList<VariantHolder> selected = new LinkedList<VariantHolder>();
        for (Qualified a2 : acceptableValues) {
            int q2 = a2.getQuality();
            Iterator<VariantHolder> iv2 = variantHolders.iterator();
            while (iv2.hasNext()) {
                VariantHolder v2 = iv2.next();
                U d2 = dimensionChecker.getDimension(v2);
                if (d2 == null) continue;
                vary.add(dimensionChecker.getVaryHeaderValue());
                int qs = dimensionChecker.getQualitySource(v2, d2);
                if (qs < cqs || !dimensionChecker.isCompatible(a2, d2)) continue;
                if (qs > cqs) {
                    cqs = qs;
                    cq2 = q2;
                    selected.clear();
                    selected.add(v2);
                } else if (q2 > cq2) {
                    cq2 = q2;
                    selected.addFirst(v2);
                } else if (q2 == cq2) {
                    selected.add(v2);
                }
                iv2.remove();
            }
        }
        for (VariantHolder v3 : variantHolders) {
            if (dimensionChecker.getDimension(v3) != null) continue;
            selected.add(v3);
        }
        return selected;
    }

    private static LinkedList<VariantHolder> getVariantHolderList(List<Variant> variants) {
        LinkedList<VariantHolder> l2 = new LinkedList<VariantHolder>();
        for (Variant v2 : variants) {
            MediaType mt = v2.getMediaType();
            if (mt != null) {
                if (mt instanceof QualitySourceMediaType || mt.getParameters().containsKey("qs")) {
                    int qs = QualitySourceMediaType.getQualitySource(mt);
                    l2.add(new VariantHolder(v2, qs));
                    continue;
                }
                l2.add(new VariantHolder(v2));
                continue;
            }
            l2.add(new VariantHolder(v2));
        }
        return l2;
    }

    public static Variant selectVariant(InboundMessageContext context, List<Variant> variants, Ref<String> varyHeaderValue) {
        List<Variant> selectedVariants = VariantSelector.selectVariants(context, variants, varyHeaderValue);
        return selectedVariants.isEmpty() ? null : selectedVariants.get(0);
    }

    public static List<Variant> selectVariants(InboundMessageContext context, List<Variant> variants, Ref<String> varyHeaderValue) {
        LinkedList<VariantHolder> vhs = VariantSelector.getVariantHolderList(variants);
        HashSet<String> vary = new HashSet<String>();
        vhs = VariantSelector.selectVariants(vhs, context.getQualifiedAcceptableMediaTypes(), MEDIA_TYPE_DC, vary);
        vhs = VariantSelector.selectVariants(vhs, context.getQualifiedAcceptableLanguages(), LANGUAGE_TAG_DC, vary);
        vhs = VariantSelector.selectVariants(vhs, context.getQualifiedAcceptCharset(), CHARSET_DC, vary);
        if ((vhs = VariantSelector.selectVariants(vhs, context.getQualifiedAcceptEncoding(), ENCODING_DC, vary)).isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder varyHeader = new StringBuilder();
        for (String v2 : vary) {
            if (varyHeader.length() > 0) {
                varyHeader.append(',');
            }
            varyHeader.append(v2);
        }
        String varyValue = varyHeader.toString();
        if (!varyValue.isEmpty()) {
            varyHeaderValue.set(varyValue);
        }
        return vhs.stream().map(variantHolder -> ((VariantHolder)variantHolder).v).collect(Collectors.toList());
    }

    private static class VariantHolder {
        private final Variant v;
        private final int mediaTypeQs;

        VariantHolder(Variant v2) {
            this(v2, 1000);
        }

        VariantHolder(Variant v2, int mediaTypeQs) {
            this.v = v2;
            this.mediaTypeQs = mediaTypeQs;
        }
    }

    private static interface DimensionChecker<T, U> {
        public U getDimension(VariantHolder var1);

        public int getQualitySource(VariantHolder var1, U var2);

        public boolean isCompatible(T var1, U var2);

        public String getVaryHeaderValue();
    }
}

